/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.app;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.incongru.berkano.app.Application;
import net.incongru.berkano.app.PreferenceInfo;

public class ApplicationsProvider {
    private static final Application NULL_APP = new NullApp();
    private Map appsMap;

    public ApplicationsProvider(Application[] apps) {
        this.appsMap = new HashMap(apps.length);
        for (int i = 0; i < apps.length; ++i) {
            Application app = apps[i];
            this.appsMap.put(app.getName(), app);
        }
    }

    public Application getApp(String appName) {
        Application app = (Application)this.appsMap.get(appName);
        if (app == null) {
            return NULL_APP;
        }
        return app;
    }

    public Collection getAllApps() {
        return this.appsMap.values();
    }

    private static final class NullApp
    implements Application {
        private NullApp() {
        }

        public String getName() {
            return null;
        }

        public Object newPreferencesModel() {
            return null;
        }

        public PreferenceInfo[] getPreferencesInfo() {
            return new PreferenceInfo[0];
        }
    }
}

