/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.security.password.matching;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.incongru.berkano.security.password.PasswordMatchingStrategy;
import net.incongru.berkano.user.User;
import org.apache.commons.codec.binary.Hex;

public abstract class AbstractMessageDigestPasswordMatchingStrategy
implements PasswordMatchingStrategy {
    public boolean matches(String givenPassword, User user) {
        String hash = this.encode(givenPassword);
        return hash.equals(user.getPassword());
    }

    public String encode(String clearPassword) {
        try {
            MessageDigest md = this.getMessageDigest();
            byte[] digest = md.digest(clearPassword.getBytes());
            char[] hex = Hex.encodeHex((byte[])digest);
            return new String(hex);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract MessageDigest getMessageDigest() throws NoSuchAlgorithmException;
}

