/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.typemap.config;

import berlin.yuna.typemap.model.FunctionOrNull;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class TypeConversionRegister {
    public static final Map<Class<?>, Map<Class<?>, FunctionOrNull>> TYPE_CONVERSIONS = new ConcurrentHashMap();
    public static final DateTimeFormatter[] DATE_TIME_FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ISO_ZONED_DATE_TIME, DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_ORDINAL_DATE, DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ISO_OFFSET_DATE, DateTimeFormatter.ISO_LOCAL_TIME, DateTimeFormatter.ISO_OFFSET_TIME, DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.BASIC_ISO_DATE, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_TIME, DateTimeFormatter.ISO_WEEK_DATE, new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("EEE MMM dd HH:mm:ss ").appendZoneText(TextStyle.SHORT).appendPattern(" yyyy").toFormatter(Locale.ENGLISH)};
    public static final String LINE_SEPARATOR = System.lineSeparator();

    public static <S, T> void registerTypeConvert(Class<S> sourceType, Class<T> targetType, FunctionOrNull<S, T> conversion) {
        TYPE_CONVERSIONS.computeIfAbsent(targetType, k -> new HashMap()).put(sourceType, conversion);
    }

    public static <T> T temporalOf(String string, Function<TemporalAccessor, T> converter) {
        for (DateTimeFormatter formatter : DATE_TIME_FORMATTERS) {
            try {
                return converter.apply(formatter.parse(string));
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static Calendar calendarOf(long timeInMs) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMs);
        return calendar;
    }

    public static Calendar calendarOf(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        Calendar.getInstance().setTime(date);
        return cal;
    }

    public static Calendar calendarOf(LocalTime localTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, localTime.getHour());
        cal.set(12, localTime.getMinute());
        cal.set(13, localTime.getSecond());
        cal.set(14, localTime.getNano() / 1000000);
        return cal;
    }

    public static String stringOf(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : throwable.getStackTrace()) {
            if (ste.getClassName().startsWith("java.") || ste.getClassName().startsWith("javax.")) continue;
            sb.append("\tat ").append(ste).append(LINE_SEPARATOR);
        }
        if (sb.length() == 0) {
            for (StackTraceElement ste : throwable.getStackTrace()) {
                sb.append("\tat ").append(ste).append(LINE_SEPARATOR);
            }
        }
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            sb.append("Caused by: ").append(cause).append(LINE_SEPARATOR);
            for (StackTraceElement ste : cause.getStackTrace()) {
                if (ste.getClassName().startsWith("java.") || ste.getClassName().startsWith("javax.")) continue;
                sb.append("\tat ").append(ste).append(LINE_SEPARATOR);
            }
        }
        return sb.toString();
    }

    private TypeConversionRegister() {
    }

    static {
        TypeConversionRegister.registerTypeConvert(Number.class, Long.class, Number::longValue);
        TypeConversionRegister.registerTypeConvert(Number.class, Integer.class, Number::intValue);
        TypeConversionRegister.registerTypeConvert(Number.class, Float.class, Number::floatValue);
        TypeConversionRegister.registerTypeConvert(Number.class, Double.class, Number::doubleValue);
        TypeConversionRegister.registerTypeConvert(Number.class, Short.class, Number::shortValue);
        TypeConversionRegister.registerTypeConvert(Number.class, Byte.class, Number::byteValue);
        TypeConversionRegister.registerTypeConvert(Number.class, BigInteger.class, number -> BigInteger.valueOf(number.longValue()));
        TypeConversionRegister.registerTypeConvert(Number.class, BigDecimal.class, number -> BigDecimal.valueOf(number.doubleValue()));
        TypeConversionRegister.registerTypeConvert(Number.class, Number.class, number -> number);
        TypeConversionRegister.registerTypeConvert(Number.class, Boolean.class, number -> number.intValue() == 1);
        TypeConversionRegister.registerTypeConvert(AtomicInteger.class, Integer.class, AtomicInteger::get);
        TypeConversionRegister.registerTypeConvert(Number.class, AtomicInteger.class, number -> new AtomicInteger(number.intValue()));
        TypeConversionRegister.registerTypeConvert(AtomicLong.class, Long.class, AtomicLong::get);
        TypeConversionRegister.registerTypeConvert(Number.class, AtomicLong.class, number -> new AtomicLong(number.longValue()));
        TypeConversionRegister.registerTypeConvert(AtomicBoolean.class, Boolean.class, AtomicBoolean::get);
        TypeConversionRegister.registerTypeConvert(Boolean.class, AtomicBoolean.class, AtomicBoolean::new);
        TypeConversionRegister.registerTypeConvert(Integer.TYPE, Integer.class, Integer::valueOf);
        TypeConversionRegister.registerTypeConvert(Long.TYPE, Long.class, Long::valueOf);
        TypeConversionRegister.registerTypeConvert(Short.TYPE, Short.class, Short::valueOf);
        TypeConversionRegister.registerTypeConvert(Byte.TYPE, Byte.class, Byte::valueOf);
        TypeConversionRegister.registerTypeConvert(Float.TYPE, Float.class, Float::valueOf);
        TypeConversionRegister.registerTypeConvert(Double.TYPE, Double.class, Double::valueOf);
        TypeConversionRegister.registerTypeConvert(Character.TYPE, Character.class, Character::valueOf);
        TypeConversionRegister.registerTypeConvert(Boolean.TYPE, Boolean.class, Boolean::valueOf);
        TypeConversionRegister.registerTypeConvert(Integer.class, Integer.TYPE, Integer::intValue);
        TypeConversionRegister.registerTypeConvert(Long.class, Long.TYPE, Long::longValue);
        TypeConversionRegister.registerTypeConvert(Short.class, Short.TYPE, Short::shortValue);
        TypeConversionRegister.registerTypeConvert(Byte.class, Byte.TYPE, Byte::byteValue);
        TypeConversionRegister.registerTypeConvert(Float.class, Float.TYPE, Float::floatValue);
        TypeConversionRegister.registerTypeConvert(Double.class, Double.TYPE, Double::doubleValue);
        TypeConversionRegister.registerTypeConvert(Character.class, Character.TYPE, Character::charValue);
        TypeConversionRegister.registerTypeConvert(Boolean.class, Boolean.TYPE, Boolean::booleanValue);
        TypeConversionRegister.registerTypeConvert(String.class, Character.class, string -> Character.valueOf(string.charAt(0)));
        TypeConversionRegister.registerTypeConvert(Character.class, String.class, Object::toString);
        TypeConversionRegister.registerTypeConvert(UUID.class, String.class, UUID::toString);
        TypeConversionRegister.registerTypeConvert(String.class, UUID.class, UUID::fromString);
        TypeConversionRegister.registerTypeConvert(String.class, Boolean.class, string -> Boolean.parseBoolean(string) || "1".equals(string));
        TypeConversionRegister.registerTypeConvert(Enum.class, String.class, Enum::name);
        TypeConversionRegister.registerTypeConvert(Throwable.class, String.class, TypeConversionRegister::stringOf);
        TypeConversionRegister.registerTypeConvert(String.class, Integer.class, Integer::valueOf);
        TypeConversionRegister.registerTypeConvert(String.class, Long.class, Long::valueOf);
        TypeConversionRegister.registerTypeConvert(String.class, Float.class, Float::valueOf);
        TypeConversionRegister.registerTypeConvert(String.class, Double.class, Double::valueOf);
        TypeConversionRegister.registerTypeConvert(String.class, Short.class, Short::valueOf);
        TypeConversionRegister.registerTypeConvert(String.class, Byte.class, Byte::valueOf);
        TypeConversionRegister.registerTypeConvert(String.class, BigInteger.class, BigInteger::new);
        TypeConversionRegister.registerTypeConvert(String.class, BigDecimal.class, BigDecimal::new);
        TypeConversionRegister.registerTypeConvert(String.class, Number.class, Double::valueOf);
        TypeConversionRegister.registerTypeConvert(StringBuilder.class, String.class, StringBuilder::toString);
        TypeConversionRegister.registerTypeConvert(String.class, StringBuilder.class, StringBuilder::new);
        TypeConversionRegister.registerTypeConvert(Path.class, File.class, Path::toFile);
        TypeConversionRegister.registerTypeConvert(Path.class, URI.class, Path::toUri);
        TypeConversionRegister.registerTypeConvert(Path.class, URL.class, path -> path.toUri().toURL());
        TypeConversionRegister.registerTypeConvert(Path.class, String.class, Path::toString);
        TypeConversionRegister.registerTypeConvert(File.class, Path.class, File::toPath);
        TypeConversionRegister.registerTypeConvert(File.class, URI.class, File::toURI);
        TypeConversionRegister.registerTypeConvert(File.class, URL.class, file -> file.toURI().toURL());
        TypeConversionRegister.registerTypeConvert(File.class, String.class, File::toString);
        TypeConversionRegister.registerTypeConvert(URI.class, File.class, File::new);
        TypeConversionRegister.registerTypeConvert(URI.class, Path.class, Paths::get);
        TypeConversionRegister.registerTypeConvert(URI.class, String.class, URI::toString);
        TypeConversionRegister.registerTypeConvert(URI.class, URL.class, URI::toURL);
        TypeConversionRegister.registerTypeConvert(URL.class, File.class, url -> new File(url.toURI()));
        TypeConversionRegister.registerTypeConvert(URL.class, Path.class, url -> Paths.get(url.toURI()));
        TypeConversionRegister.registerTypeConvert(URL.class, String.class, URL::toString);
        TypeConversionRegister.registerTypeConvert(URL.class, URI.class, URL::toURI);
        TypeConversionRegister.registerTypeConvert(String.class, Path.class, x$0 -> Paths.get(x$0, new String[0]));
        TypeConversionRegister.registerTypeConvert(String.class, File.class, File::new);
        TypeConversionRegister.registerTypeConvert(String.class, URL.class, string -> Paths.get(string, new String[0]).toUri().toURL());
        TypeConversionRegister.registerTypeConvert(String.class, URI.class, URI::new);
        TypeConversionRegister.registerTypeConvert(InetAddress.class, String.class, InetAddress::toString);
        TypeConversionRegister.registerTypeConvert(String.class, InetAddress.class, InetAddress::getByName);
        TypeConversionRegister.registerTypeConvert(String.class, Inet4Address.class, string -> (Inet4Address)InetAddress.getByName(string));
        TypeConversionRegister.registerTypeConvert(String.class, Inet6Address.class, string -> (Inet6Address)InetAddress.getByName(string));
        TypeConversionRegister.registerTypeConvert(java.util.Date.class, Instant.class, java.util.Date::toInstant);
        TypeConversionRegister.registerTypeConvert(java.util.Date.class, Calendar.class, TypeConversionRegister::calendarOf);
        TypeConversionRegister.registerTypeConvert(java.util.Date.class, LocalDateTime.class, date -> LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(java.util.Date.class, LocalDate.class, date -> date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        TypeConversionRegister.registerTypeConvert(java.util.Date.class, LocalTime.class, date -> date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime());
        TypeConversionRegister.registerTypeConvert(java.util.Date.class, OffsetDateTime.class, date -> date.toInstant().atOffset(ZoneId.systemDefault().getRules().getOffset(Instant.now())));
        TypeConversionRegister.registerTypeConvert(java.util.Date.class, ZonedDateTime.class, date -> date.toInstant().atZone(ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(java.util.Date.class, Date.class, date -> new Date(date.getTime()));
        TypeConversionRegister.registerTypeConvert(java.util.Date.class, Time.class, date -> new Time(date.getTime()));
        TypeConversionRegister.registerTypeConvert(java.util.Date.class, Timestamp.class, date -> new Timestamp(date.getTime()));
        TypeConversionRegister.registerTypeConvert(Instant.class, java.util.Date.class, java.util.Date::from);
        TypeConversionRegister.registerTypeConvert(Instant.class, Calendar.class, instant -> TypeConversionRegister.calendarOf(instant.toEpochMilli()));
        TypeConversionRegister.registerTypeConvert(Instant.class, LocalDateTime.class, instant -> instant.atZone(ZoneId.systemDefault()).toLocalDateTime());
        TypeConversionRegister.registerTypeConvert(Instant.class, LocalDate.class, instant -> instant.atZone(ZoneId.systemDefault()).toLocalDate());
        TypeConversionRegister.registerTypeConvert(Instant.class, LocalTime.class, instant -> instant.atZone(ZoneId.systemDefault()).toLocalTime());
        TypeConversionRegister.registerTypeConvert(Instant.class, OffsetDateTime.class, instant -> instant.atOffset(ZoneId.systemDefault().getRules().getOffset((Instant)instant)));
        TypeConversionRegister.registerTypeConvert(Instant.class, ZonedDateTime.class, instant -> instant.atZone(ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(Instant.class, Date.class, instant -> new Date(instant.toEpochMilli()));
        TypeConversionRegister.registerTypeConvert(Instant.class, Time.class, instant -> new Time(instant.toEpochMilli()));
        TypeConversionRegister.registerTypeConvert(Instant.class, Timestamp.class, Timestamp::from);
        TypeConversionRegister.registerTypeConvert(Calendar.class, Instant.class, Calendar::toInstant);
        TypeConversionRegister.registerTypeConvert(Calendar.class, java.util.Date.class, Calendar::getTime);
        TypeConversionRegister.registerTypeConvert(Calendar.class, LocalDateTime.class, calendar -> LocalDateTime.ofInstant(calendar.toInstant(), ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(Calendar.class, LocalDate.class, calendar -> LocalDateTime.ofInstant(calendar.toInstant(), ZoneId.systemDefault()).toLocalDate());
        TypeConversionRegister.registerTypeConvert(Calendar.class, LocalTime.class, calendar -> LocalDateTime.ofInstant(calendar.toInstant(), ZoneId.systemDefault()).toLocalTime());
        TypeConversionRegister.registerTypeConvert(Calendar.class, OffsetDateTime.class, calendar -> OffsetDateTime.ofInstant(calendar.toInstant(), ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(Calendar.class, ZonedDateTime.class, calendar -> ZonedDateTime.ofInstant(calendar.toInstant(), ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(Calendar.class, Date.class, calendar -> new Date(calendar.getTimeInMillis()));
        TypeConversionRegister.registerTypeConvert(Calendar.class, Time.class, calendar -> new Time(calendar.getTimeInMillis()));
        TypeConversionRegister.registerTypeConvert(Calendar.class, Timestamp.class, calendar -> new Timestamp(calendar.getTimeInMillis()));
        TypeConversionRegister.registerTypeConvert(LocalDateTime.class, Instant.class, ldt -> ldt.atZone(ZoneId.systemDefault()).toInstant());
        TypeConversionRegister.registerTypeConvert(LocalDateTime.class, Calendar.class, ldt -> TypeConversionRegister.calendarOf(java.util.Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant())));
        TypeConversionRegister.registerTypeConvert(LocalDateTime.class, java.util.Date.class, ldt -> java.util.Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant()));
        TypeConversionRegister.registerTypeConvert(LocalDateTime.class, LocalDate.class, LocalDateTime::toLocalDate);
        TypeConversionRegister.registerTypeConvert(LocalDateTime.class, LocalTime.class, LocalDateTime::toLocalTime);
        TypeConversionRegister.registerTypeConvert(LocalDateTime.class, OffsetDateTime.class, ldt -> ldt.atZone(ZoneId.systemDefault()).toOffsetDateTime());
        TypeConversionRegister.registerTypeConvert(LocalDateTime.class, ZonedDateTime.class, ldt -> ldt.atZone(ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(LocalDateTime.class, Date.class, ldt -> Date.valueOf(ldt.toLocalDate()));
        TypeConversionRegister.registerTypeConvert(LocalDateTime.class, Time.class, ldt -> Time.valueOf(ldt.toLocalTime()));
        TypeConversionRegister.registerTypeConvert(LocalDateTime.class, Timestamp.class, Timestamp::valueOf);
        TypeConversionRegister.registerTypeConvert(LocalDate.class, Instant.class, ld -> ld.atStartOfDay(ZoneId.systemDefault()).toInstant());
        TypeConversionRegister.registerTypeConvert(LocalDate.class, Calendar.class, ld -> TypeConversionRegister.calendarOf(java.util.Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant())));
        TypeConversionRegister.registerTypeConvert(LocalDate.class, LocalDateTime.class, LocalDate::atStartOfDay);
        TypeConversionRegister.registerTypeConvert(LocalDate.class, java.util.Date.class, ld -> java.util.Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        TypeConversionRegister.registerTypeConvert(LocalDate.class, LocalTime.class, ld -> null);
        TypeConversionRegister.registerTypeConvert(LocalDate.class, OffsetDateTime.class, ld -> ld.atStartOfDay(ZoneId.systemDefault()).toOffsetDateTime());
        TypeConversionRegister.registerTypeConvert(LocalDate.class, ZonedDateTime.class, ld -> ld.atStartOfDay(ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(LocalDate.class, Date.class, Date::valueOf);
        TypeConversionRegister.registerTypeConvert(LocalDate.class, Time.class, ld -> null);
        TypeConversionRegister.registerTypeConvert(LocalDate.class, Timestamp.class, ld -> Timestamp.valueOf(ld.atStartOfDay()));
        TypeConversionRegister.registerTypeConvert(LocalTime.class, Instant.class, lt -> null);
        TypeConversionRegister.registerTypeConvert(LocalTime.class, Calendar.class, TypeConversionRegister::calendarOf);
        TypeConversionRegister.registerTypeConvert(LocalTime.class, LocalDateTime.class, lt -> lt.atDate(LocalDate.now()));
        TypeConversionRegister.registerTypeConvert(LocalTime.class, LocalDate.class, lt -> null);
        TypeConversionRegister.registerTypeConvert(LocalTime.class, java.util.Date.class, lt -> TypeConversionRegister.calendarOf(lt).getTime());
        TypeConversionRegister.registerTypeConvert(LocalTime.class, OffsetDateTime.class, lt -> OffsetDateTime.of(LocalDate.MIN, lt, ZoneId.systemDefault().getRules().getOffset(Instant.now())));
        TypeConversionRegister.registerTypeConvert(LocalTime.class, ZonedDateTime.class, lt -> ZonedDateTime.of(LocalDate.MIN, lt, ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(LocalTime.class, Date.class, lt -> Date.valueOf(LocalDate.MIN));
        TypeConversionRegister.registerTypeConvert(LocalTime.class, Time.class, Time::valueOf);
        TypeConversionRegister.registerTypeConvert(LocalTime.class, Timestamp.class, lt -> new Timestamp(TypeConversionRegister.calendarOf(lt).getTimeInMillis()));
        TypeConversionRegister.registerTypeConvert(OffsetDateTime.class, Instant.class, OffsetDateTime::toInstant);
        TypeConversionRegister.registerTypeConvert(OffsetDateTime.class, Calendar.class, odt -> TypeConversionRegister.calendarOf(java.util.Date.from(odt.toInstant())));
        TypeConversionRegister.registerTypeConvert(OffsetDateTime.class, LocalDateTime.class, OffsetDateTime::toLocalDateTime);
        TypeConversionRegister.registerTypeConvert(OffsetDateTime.class, LocalDate.class, OffsetDateTime::toLocalDate);
        TypeConversionRegister.registerTypeConvert(OffsetDateTime.class, LocalTime.class, OffsetDateTime::toLocalTime);
        TypeConversionRegister.registerTypeConvert(OffsetDateTime.class, java.util.Date.class, odt -> java.util.Date.from(odt.toInstant()));
        TypeConversionRegister.registerTypeConvert(OffsetDateTime.class, ZonedDateTime.class, OffsetDateTime::toZonedDateTime);
        TypeConversionRegister.registerTypeConvert(OffsetDateTime.class, Date.class, odt -> Date.valueOf(odt.toLocalDate()));
        TypeConversionRegister.registerTypeConvert(OffsetDateTime.class, Time.class, odt -> Time.valueOf(odt.toLocalTime()));
        TypeConversionRegister.registerTypeConvert(OffsetDateTime.class, Timestamp.class, odt -> Timestamp.from(odt.toInstant()));
        TypeConversionRegister.registerTypeConvert(ZonedDateTime.class, Instant.class, ChronoZonedDateTime::toInstant);
        TypeConversionRegister.registerTypeConvert(ZonedDateTime.class, Calendar.class, zdt -> TypeConversionRegister.calendarOf(java.util.Date.from(zdt.toInstant())));
        TypeConversionRegister.registerTypeConvert(ZonedDateTime.class, LocalDateTime.class, ZonedDateTime::toLocalDateTime);
        TypeConversionRegister.registerTypeConvert(ZonedDateTime.class, LocalDate.class, ZonedDateTime::toLocalDate);
        TypeConversionRegister.registerTypeConvert(ZonedDateTime.class, LocalTime.class, ZonedDateTime::toLocalTime);
        TypeConversionRegister.registerTypeConvert(ZonedDateTime.class, OffsetDateTime.class, ZonedDateTime::toOffsetDateTime);
        TypeConversionRegister.registerTypeConvert(ZonedDateTime.class, java.util.Date.class, zdt -> java.util.Date.from(zdt.toInstant()));
        TypeConversionRegister.registerTypeConvert(ZonedDateTime.class, Date.class, zdt -> Date.valueOf(zdt.toLocalDate()));
        TypeConversionRegister.registerTypeConvert(ZonedDateTime.class, Time.class, zdt -> Time.valueOf(zdt.toLocalTime()));
        TypeConversionRegister.registerTypeConvert(ZonedDateTime.class, Timestamp.class, zdt -> Timestamp.from(zdt.toInstant()));
        TypeConversionRegister.registerTypeConvert(Date.class, Instant.class, date -> Instant.ofEpochMilli(date.getTime()));
        TypeConversionRegister.registerTypeConvert(Date.class, Calendar.class, TypeConversionRegister::calendarOf);
        TypeConversionRegister.registerTypeConvert(Date.class, LocalDateTime.class, date -> date.toLocalDate().atStartOfDay());
        TypeConversionRegister.registerTypeConvert(Date.class, LocalDate.class, Date::toLocalDate);
        TypeConversionRegister.registerTypeConvert(Date.class, LocalTime.class, date -> null);
        TypeConversionRegister.registerTypeConvert(Date.class, OffsetDateTime.class, date -> date.toLocalDate().atStartOfDay().atZone(ZoneId.systemDefault()).toOffsetDateTime());
        TypeConversionRegister.registerTypeConvert(Date.class, ZonedDateTime.class, date -> date.toLocalDate().atStartOfDay(ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(Date.class, java.util.Date.class, date -> new java.util.Date(date.getTime()));
        TypeConversionRegister.registerTypeConvert(Date.class, Time.class, date -> null);
        TypeConversionRegister.registerTypeConvert(Date.class, Timestamp.class, date -> new Timestamp(date.getTime()));
        TypeConversionRegister.registerTypeConvert(Time.class, Instant.class, time -> Instant.ofEpochMilli(time.getTime()));
        TypeConversionRegister.registerTypeConvert(Time.class, Calendar.class, time -> TypeConversionRegister.calendarOf(time.getTime()));
        TypeConversionRegister.registerTypeConvert(Time.class, LocalDateTime.class, time -> {
            LocalDate date = LocalDate.ofEpochDay(0L);
            LocalTime localTime = time.toLocalTime();
            return LocalDateTime.of(date, localTime);
        });
        TypeConversionRegister.registerTypeConvert(Time.class, LocalDate.class, time -> null);
        TypeConversionRegister.registerTypeConvert(Time.class, LocalTime.class, Time::toLocalTime);
        TypeConversionRegister.registerTypeConvert(Time.class, OffsetDateTime.class, time -> {
            LocalDate date = LocalDate.ofEpochDay(0L);
            LocalTime localTime = time.toLocalTime();
            return LocalDateTime.of(date, localTime).atZone(ZoneId.systemDefault()).toOffsetDateTime();
        });
        TypeConversionRegister.registerTypeConvert(Time.class, ZonedDateTime.class, time -> {
            LocalDate date = LocalDate.ofEpochDay(0L);
            LocalTime localTime = time.toLocalTime();
            return LocalDateTime.of(date, localTime).atZone(ZoneId.systemDefault());
        });
        TypeConversionRegister.registerTypeConvert(Time.class, Date.class, time -> null);
        TypeConversionRegister.registerTypeConvert(Time.class, java.util.Date.class, time -> new java.util.Date(time.getTime()));
        TypeConversionRegister.registerTypeConvert(Time.class, Timestamp.class, time -> Timestamp.valueOf(time.toLocalTime().atDate(LocalDate.ofEpochDay(0L))));
        TypeConversionRegister.registerTypeConvert(Timestamp.class, Instant.class, Timestamp::toInstant);
        TypeConversionRegister.registerTypeConvert(Timestamp.class, Calendar.class, timestamp -> TypeConversionRegister.calendarOf(timestamp.getTime()));
        TypeConversionRegister.registerTypeConvert(Timestamp.class, LocalDateTime.class, Timestamp::toLocalDateTime);
        TypeConversionRegister.registerTypeConvert(Timestamp.class, LocalDate.class, timestamp -> timestamp.toLocalDateTime().toLocalDate());
        TypeConversionRegister.registerTypeConvert(Timestamp.class, LocalTime.class, timestamp -> timestamp.toLocalDateTime().toLocalTime());
        TypeConversionRegister.registerTypeConvert(Timestamp.class, OffsetDateTime.class, timestamp -> timestamp.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime());
        TypeConversionRegister.registerTypeConvert(Timestamp.class, ZonedDateTime.class, timestamp -> timestamp.toLocalDateTime().atZone(ZoneId.systemDefault()));
        TypeConversionRegister.registerTypeConvert(Timestamp.class, Date.class, timestamp -> new Date(timestamp.getTime()));
        TypeConversionRegister.registerTypeConvert(Timestamp.class, Time.class, timestamp -> new Time(timestamp.getTime()));
        TypeConversionRegister.registerTypeConvert(Timestamp.class, java.util.Date.class, timestamp -> new java.util.Date(timestamp.getTime()));
        TypeConversionRegister.registerTypeConvert(String.class, java.util.Date.class, string -> TypeConversionRegister.temporalOf(string, time -> java.util.Date.from(Instant.from(time))));
        TypeConversionRegister.registerTypeConvert(String.class, Instant.class, string -> TypeConversionRegister.temporalOf(string, Instant::from));
        TypeConversionRegister.registerTypeConvert(String.class, Calendar.class, string -> TypeConversionRegister.temporalOf(string, time -> GregorianCalendar.from(ZonedDateTime.from(time))));
        TypeConversionRegister.registerTypeConvert(String.class, LocalDateTime.class, string -> TypeConversionRegister.temporalOf(string, LocalDateTime::from));
        TypeConversionRegister.registerTypeConvert(String.class, LocalDate.class, string -> TypeConversionRegister.temporalOf(string, LocalDate::from));
        TypeConversionRegister.registerTypeConvert(String.class, LocalTime.class, string -> TypeConversionRegister.temporalOf(string, LocalTime::from));
        TypeConversionRegister.registerTypeConvert(String.class, OffsetDateTime.class, string -> TypeConversionRegister.temporalOf(string, time -> {
            ZonedDateTime zonedDateTime = ZonedDateTime.from(time);
            return OffsetDateTime.of(zonedDateTime.toLocalDateTime(), zonedDateTime.getOffset());
        }));
        TypeConversionRegister.registerTypeConvert(String.class, ZonedDateTime.class, string -> TypeConversionRegister.temporalOf(string, ZonedDateTime::from));
        TypeConversionRegister.registerTypeConvert(String.class, Date.class, string -> TypeConversionRegister.temporalOf(string, time -> Date.valueOf(LocalDate.from(time))));
        TypeConversionRegister.registerTypeConvert(String.class, Time.class, string -> TypeConversionRegister.temporalOf(string, time -> Time.valueOf(LocalTime.from(time))));
        TypeConversionRegister.registerTypeConvert(String.class, Timestamp.class, string -> TypeConversionRegister.temporalOf(string, time -> Timestamp.from(Instant.from(time))));
    }
}

