/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.typemap.logic;

import berlin.yuna.typemap.config.TypeConversionRegister;
import berlin.yuna.typemap.model.FunctionOrNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TypeConverter {
    public static <T> T convertObj(Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return targetType.cast(value);
        }
        Object firstValue = TypeConverter.getFirstItem(value);
        if (firstValue != null) {
            return TypeConverter.convertObj(firstValue, targetType);
        }
        if (targetType.isEnum()) {
            return TypeConverter.enumOf(String.valueOf(value), targetType);
        }
        Class<?> sourceType = value.getClass();
        Map conversions = TypeConversionRegister.TYPE_CONVERSIONS.getOrDefault(targetType, Collections.emptyMap());
        FunctionOrNull exactMatch = (FunctionOrNull)conversions.get(sourceType);
        if (exactMatch != null) {
            return targetType.cast(exactMatch.apply(value));
        }
        for (Map.Entry entry : conversions.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(sourceType)) continue;
            return targetType.cast(((FunctionOrNull)entry.getValue()).apply(value));
        }
        if (!String.class.equals(sourceType)) {
            return TypeConverter.convertObj(String.valueOf(value), targetType);
        }
        return null;
    }

    public static <K, V, M extends Map<K, V>> M mapOf(Map<?, ?> input, Supplier<M> output, Class<K> keyType, Class<V> valueType) {
        if (output == null) {
            return null;
        }
        if (input == null || keyType == null || valueType == null) {
            return (M)((Map)output.get());
        }
        Map result = (Map)output.get();
        if (result == null) {
            return null;
        }
        input.forEach((key, value) -> {
            Object convertedKey = TypeConverter.convertObj(key, keyType);
            Object convertedValue = TypeConverter.convertObj(value, valueType);
            if (convertedKey != null && convertedValue != null) {
                result.put(convertedKey, convertedValue);
            }
        });
        return (M)result;
    }

    public static <T extends Collection<E>, E> T collectionOf(Object input, Supplier<? extends T> output, Class<E> itemType) {
        if (output == null) {
            return null;
        }
        if (input != null && itemType != null) {
            if (input instanceof Collection) {
                Collection noTypeCollection = (Collection)input;
                return TypeConverter.collectionOf(noTypeCollection, output, itemType);
            }
            if (input.getClass().isArray() && input instanceof Object[]) {
                ArrayList<E> noTypeCollection = new ArrayList<E>();
                for (Object item : (Object[])input) {
                    noTypeCollection.add(TypeConverter.convertObj(item, itemType));
                }
                return TypeConverter.collectionOf(noTypeCollection, output, itemType);
            }
            E converted = TypeConverter.convertObj(input, itemType);
            if (converted != null) {
                Collection result = (Collection)output.get();
                if (result == null) {
                    return null;
                }
                result.add(converted);
                return (T)result;
            }
        }
        return (T)((Collection)output.get());
    }

    public static <E> E[] arrayOf(Object object, E[] typeIndicator, Class<E> componentType) {
        ArrayList result = TypeConverter.collectionOf(object, ArrayList::new, componentType);
        result = result == null ? new ArrayList() : result;
        return result.toArray(Arrays.copyOf(typeIndicator, result.size()));
    }

    public static <E> E[] arrayOf(Object object, IntFunction<E[]> generator, Class<E> componentType) {
        ArrayList result = TypeConverter.collectionOf(object, ArrayList::new, componentType);
        result = result == null ? new ArrayList() : result;
        return result.stream().toArray(generator);
    }

    public static <E> E[] arrayOf(Object[] array, E[] typeIndicator, Class<E> componentType) {
        return TypeConverter.arrayOf(Arrays.stream(array).collect(Collectors.toList()), typeIndicator, componentType);
    }

    public static <E> E[] arrayOf(Object[] array, IntFunction<E[]> generator, Class<E> componentType) {
        return TypeConverter.arrayOf(Arrays.stream(array).collect(Collectors.toList()), generator, componentType);
    }

    public static <T extends Enum<T>> T enumOf(String value, Class<T> enumType) {
        try {
            return value != null && enumType != null && enumType.isEnum() ? (T)Enum.valueOf(enumType, value) : null;
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private static <T extends Collection<E>, E> T collectionOf(Collection<?> input, Supplier<T> output, Class<E> itemType) {
        Collection result = (Collection)output.get();
        input.stream().map(item -> TypeConverter.convertObj(item, itemType)).filter(Objects::nonNull).forEach(result::add);
        return (T)result;
    }

    private static Object getFirstItem(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty() ? null : collection.iterator().next();
        }
        if (value.getClass().isArray() && value instanceof Object[]) {
            Object[] array = (Object[])value;
            return array.length == 0 ? null : array[0];
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.isEmpty() ? null : map.entrySet().iterator().next();
        }
        return null;
    }

    private TypeConverter() {
    }
}

