/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.typemap.model;

import berlin.yuna.typemap.logic.TypeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public class TypeMap
extends ConcurrentHashMap<Object, Object> {
    public TypeMap() {
        this((Map)null);
    }

    public TypeMap(Map map) {
        Optional.ofNullable(map).ifPresent(x$0 -> super.putAll(x$0));
    }

    @Override
    public TypeMap put(Object key, Object value) {
        super.put(key, value);
        return this;
    }

    public <T> Optional<T> get(Object key, Class<T> type) {
        return Optional.ofNullable(super.get(key)).map(object -> TypeConverter.convertObj(object, type));
    }

    public <T extends Collection<E>, E> T get(Object key, Supplier<? extends T> output, Class<E> itemType) {
        return TypeConverter.collectionOf(super.get(key), output, itemType);
    }

    public <E> E[] getArray(Object key, E[] typeIndicator, Class<E> componentType) {
        ArrayList result = this.get(key, ArrayList::new, componentType);
        return result.toArray(Arrays.copyOf(typeIndicator, result.size()));
    }

    public <E> E[] getArray(Object key, IntFunction<E[]> generator, Class<E> componentType) {
        return this.get(key, ArrayList::new, componentType).stream().toArray(generator);
    }

    public <K, V, M extends Map<K, V>> M get(Object key, Supplier<M> output, Class<K> keyType, Class<V> valueType) {
        Object value = super.get(key);
        if (output != null && keyType != null && valueType != null && value instanceof Map) {
            Map input = (Map)value;
            return TypeConverter.mapOf(input, output, keyType, valueType);
        }
        return (M)((Map)Optional.ofNullable(output).map(Supplier::get).orElse(null));
    }
}

