/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.hamcrest.matcher;

import java.util.function.Supplier;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class AndWait<T>
extends TypeSafeDiagnosingMatcher<Supplier<T>> {
    private Matcher<T> expected;
    private int timeoutMs;

    protected boolean matchesSafely(Supplier<T> actual, Description description) {
        T result = null;
        long finalTime = System.currentTimeMillis() + (long)this.timeoutMs;
        while (System.currentTimeMillis() < finalTime) {
            result = actual.get();
            if (!this.matchesExpected(result)) continue;
            return true;
        }
        this.prepareDescription(description, result);
        return false;
    }

    public void describeTo(Description description) {
    }

    public static <T> AndWait<T> andWait(Matcher<T> expected) {
        return new AndWait<T>(expected, 15000);
    }

    public static <T> AndWait<T> andWait(Matcher<T> expected, int timeoutMs) {
        return new AndWait<T>(expected, timeoutMs);
    }

    public AndWait(Matcher<T> expected) {
        this(expected, 15000);
    }

    public AndWait(Matcher<T> expected, int timeoutMs) {
        this.expected = expected;
        this.timeoutMs = timeoutMs;
    }

    private boolean matchesExpected(T actual) {
        if (this.expected.matches(actual)) {
            return true;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private void prepareDescription(Description description, T result) {
        description.appendText("[Timeout]\n").appendText("\nExpected: ").appendDescriptionOf(this.expected).appendText("\n     but: ");
        this.expected.describeMismatch(result, description);
    }
}

