/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.clu.logic;

import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.clu.model.ThrowingFunction;
import berlin.yuna.clu.model.exception.FileCpoyException;
import berlin.yuna.clu.model.exception.FileNotReadableException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class SystemUtil {
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");

    public static OperatingSystem getOsType() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osArch.contains("arm")) {
            return OperatingSystem.ARM;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return OperatingSystem.LINUX;
        }
        if (osName.contains("mac")) {
            return OperatingSystem.MAC;
        }
        if (osName.contains("win")) {
            return OperatingSystem.WINDOWS;
        }
        if (osName.contains("sunos")) {
            return OperatingSystem.SOLARIS;
        }
        return OperatingSystem.UNKNOWN;
    }

    public static boolean isArm() {
        return SystemUtil.getOsType() == OperatingSystem.ARM;
    }

    public static boolean isLinux() {
        return SystemUtil.getOsType() == OperatingSystem.LINUX;
    }

    public static boolean isMac() {
        return SystemUtil.getOsType() == OperatingSystem.MAC;
    }

    public static boolean isWindows() {
        return SystemUtil.getOsType() == OperatingSystem.WINDOWS;
    }

    public static boolean isSolaris() {
        return SystemUtil.getOsType() == OperatingSystem.SOLARIS;
    }

    public static boolean isUnknown() {
        return SystemUtil.getOsType() == OperatingSystem.UNKNOWN;
    }

    public static boolean setFilePermissions(Path path, PosixFilePermission ... permissions) {
        File destination = path.toFile();
        for (PosixFilePermission permission : permissions) {
            if (SystemUtil.setFilePermission(destination, permission)) continue;
            return false;
        }
        return true;
    }

    public static Path copyResourceToTemp(Class<?> clazz, String relativePath) {
        File tmpFile = new File(TMP_DIR, new File(relativePath).getName());
        if (!tmpFile.exists()) {
            try {
                Files.copy(Objects.requireNonNull(clazz.getClassLoader().getResourceAsStream(relativePath)), tmpFile.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                throw new FileCpoyException("Could not copy file", e);
            }
        }
        return tmpFile.toPath();
    }

    public static String readFile(Path path) {
        try {
            return SystemUtil.tryCharsets(charset -> new String(Files.readAllBytes(path), (Charset)charset));
        }
        catch (Exception e) {
            throw new FileNotReadableException("Could not read file [" + path + "]", e);
        }
    }

    private static <T> T tryCharsets(ThrowingFunction<Charset, T> function) throws Exception {
        Exception last = null;
        for (Charset charset : Arrays.asList(StandardCharsets.UTF_8, StandardCharsets.UTF_16, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE, StandardCharsets.ISO_8859_1, StandardCharsets.US_ASCII)) {
            try {
                return function.acceptThrows(charset);
            }
            catch (Exception e) {
                last = e;
            }
        }
        throw last;
    }

    public static List<String> readFileLines(Path path) {
        try {
            return SystemUtil.tryCharsets(charset -> Files.readAllLines(path, charset));
        }
        catch (Exception e) {
            throw new FileNotReadableException("Could not read file [" + path + "]", e);
        }
    }

    public static boolean deleteDirectory(Path path) {
        AtomicBoolean success = new AtomicBoolean(true);
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(file -> success.set(success.get() && file.delete() && success.get()));
        }
        catch (IOException ex) {
            return success.get();
        }
        return success.get();
    }

    public static void killProcessByName(String name) {
        new Terminal().execute(SystemUtil.getKillCommand(SystemUtil.getOsType()) + " " + name);
    }

    static String getKillCommand(OperatingSystem operatingSystem) {
        switch (operatingSystem) {
            case WINDOWS: {
                return "taskkill /F /IM";
            }
            case SOLARIS: 
            case UNKNOWN: {
                return "killall";
            }
        }
        return "pkill -f";
    }

    private static boolean setFilePermission(File destination, PosixFilePermission permission) {
        boolean successState = false;
        switch (permission) {
            case OWNER_WRITE: 
            case GROUP_WRITE: 
            case OTHERS_WRITE: {
                successState = destination.setWritable(true, permission == PosixFilePermission.OWNER_WRITE);
                break;
            }
            case OWNER_READ: 
            case GROUP_READ: 
            case OTHERS_READ: {
                successState = destination.setReadable(true, permission == PosixFilePermission.OWNER_READ);
                break;
            }
            case OWNER_EXECUTE: 
            case GROUP_EXECUTE: 
            case OTHERS_EXECUTE: {
                successState = destination.setExecutable(true, permission == PosixFilePermission.OWNER_EXECUTE);
            }
        }
        return successState;
    }

    public static enum OperatingSystem {
        ARM,
        LINUX,
        MAC,
        WINDOWS,
        SOLARIS,
        UNKNOWN;

    }
}

