/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.clu.logic;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class CommandLineReader
extends ConcurrentHashMap<String, List<String>> {
    private final List<String> commandList = new ArrayList<String>();

    public CommandLineReader(String ... input) {
        StringBuilder builder = new StringBuilder();
        for (String current : input) {
            builder.append(" ").append(current);
        }
        this.parseCommandLine(builder.toString());
    }

    public String getCommand() {
        return this.getCommand(0);
    }

    public String getCommand(int index) {
        return this.commandList.isEmpty() || this.commandList.size() - 1 < index ? null : this.commandList.get(index);
    }

    public boolean isPresent(String key) {
        for (String current : this.keySet()) {
            if (!key.equalsIgnoreCase(current)) continue;
            return true;
        }
        return false;
    }

    public String getValue(String ... keys) {
        return this.getValue(0, keys);
    }

    public String getValue(int index, String ... keys) {
        List<String> result = this.getValues(keys);
        return result.isEmpty() || result.size() - 1 < index ? null : result.get(index);
    }

    public List<String> getValues(String ... keys) {
        List<String> result = new ArrayList<String>();
        for (String key : keys) {
            result.addAll(this.get(key));
        }
        result = this.removeDuplicates(result);
        return result;
    }

    public List<String> get(String key) {
        for (String current : this.keySet()) {
            if (!key.equalsIgnoreCase(current)) continue;
            return (List)super.get(current);
        }
        return new ArrayList<String>();
    }

    private List<String> removeDuplicates(List<String> result) {
        return new ArrayList<String>(new LinkedHashSet<String>(result));
    }

    private void parseCommandLine(String input) {
        String process = this.parseCommands(input);
        for (String argument : (" " + process).split(" --| -")) {
            if ((argument = argument.trim()).isEmpty()) continue;
            String[] arg = this.parseToKeyValue(argument);
            String key = arg[0].trim().toLowerCase();
            String value = arg[1] == null ? null : this.getStripedValue(arg[1]);
            ArrayList<String> valueList = new ArrayList<String>(this.get(key));
            if (value == null || !this.containsIgnoreCase(valueList, value)) {
                valueList.add(value);
            }
            this.put(key, valueList);
        }
    }

    private String parseCommands(String input) {
        String result = input.trim();
        if (result.contains("-")) {
            String[] cmdList = result.substring(0, result.indexOf(45)).trim().split(" ");
            result = result.substring(result.indexOf(45)).trim();
            this.addCommands(cmdList);
        }
        return result.trim();
    }

    private void addCommands(String[] cmdList) {
        for (String cmd : cmdList) {
            if (cmd.isEmpty()) continue;
            this.commandList.add(cmd.trim());
        }
    }

    private String getStripedValue(String value) {
        String result;
        String string = result = value == null ? "" : value.trim();
        if (result.startsWith("'") && result.endsWith("'") || result.startsWith("\"") && result.endsWith("\"")) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    private String[] parseToKeyValue(String argument) {
        if (argument.indexOf(61) != -1) {
            return argument.split("=");
        }
        if (argument.indexOf(32) != -1) {
            int spaceIndex = argument.indexOf(" ");
            return new String[]{argument.substring(0, spaceIndex), argument.substring(spaceIndex)};
        }
        return new String[]{argument, null};
    }

    private boolean containsIgnoreCase(List<String> list, String value) {
        for (String current : list) {
            if (!value.equalsIgnoreCase(current)) continue;
            return true;
        }
        return false;
    }
}

