/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.clu.model;

import berlin.yuna.clu.model.OsType;

public enum OsArch {
    ARCH_AMD("amd"),
    ARCH_ARM("arm", "aarch"),
    ARCH_PPC("ppc"),
    ARCH_INTEL("x86", "686", "386", "368", "64"),
    ARCH_UNKNOWN(new String[0]);

    private final String[] contains;

    private OsArch(String ... contains) {
        this.contains = contains;
    }

    public String[] getContains() {
        return this.contains;
    }

    public static OsArch of(String osArch) {
        String os = osArch == null ? "" : osArch.toLowerCase();
        for (OsArch osType : OsArch.values()) {
            for (String content : osType.getContains()) {
                if (!os.contains(content)) continue;
                return osType;
            }
        }
        return ARCH_UNKNOWN;
    }

    public String toString() {
        return OsType.osCase(this.name(), 5);
    }
}

