/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.clu.logic;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.clu.model.OsType;
import berlin.yuna.clu.model.exception.TerminalExecutionException;
import berlin.yuna.clu.util.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Terminal {
    private Process process;
    private final CommandOutput commandOutput = new CommandOutput();
    private final CommandOutput tmpOutput = new CommandOutput();
    private int status = 0;
    private long timeoutMs = -1L;
    private long waitForMs = 256L;
    private boolean breakOnError = false;
    private File dir = new File(System.getProperty("user.dir"));

    public static Terminal copyOf(Terminal terminal) {
        Terminal term = new Terminal();
        term.breakOnError(terminal.breakOnError);
        term.timeoutMs(terminal.timeoutMs);
        term.status = terminal.status;
        term.waitForMs = terminal.waitForMs;
        term.dir(terminal.dir);
        return term;
    }

    public Terminal clearConsole() {
        this.commandOutput.clear();
        this.tmpOutput.clear();
        return this;
    }

    @SafeVarargs
    public final Terminal consumerInfoStream(Consumer<String> ... consumerInfo) {
        this.tmpOutput.consumerInfo.addAll(Arrays.asList(consumerInfo));
        return this;
    }

    @SafeVarargs
    public final Terminal consumerErrorStream(Consumer<String> ... consumerError) {
        this.tmpOutput.consumerError.addAll(Arrays.asList(consumerError));
        return this;
    }

    @SafeVarargs
    public final Terminal consumerInfo(Consumer<String> ... consumerError) {
        this.commandOutput.consumerInfo.addAll(Arrays.asList(consumerError));
        return this;
    }

    @SafeVarargs
    public final Terminal consumerError(Consumer<String> ... consumerError) {
        this.commandOutput.consumerError.addAll(Arrays.asList(consumerError));
        return this;
    }

    public long timeoutMs() {
        return this.timeoutMs;
    }

    public Terminal timeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public boolean breakOnError() {
        return this.breakOnError;
    }

    public Terminal breakOnError(boolean breakOnError) {
        this.breakOnError = breakOnError;
        return this;
    }

    public File dir() {
        return this.dir;
    }

    public long waitFor() {
        return this.waitForMs;
    }

    public Terminal waitFor(long waitForMs) {
        this.waitForMs = waitForMs;
        return this;
    }

    public Terminal dir(String dir) {
        this.dir = new File(dir);
        return this;
    }

    public Terminal dir(File dir) {
        this.dir = dir;
        return this;
    }

    public Terminal dir(Path dir) {
        this.dir = dir.toFile();
        return this;
    }

    public Process process() {
        return this.process;
    }

    public String consoleInfo() {
        return this.commandOutput.consoleInfo() + this.tmpOutput.consoleInfo();
    }

    public String consoleError() {
        return this.commandOutput.consoleError() + this.tmpOutput.consoleError();
    }

    public Terminal execute(String command) {
        return this.execute(command, this.waitForMs);
    }

    public Terminal execute(String command, long waitForMs) {
        try {
            this.process = this.process(command);
            if (this.timeoutMs == -1L) {
                this.process.waitFor();
            } else {
                this.waitFor(command);
            }
            this.waitForConsoleOutput(waitForMs <= 0L ? 256L : waitForMs);
            String error = this.tmpOutput.consoleError();
            this.status = this.clearTmpOutput();
            if (this.breakOnError && this.status != 0) {
                throw new IllegalStateException("[" + this.dir.getName() + "] [" + command + "] " + error);
            }
            return this;
        }
        catch (IOException | InterruptedException e) {
            throw new TerminalExecutionException("Unable to execute [" + command + "]", e);
        }
    }

    public Process process(String command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(this.dir);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> builder.environment().put(key.toString(), value.toString())));
        builder.command(this.addExecutor(SystemUtil.OS, command));
        Process process = builder.start();
        Executors.newSingleThreadExecutor().submit(new StreamGobbler(process.getInputStream(), Collections.singletonList(xva$0 -> this.tmpOutput.consoleInfo((String)xva$0))));
        Executors.newSingleThreadExecutor().submit(new StreamGobbler(process.getErrorStream(), Collections.singletonList(xva$0 -> this.tmpOutput.consoleError((String)xva$0))));
        return process;
    }

    public int status() {
        return this.status;
    }

    String[] addExecutor(OsType os, String command) {
        if (os == OsType.OS_WINDOWS) {
            return new String[]{"cmd.exe", "/c", command};
        }
        return new String[]{"sh", "-c", command};
    }

    private void waitFor(String command) throws InterruptedException {
        int count;
        this.status = 0;
        long startTime = System.currentTimeMillis();
        do {
            count = this.countTerminalMessages();
            Thread.sleep(this.timeoutMs / 40L);
        } while ((count == 0 || count != this.countTerminalMessages()) && System.currentTimeMillis() - startTime < this.timeoutMs);
        if (System.currentTimeMillis() - startTime > this.timeoutMs) {
            throw new TerminalExecutionException("Execution got timed out [" + command + "]");
        }
    }

    public int countTerminalMessages() {
        return this.commandOutput.consoleInfo.size() + this.commandOutput.consoleError.size() + this.tmpOutput.consoleInfo.size() + this.tmpOutput.consoleError.size();
    }

    private void waitForConsoleOutput(long waitForMs) throws InterruptedException {
        int count;
        do {
            count = this.countTerminalMessages();
            Thread.sleep(waitForMs);
        } while (count != this.countTerminalMessages());
    }

    private int clearTmpOutput() {
        int outputStatus;
        try {
            outputStatus = this.process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            outputStatus = 0;
        }
        this.commandOutput.consoleInfo(this.tmpOutput.consoleInfo.toArray(new String[0]));
        if (outputStatus > 0) {
            this.commandOutput.consoleError(this.tmpOutput.consoleError.toArray(new String[0]));
        } else {
            this.commandOutput.consoleInfo(this.tmpOutput.consoleError.toArray(new String[0]));
        }
        this.tmpOutput.clear();
        return outputStatus;
    }

    public static class CommandOutput {
        final List<String> consoleInfo = new ArrayList<String>();
        final List<String> consoleError = new ArrayList<String>();
        final List<Consumer<String>> consumerInfo = new ArrayList<Consumer<String>>();
        final List<Consumer<String>> consumerError = new ArrayList<Consumer<String>>();

        String consoleInfo() {
            return String.join((CharSequence)"", this.consoleInfo);
        }

        String consoleError() {
            return String.join((CharSequence)"", this.consoleError);
        }

        void consoleInfo(String ... string) {
            this.addToConsole(string, this.consoleInfo, this.consumerInfo);
        }

        void consoleError(String ... string) {
            this.addToConsole(string, this.consoleError, this.consumerError);
        }

        private void addToConsole(String[] string, List<String> consoleError, List<Consumer<String>> consumerError) {
            Arrays.stream(string).forEach(s -> {
                consoleError.add((String)s);
                consumerError.forEach(c -> c.accept(s));
            });
        }

        void clear() {
            this.consoleInfo.clear();
            this.consoleError.clear();
        }
    }
}

