/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.clu.logic;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.clu.model.OsType;
import berlin.yuna.clu.model.exception.TerminalExecutionException;
import berlin.yuna.clu.util.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Terminal {
    private Process process;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicInteger status = new AtomicInteger(0);
    private final CommandOutput commandOutput = new CommandOutput();
    private final CommandOutput tmpOutput = new CommandOutput();
    private long timeoutMs = -1L;
    private long waitForMs = 5L;
    private boolean breakOnError = false;
    private File dir = new File(System.getProperty("user.dir"));

    public static Terminal copyOf(Terminal terminal) {
        Terminal result = new Terminal();
        result.breakOnError(terminal.breakOnError);
        result.timeoutMs(terminal.timeoutMs);
        result.status.set(terminal.status.get());
        result.waitForMs = terminal.waitForMs;
        result.dir(terminal.dir);
        return result;
    }

    public Terminal clearConsole() {
        this.commandOutput.clear();
        this.tmpOutput.clear();
        return this;
    }

    @SafeVarargs
    public final Terminal consumerInfoStream(Consumer<String> ... consumerInfo) {
        this.tmpOutput.consumerInfo.addAll(Arrays.asList(consumerInfo));
        return this;
    }

    @SafeVarargs
    public final Terminal consumerErrorStream(Consumer<String> ... consumerError) {
        this.tmpOutput.consumerError.addAll(Arrays.asList(consumerError));
        return this;
    }

    @SafeVarargs
    public final Terminal consumerInfo(Consumer<String> ... consumerError) {
        this.commandOutput.consumerInfo.addAll(Arrays.asList(consumerError));
        return this;
    }

    @SafeVarargs
    public final Terminal consumerError(Consumer<String> ... consumerError) {
        this.commandOutput.consumerError.addAll(Arrays.asList(consumerError));
        return this;
    }

    public long timeoutMs() {
        return this.timeoutMs;
    }

    public Terminal timeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public boolean breakOnError() {
        return this.breakOnError;
    }

    public Terminal breakOnError(boolean breakOnError) {
        this.breakOnError = breakOnError;
        return this;
    }

    public File dir() {
        return this.dir;
    }

    public long waitFor() {
        return this.waitForMs;
    }

    public Terminal waitFor(long waitForMs) {
        this.waitForMs = waitForMs;
        return this;
    }

    public Terminal dir(String dir) {
        this.dir = new File(dir);
        return this;
    }

    public Terminal dir(File dir) {
        this.dir = dir;
        return this;
    }

    public Terminal dir(Path dir) {
        this.dir = dir.toFile();
        return this;
    }

    public Process process() {
        return this.process;
    }

    public String consoleInfo() {
        return this.commandOutput.consoleInfo() + this.tmpOutput.consoleInfo();
    }

    public List<String> consoleInfoList() {
        ArrayList<String> result = new ArrayList<String>(this.commandOutput.consoleInfo);
        result.addAll(this.tmpOutput.consoleInfo);
        return result;
    }

    public String consoleError() {
        return this.commandOutput.consoleError() + this.tmpOutput.consoleError();
    }

    public List<String> consoleErrorList() {
        ArrayList<String> result = new ArrayList<String>(this.commandOutput.consoleError);
        result.addAll(this.tmpOutput.consoleError);
        return result;
    }

    public Terminal execute(String command) {
        return this.execute(command, this.waitForMs);
    }

    public synchronized Terminal execute(String command, long waitForMs) {
        try {
            this.running.set(true);
            this.process = this.process(command);
            this.process.onExit().thenApply(p -> {
                this.running.set(false);
                return p;
            });
            this.waitUntilDone(this.process, this.timeoutMs, waitForMs);
            this.status.set(this.clearTmpOutput(this.process));
            this.handleConsoleError(this.breakOnError, this.status.get(), command);
            Terminal terminal = this;
            return terminal;
        }
        catch (IOException | InterruptedException e) {
            throw new TerminalExecutionException("Failed to run dir command [" + command + "] in dir [" + this.dir.getName() + "]", e);
        }
        finally {
            this.running.set(false);
        }
    }

    private void handleConsoleError(boolean breakOnError, int status, String command) {
        if (breakOnError && status != 0) {
            throw new IllegalStateException("Failed to run dir command [" + command + "] in dir [" + this.dir.getName() + "] output [" + this.tmpOutput.consoleError() + "]");
        }
    }

    public Process process(String command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(this.dir);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> builder.environment().put(key.toString(), value.toString())));
        builder.command(this.addExecutor(SystemUtil.OS, command));
        Process result = builder.start();
        Executors.newSingleThreadExecutor().submit(new StreamGobbler(result.getInputStream(), Collections.singletonList(xva$0 -> this.tmpOutput.consoleInfo((String)xva$0))));
        Executors.newSingleThreadExecutor().submit(new StreamGobbler(result.getErrorStream(), Collections.singletonList(xva$0 -> this.tmpOutput.consoleError((String)xva$0))));
        return result;
    }

    public int status() {
        return this.status.get();
    }

    String[] addExecutor(OsType os, String command) {
        if (os == OsType.OS_WINDOWS) {
            return new String[]{"cmd.exe", "/c", command};
        }
        return new String[]{"sh", "-c", command};
    }

    public int messageCount() {
        return this.commandOutput.consoleInfo.size() + this.commandOutput.consoleError.size() + this.tmpOutput.consoleInfo.size() + this.tmpOutput.consoleError.size();
    }

    private synchronized void waitUntilDone(Process process, long timeoutMs, long waitForMs) throws InterruptedException {
        long waitMs;
        process.waitFor(timeoutMs < 1L ? 10000L : timeoutMs, TimeUnit.MILLISECONDS);
        long l = waitMs = waitForMs < 1L ? 5L : waitForMs;
        while (this.running.get()) {
            this.wait(waitMs);
        }
        int count = this.messageCount();
        if (waitForMs < 1L && count == 0 || waitForMs > 0L) {
            do {
                count = this.messageCount();
                this.wait(waitMs);
            } while (count != this.messageCount());
        }
    }

    private int clearTmpOutput(Process process) {
        int outputStatus;
        try {
            outputStatus = process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            outputStatus = 0;
        }
        this.commandOutput.consoleInfo(this.tmpOutput.consoleInfo.toArray(new String[0]));
        if (outputStatus > 0) {
            this.commandOutput.consoleError(this.tmpOutput.consoleError.toArray(new String[0]));
        } else {
            this.commandOutput.consoleInfo(this.tmpOutput.consoleError.toArray(new String[0]));
        }
        this.tmpOutput.clear();
        return outputStatus;
    }

    public static class CommandOutput {
        final List<String> consoleInfo = new ArrayList<String>();
        final List<String> consoleError = new ArrayList<String>();
        final List<Consumer<String>> consumerInfo = new ArrayList<Consumer<String>>();
        final List<Consumer<String>> consumerError = new ArrayList<Consumer<String>>();

        String consoleInfo() {
            return String.join((CharSequence)"", this.consoleInfo);
        }

        String consoleError() {
            return String.join((CharSequence)"", this.consoleError);
        }

        void consoleInfo(String ... string) {
            this.addToConsole(string, this.consoleInfo, this.consumerInfo);
        }

        void consoleError(String ... string) {
            this.addToConsole(string, this.consoleError, this.consumerError);
        }

        private void addToConsole(String[] string, List<String> consoleError, List<Consumer<String>> consumerError) {
            Arrays.stream(string).forEach(s -> {
                consoleError.add((String)s);
                consumerError.forEach(c -> c.accept(s));
            });
        }

        void clear() {
            this.consoleInfo.clear();
            this.consoleError.clear();
        }
    }
}

