/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.clu.model;

import berlin.yuna.clu.model.OsType;

public enum OsArchType {
    AT_86("x86", "686", "386", "368"),
    AT_64("64"),
    AT_7("arm7"),
    AT_6("arm6"),
    AT_PPC("ppc"),
    AT_UNKNOWN(new String[0]);

    private final String[] contains;

    private OsArchType(String ... contains) {
        this.contains = contains;
    }

    public String[] getContains() {
        return this.contains;
    }

    public static OsArchType of(String osArch) {
        String os = osArch == null ? "" : osArch.toLowerCase();
        for (OsArchType osType : OsArchType.values()) {
            for (String content : osType.getContains()) {
                if (!os.contains(content)) continue;
                return osType;
            }
        }
        return AT_UNKNOWN;
    }

    public String toString() {
        return OsType.osCase(this.name(), 3);
    }
}

