/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.clu.logic;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.clu.model.OsType;
import berlin.yuna.clu.model.exception.TerminalExecutionException;
import berlin.yuna.clu.util.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Terminal {
    private final AtomicLong timeoutMs = new AtomicLong(-1L);
    private final AtomicLong waitForMs = new AtomicLong(5L);
    private final AtomicBoolean breakOnError = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicInteger status = new AtomicInteger(0);
    private final CommandOutput commandOutput = new CommandOutput();
    private final CommandOutput tmpOutput = new CommandOutput();
    private Process process;
    private File dir = new File(System.getProperty("user.dir"));

    public static Terminal copyOf(Terminal terminal) {
        Terminal result = new Terminal();
        result.breakOnError.set(terminal.breakOnError.get());
        result.timeoutMs.set(terminal.timeoutMs.get());
        result.status.set(terminal.status.get());
        result.waitForMs.set(terminal.waitForMs.get());
        result.dir(terminal.dir);
        return result;
    }

    public Terminal clearConsole() {
        this.commandOutput.clear();
        this.tmpOutput.clear();
        return this;
    }

    @SafeVarargs
    public final Terminal consumerInfoStream(Consumer<String> ... consumerInfo) {
        this.tmpOutput.consumerInfo.addAll(Arrays.asList(consumerInfo));
        return this;
    }

    @SafeVarargs
    public final Terminal consumerErrorStream(Consumer<String> ... consumerError) {
        this.tmpOutput.consumerError.addAll(Arrays.asList(consumerError));
        return this;
    }

    public long timeoutMs() {
        return this.timeoutMs.get();
    }

    public Terminal timeoutMs(long timeoutMs) {
        this.timeoutMs.set(timeoutMs);
        return this;
    }

    public boolean breakOnError() {
        return this.breakOnError.get();
    }

    public Terminal breakOnError(boolean breakOnError) {
        this.breakOnError.set(breakOnError);
        return this;
    }

    public File dir() {
        return this.dir;
    }

    public long waitFor() {
        return this.waitForMs.get();
    }

    public Terminal waitFor(long waitForMs) {
        this.waitForMs.set(waitForMs);
        return this;
    }

    public Terminal dir(String dir) {
        this.dir = new File(dir);
        return this;
    }

    public Terminal dir(File dir) {
        this.dir = dir;
        return this;
    }

    public Terminal dir(Path dir) {
        this.dir = dir.toFile();
        return this;
    }

    public Process process() {
        return this.process;
    }

    public String consoleInfo() {
        return this.commandOutput.consoleInfo() + this.tmpOutput.consoleInfo();
    }

    public List<String> consoleInfoList() {
        ArrayList<String> result = new ArrayList<String>(this.commandOutput.consoleInfo);
        result.addAll(this.tmpOutput.consoleInfo);
        return result;
    }

    public String consoleError() {
        return this.commandOutput.consoleError() + this.tmpOutput.consoleError();
    }

    public List<String> consoleErrorList() {
        ArrayList<String> result = new ArrayList<String>(this.commandOutput.consoleError);
        result.addAll(this.tmpOutput.consoleError);
        return result;
    }

    public Terminal execute(String command) {
        return this.execute(command, this.waitForMs.get());
    }

    public synchronized Terminal execute(String command, Long waitForMs) {
        try {
            this.running.set(true);
            this.process = this.process(command);
            this.process.onExit().thenApply(p -> {
                this.running.set(false);
                if (waitForMs == null) {
                    this.setStatus(command);
                }
                return p;
            });
            if (waitForMs != null) {
                this.waitUntilDone(this.process, this.timeoutMs.get(), waitForMs);
                this.setStatus(command);
            }
            return this;
        }
        catch (IOException e) {
            throw new TerminalExecutionException("Failed to run dir command [" + command + "] in dir [" + this.dir.getName() + "]", e);
        }
    }

    public Process process(String command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(this.dir);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> builder.environment().put(key.toString(), value.toString())));
        builder.command(this.addExecutor(SystemUtil.OS, command));
        Process result = builder.start();
        Executors.newSingleThreadExecutor().submit(new StreamGobbler(result.getInputStream(), Collections.singletonList(xva$0 -> this.tmpOutput.consoleInfo((String)xva$0))));
        Executors.newSingleThreadExecutor().submit(new StreamGobbler(result.getErrorStream(), Collections.singletonList(xva$0 -> this.tmpOutput.consoleError((String)xva$0))));
        return result;
    }

    public int status() {
        return this.status.get();
    }

    public boolean running() {
        return this.running.get();
    }

    String[] addExecutor(OsType os, String command) {
        if (os == OsType.OS_WINDOWS) {
            return new String[]{"cmd.exe", "/c", command};
        }
        return new String[]{"sh", "-c", command};
    }

    public int messageCount() {
        return this.commandOutput.consoleInfo.size() + this.commandOutput.consoleError.size() + this.tmpOutput.consoleInfo.size() + this.tmpOutput.consoleError.size();
    }

    private synchronized void waitUntilDone(Process process, long timeoutMs, long waitForMs) {
        try {
            long waitMs;
            process.waitFor(timeoutMs < 1L ? 10000L : timeoutMs, TimeUnit.MILLISECONDS);
            long l = waitMs = waitForMs < 1L ? 5L : waitForMs;
            while (this.running.get()) {
                this.wait(waitMs);
            }
            int count = this.messageCount();
            if (waitForMs < 1L && count == 0 || waitForMs > 0L) {
                do {
                    count = this.messageCount();
                    this.wait(waitMs);
                } while (count != this.messageCount());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setStatus(String command) {
        this.status.set(this.clearTmpOutput(this.process));
        this.handleConsoleError(this.breakOnError.get(), this.status.get(), command);
    }

    private void handleConsoleError(boolean breakOnError, int status, String command) {
        if (breakOnError && status != 0) {
            throw new IllegalStateException("Failed to run dir command [" + command + "] in dir [" + this.dir.getName() + "] output [" + this.tmpOutput.consoleError() + "]");
        }
    }

    private int clearTmpOutput(Process process) {
        int outputStatus;
        try {
            outputStatus = process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            outputStatus = 0;
        }
        this.commandOutput.consoleInfo(this.tmpOutput.consoleInfo.toArray(new String[0]));
        if (outputStatus > 0) {
            this.commandOutput.consoleError(this.tmpOutput.consoleError.toArray(new String[0]));
        } else {
            this.commandOutput.consoleInfo(this.tmpOutput.consoleError.toArray(new String[0]));
        }
        this.tmpOutput.clear();
        return outputStatus;
    }

    public String toString() {
        return "Terminal{, running=" + this.running.get() + ", status=" + this.status.get() + ", pid=" + Optional.ofNullable(this.process).map(Process::pid).orElse(null) + ", dir=" + this.dir + "}";
    }

    public static class CommandOutput {
        final List<String> consoleInfo = new ArrayList<String>();
        final List<String> consoleError = new ArrayList<String>();
        final List<Consumer<String>> consumerInfo = new ArrayList<Consumer<String>>();
        final List<Consumer<String>> consumerError = new ArrayList<Consumer<String>>();

        String consoleInfo() {
            return String.join((CharSequence)"", this.consoleInfo);
        }

        String consoleError() {
            return String.join((CharSequence)"", this.consoleError);
        }

        void consoleInfo(String ... string) {
            this.addToConsole(string, this.consoleInfo, this.consumerInfo);
        }

        void consoleError(String ... string) {
            this.addToConsole(string, this.consoleError, this.consumerError);
        }

        private void addToConsole(String[] string, List<String> consoleError, List<Consumer<String>> consumerError) {
            Arrays.stream(string).forEach(s -> {
                consoleError.add((String)s);
                consumerError.forEach(c -> c.accept(s));
            });
        }

        void clear() {
            this.consoleInfo.clear();
            this.consoleError.clear();
        }
    }
}

