/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.clu.logic;

import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.clu.model.OsArch;
import berlin.yuna.clu.model.OsArchType;
import berlin.yuna.clu.model.OsType;
import berlin.yuna.clu.model.ThrowingFunction;
import berlin.yuna.clu.model.exception.FileCopyException;
import berlin.yuna.clu.model.exception.FileNotReadableException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class SystemUtil {
    public static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    public static final OsType OS = OsType.of(System.getProperty("os.name"));
    public static final OsArch OS_ARCH = OsArch.of(System.getProperty("os.arch"));
    public static final OsArchType OS_ARCH_TYPE = OsArchType.of(System.getProperty("os.arch"));

    public static boolean setFilePermissions(Path path, PosixFilePermission ... permissions) {
        File destination = path.toFile();
        for (PosixFilePermission permission : permissions) {
            if (SystemUtil.setFilePermission(destination, permission)) continue;
            return false;
        }
        return true;
    }

    public static Path copyResourceToTemp(Class<?> clazz, String relativePath) {
        File tmpFile = new File(TMP_DIR, new File(relativePath).getName());
        if (!tmpFile.exists()) {
            try {
                Files.copy(Objects.requireNonNull(clazz.getClassLoader().getResourceAsStream(relativePath)), tmpFile.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                throw new FileCopyException("Could not copy file", e);
            }
        }
        return tmpFile.toPath();
    }

    public static String readFile(Path path) {
        try {
            return SystemUtil.tryCharsets(charset -> Files.readString(path, charset));
        }
        catch (Exception e) {
            throw new FileNotReadableException("Could not read file [" + String.valueOf(path) + "]", e);
        }
    }

    private static <T> T tryCharsets(ThrowingFunction<Charset, T> function) throws Exception {
        AtomicReference<Object> latestException = new AtomicReference<Object>(null);
        for (Charset charset : Arrays.asList(Charset.defaultCharset(), StandardCharsets.UTF_8, StandardCharsets.UTF_16, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE, StandardCharsets.ISO_8859_1, StandardCharsets.US_ASCII)) {
            try {
                return function.acceptThrows(charset);
            }
            catch (Exception e) {
                latestException.set(e);
            }
            catch (Error e) {
                latestException.set(new MalformedInputException(2));
            }
        }
        throw (Exception)latestException.get();
    }

    public static List<String> readFileLines(Path path) {
        try {
            return SystemUtil.tryCharsets(charset -> Files.readAllLines(path, charset));
        }
        catch (Exception e) {
            throw new FileNotReadableException("Could not read file [" + String.valueOf(path) + "]", e);
        }
    }

    public static boolean deleteDirectory(Path path) {
        AtomicBoolean success = new AtomicBoolean(true);
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(file -> {
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    success.set(false);
                }
            });
        }
        catch (IOException ex) {
            return false;
        }
        return success.get();
    }

    public static void killProcessByName(String name) {
        new Terminal().execute(SystemUtil.killCommand(OS) + " " + name);
    }

    public static String killCommand(OsType os) {
        switch (os) {
            case OS_WINDOWS: {
                return "taskkill /F /IM";
            }
            case OS_SOLARIS: 
            case OS_UNKNOWN: {
                return "killall";
            }
        }
        return "pkill -f";
    }

    private SystemUtil() {
    }

    private static boolean setFilePermission(File destination, PosixFilePermission permission) {
        boolean successState = false;
        switch (permission) {
            case OWNER_WRITE: 
            case GROUP_WRITE: 
            case OTHERS_WRITE: {
                successState = destination.setWritable(true, permission == PosixFilePermission.OWNER_WRITE);
                break;
            }
            case OWNER_READ: 
            case GROUP_READ: 
            case OTHERS_READ: {
                successState = destination.setReadable(true, permission == PosixFilePermission.OWNER_READ);
                break;
            }
            case OWNER_EXECUTE: 
            case GROUP_EXECUTE: 
            case OTHERS_EXECUTE: {
                successState = destination.setExecutable(true, permission == PosixFilePermission.OWNER_EXECUTE);
            }
        }
        return successState;
    }
}

