/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.clu.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ArgumentReader
extends ConcurrentHashMap<String, List<String>> {
    protected final List<String> commandList = new ArrayList<String>();

    public static ArgumentReader parseArgs(String ... args) {
        return new ArgumentReader(false, args);
    }

    public static ArgumentReader parseArgs(boolean parseEnv, String ... args) {
        return new ArgumentReader(parseEnv, args);
    }

    protected ArgumentReader(boolean parseEnv, String ... args) {
        StringBuilder builder = new StringBuilder();
        for (String current : args) {
            builder.append(" ").append(current);
        }
        this.parseCommandLine(builder.toString());
        if (parseEnv) {
            this.parseEnvironment();
        }
    }

    public String getCommand() {
        return this.getCommand(0);
    }

    public String getCommand(int index) {
        return this.commandList.isEmpty() || this.commandList.size() - 1 < index ? null : this.commandList.get(index);
    }

    public List<String> getCommands() {
        return new ArrayList<String>(this.commandList);
    }

    public boolean hasCommand(String command) {
        return this.commandList.contains(command);
    }

    public boolean isPresent(String ... keys) {
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public Optional<String> getString(String ... keys) {
        return this.getString(0, keys);
    }

    public Optional<String> getString(int index, String ... keys) {
        return this.getString(null, index, keys);
    }

    public Optional<String> getString(String separator, int index, String ... keys) {
        return Optional.ofNullable(this.getValue(separator, index, keys));
    }

    public List<String> getStrings(String ... keys) {
        return this.getStrings((String)null, keys);
    }

    public List<String> getStrings(char separator, String ... keys) {
        return this.getValues(String.valueOf(separator), keys);
    }

    public List<String> getStrings(String separator, String[] keys) {
        return this.getValues(separator, keys);
    }

    public boolean getBoolean(String ... keys) {
        return this.getBoolean(0, keys);
    }

    public boolean getBoolean(int index, String ... keys) {
        return this.getBoolean(null, index, keys);
    }

    public boolean getBoolean(String separator, int index, String ... keys) {
        return this.getString(separator, index, keys).map(this.toBoolean()).orElseGet(() -> this.isPresent(keys));
    }

    public List<Boolean> getBooleans(String ... keys) {
        return this.getBooleans((String)null, keys);
    }

    public List<Boolean> getBooleans(String separator, String[] keys) {
        return this.getStrings(separator, keys).stream().map(this.toBoolean()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Optional<Long> getLong(String ... keys) {
        return this.getLong(0, keys);
    }

    public Optional<Long> getLong(int index, String ... keys) {
        return this.getLong(null, index, keys);
    }

    public Optional<Long> getLong(String separator, int index, String ... keys) {
        return this.getString(separator, index, keys).map(this.toLong());
    }

    public List<Long> getLongs(String ... keys) {
        return this.getLongs((String)null, keys);
    }

    public List<Long> getLongs(char separator, String ... keys) {
        return this.getStrings(String.valueOf(separator), keys).stream().map(this.toLong()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Long> getLongs(String separator, String[] keys) {
        return this.getStrings(separator, keys).stream().map(this.toLong()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Optional<Double> getDouble(String ... keys) {
        return this.getDouble(0, keys);
    }

    public Optional<Double> getDouble(int index, String ... keys) {
        return this.getDouble(null, index, keys);
    }

    public Optional<Double> getDouble(String separator, int index, String ... keys) {
        return this.getString(separator, index, keys).map(this.toDouble());
    }

    public List<Double> getDoubles(String ... keys) {
        return this.getDoubles((String)null, keys);
    }

    public List<Double> getDoubles(char separator, String ... keys) {
        return this.getStrings(String.valueOf(separator), keys).stream().map(this.toDouble()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Double> getDoubles(String separator, String[] keys) {
        return this.getStrings(separator, keys).stream().map(this.toDouble()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<String> get(String key) {
        return this.get(null, key);
    }

    public List<String> get(String separator, String key) {
        List result = super.getOrDefault(key, new ArrayList());
        return separator == null ? result : result.stream().flatMap(s -> Arrays.stream(s.split(separator)).filter(sp -> !sp.isEmpty())).collect(Collectors.toList());
    }

    protected List<String> removeDuplicates(List<String> result) {
        return new ArrayList<String>(new LinkedHashSet<String>(result));
    }

    public ArgumentReader parseEnvironment() {
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.addKV(String.valueOf(key), String.valueOf(value))));
        return this;
    }

    protected ArgumentReader parseCommandLine(String input) {
        String process = this.parseCommands(input);
        for (String argument : (" " + process).split(" --| -")) {
            if ((argument = argument.trim()).isEmpty()) continue;
            String[] arg = this.parseToKeyValue(argument);
            String key = arg[0].trim();
            String value = arg[1] == null ? null : this.getStripedValue(arg[1]);
            this.addKV(key, value);
        }
        return this;
    }

    protected ArgumentReader addKV(String key, String value) {
        ArrayList<String> valueList = new ArrayList<String>(this.get(key));
        if (value == null || !valueList.contains(value)) {
            valueList.add(value);
        }
        this.put(key, valueList);
        return this;
    }

    protected String parseCommands(String input) {
        String result = input.trim();
        if (result.contains("-")) {
            String[] cmdList = result.substring(0, result.indexOf(45)).trim().split(" ");
            result = result.substring(result.indexOf(45)).trim();
            this.addCommands(cmdList);
        }
        return result.trim();
    }

    protected ArgumentReader addCommands(String[] cmdList) {
        for (String cmd : cmdList) {
            if (cmd.isEmpty()) continue;
            this.commandList.add(cmd.trim());
        }
        return this;
    }

    protected String getStripedValue(String value) {
        String result;
        String string = result = value == null ? "" : value.trim();
        if (result.startsWith("'") && result.endsWith("'") || result.startsWith("\"") && result.endsWith("\"")) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    protected String[] parseToKeyValue(String argument) {
        if (argument.indexOf(61) != -1) {
            return argument.split("=");
        }
        if (argument.indexOf(32) != -1) {
            int spaceIndex = argument.indexOf(" ");
            return new String[]{argument.substring(0, spaceIndex), argument.substring(spaceIndex)};
        }
        return new String[]{argument, null};
    }

    protected List<String> getValues(String separator, String[] keys) {
        List<String> result = new ArrayList<String>();
        for (String key : keys) {
            result.addAll(this.get(separator, key));
        }
        result = this.removeDuplicates(result);
        return result;
    }

    protected String getValue(String separator, int index, String ... keys) {
        List<String> result = this.getValues(separator, keys);
        return result.isEmpty() || result.size() - 1 < index ? null : result.get(index);
    }

    protected Function<String, Boolean> toBoolean() {
        return s -> "true".equalsIgnoreCase((String)s) || "1".equals(s);
    }

    protected Function<String, Long> toLong() {
        return s -> {
            try {
                return s.equalsIgnoreCase("true") ? 1L : (s.equalsIgnoreCase("false") ? 0L : Long.parseLong(s.replaceAll("\\s", "")));
            }
            catch (Exception ignored) {
                return null;
            }
        };
    }

    protected Function<String, Double> toDouble() {
        return s -> {
            try {
                return s.equalsIgnoreCase("true") ? 1.0 : (s.equalsIgnoreCase("false") ? 0.0 : Double.parseDouble(s.replaceAll("\\s", "")));
            }
            catch (Exception ignored) {
                return null;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArgumentReader that = (ArgumentReader)o;
        return Objects.equals(this.commandList, that.commandList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.commandList);
    }
}

