/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.clu.logic;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.clu.util.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Terminal {
    private Process process;
    private final StringBuilder consoleInfo = new StringBuilder();
    private final StringBuilder consoleError = new StringBuilder();
    private int status = 0;
    private long timeoutMs = -1L;
    private boolean breakOnError = true;
    private File dir = new File(System.getProperty("user.dir"));
    private final List<Consumer<String>> consumerInfo = new ArrayList<Consumer<String>>();
    private final List<Consumer<String>> consumerError = new ArrayList<Consumer<String>>();
    private static final SystemUtil.OperatingSystem OS_TYPE = SystemUtil.getOsType();

    public Terminal() {
        this.consumerInfo.add(this.consoleInfo::append);
        this.consumerError.add(this.consoleError::append);
    }

    public Terminal clearConsole() {
        this.consoleInfo.setLength(0);
        this.consoleError.setLength(0);
        return this;
    }

    @SafeVarargs
    public final Terminal consumerInfo(Consumer<String> ... consumerInfo) {
        this.consumerInfo.addAll(Arrays.asList(consumerInfo));
        return this;
    }

    @SafeVarargs
    public final Terminal consumerError(Consumer<String> ... consumerError) {
        this.consumerError.addAll(Arrays.asList(consumerError));
        return this;
    }

    public long timeoutMs() {
        return this.timeoutMs;
    }

    public Terminal timeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public boolean breakOnError() {
        return this.breakOnError;
    }

    public Terminal breakOnError(boolean breakOnError) {
        this.breakOnError = breakOnError;
        return this;
    }

    public File dir() {
        return this.dir;
    }

    public Terminal dir(String dir) {
        this.dir = new File(dir);
        return this;
    }

    public Terminal dir(File dir) {
        this.dir = dir;
        return this;
    }

    public Terminal dir(Path dir) {
        this.dir = dir.toFile();
        return this;
    }

    public Process process() {
        return this.process;
    }

    public String consoleInfo() {
        return this.consoleInfo.toString();
    }

    public String consoleError() {
        return this.consoleError.toString();
    }

    public Terminal execute(String command) {
        try {
            this.process = this.process(command);
            if (this.timeoutMs == -1L) {
                this.status = this.process.waitFor();
            } else {
                this.waitFor(command);
            }
            return this;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Process process(String command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(this.dir);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> builder.environment().put(key.toString(), value.toString())));
        builder.command(this.addExecutor(OS_TYPE, command));
        Process process = builder.start();
        Executors.newSingleThreadExecutor().submit(new StreamGobbler(process.getInputStream(), this.consumerInfo));
        Executors.newSingleThreadExecutor().submit(new StreamGobbler(process.getErrorStream(), this.consumerError));
        return process;
    }

    public int status() {
        return this.status;
    }

    String[] addExecutor(SystemUtil.OperatingSystem os, String command) {
        if (os == SystemUtil.OperatingSystem.WINDOWS) {
            return new String[]{"cmd.exe", "/c", command};
        }
        return new String[]{"sh", "-c", command};
    }

    private void waitFor(String command) throws InterruptedException {
        int count;
        this.status = 0;
        long startTime = System.currentTimeMillis();
        do {
            count = this.countTerminalMessages();
            Thread.sleep(this.timeoutMs / 40L);
        } while ((count == 0 || count != this.countTerminalMessages()) && System.currentTimeMillis() - startTime < this.timeoutMs);
        if (System.currentTimeMillis() - startTime > this.timeoutMs) {
            throw new RuntimeException(new TimeoutException("Execution got timed out [" + command + "]"));
        }
        if (this.breakOnError && !this.consoleError.toString().isEmpty()) {
            throw new IllegalStateException("[" + this.dir.getName() + "] [" + command + "] " + this.consoleError.toString());
        }
        if (!this.consoleError.toString().isEmpty()) {
            this.status = 2;
        }
    }

    private int countTerminalMessages() {
        return this.consoleInfo.length() + this.consoleError.length();
    }
}

