/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.logic;

import berlin.yuna.clu.logic.CommandLineReader;
import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.mavendeploy.config.MavenCommands;
import berlin.yuna.mavendeploy.logic.GitService;
import berlin.yuna.mavendeploy.logic.GpgUtil;
import berlin.yuna.mavendeploy.logic.SemanticService;
import berlin.yuna.mavendeploy.logic.SettingsXmlBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Ci {
    private File PROJECT_DIR = new File(System.getProperty("user.dir"));
    private final CommandLineReader clr;
    private final Model pom;
    private final SemanticService semanticService;
    private final GitService gitService;
    private String JAVA_VERSION = null;
    private String ENCODING = null;
    private String GPG_PASS = null;
    private String GPG_PASS_ALT = null;
    private String PROJECT_VERSION = null;
    private String MVN_OPTIONS = "";
    private final boolean IS_POM;
    private boolean MVN_CLEAN = false;
    private boolean MVN_CLEAN_CACHE = false;
    private boolean MVN_SKIP_TEST = true;
    private boolean MVN_UPDATE_MINOR = false;
    private boolean MVN_UPDATE_MAJOR = false;
    private boolean MVN_JAVA_DOC = true;
    private boolean MVN_PROFILES = true;
    private boolean MVN_SOURCE = true;
    private boolean MVN_TAG = false;
    private boolean MVN_TAG_BREAK = false;
    private boolean MVN_REPORT = false;
    private boolean MVN_RELEASE = false;
    private boolean MVN_CREATE_SETTINGS = false;
    private boolean MVN_REMOVE_SNAPSHOT = false;
    private String MVN_DEPLOY_ID = null;
    private String MVN_COMMIT_MSG = null;
    private String SEMANTIC_FORMAT = null;
    private final Log LOG;

    public Ci(Log LOG, String ... args) {
        String[] stringArray;
        this.LOG = LOG;
        if (args == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = args;
        }
        this.clr = new CommandLineReader(stringArray);
        this.PROJECT_DIR = this.getOrElse(this.clr.getValue("PROJECT_DIR"), this.PROJECT_DIR);
        this.ENCODING = this.getString(this.clr, "ENCODING", this.ENCODING);
        this.PROJECT_VERSION = this.getString(this.clr, "PROJECT_VERSION", this.PROJECT_VERSION);
        this.MVN_OPTIONS = this.getString(this.clr, "OPTIONS", this.MVN_OPTIONS);
        this.JAVA_VERSION = this.getString(this.clr, "JAVA_VERSION", this.JAVA_VERSION);
        this.SEMANTIC_FORMAT = this.getString(this.clr, "SEMANTIC_FORMAT", this.SEMANTIC_FORMAT);
        this.MVN_PROFILES = this.getBoolean(this.clr, "PROFILES", this.MVN_PROFILES);
        this.MVN_CLEAN = this.getBoolean(this.clr, "CLEAN", this.MVN_CLEAN);
        this.MVN_CLEAN_CACHE = this.getBoolean(this.clr, "CLEAN_CACHE", this.MVN_CLEAN_CACHE);
        this.MVN_UPDATE_MINOR = this.getBoolean(this.clr, "UPDATE_MINOR", this.MVN_UPDATE_MINOR);
        this.MVN_UPDATE_MAJOR = this.getBoolean(this.clr, "UPDATE_MAJOR", this.MVN_UPDATE_MAJOR);
        this.MVN_JAVA_DOC = this.getBoolean(this.clr, "JAVA_DOC", this.MVN_JAVA_DOC);
        this.MVN_SOURCE = this.getBoolean(this.clr, "SOURCE", this.MVN_SOURCE);
        this.MVN_TAG = this.getBoolean(this.clr, "TAG", this.MVN_TAG);
        this.MVN_TAG_BREAK = this.getBoolean(this.clr, "TAG_BREAK", this.MVN_TAG_BREAK);
        this.MVN_RELEASE = this.getBoolean(this.clr, "RELEASE", this.MVN_RELEASE);
        this.MVN_SKIP_TEST = this.getBoolean(this.clr, "SKIP_TEST", this.MVN_SKIP_TEST);
        this.MVN_REPORT = this.getBoolean(this.clr, "REPORT", this.MVN_REPORT);
        this.MVN_REMOVE_SNAPSHOT = this.getBoolean(this.clr, "REMOVE_SNAPSHOT", this.MVN_REMOVE_SNAPSHOT);
        this.MVN_CREATE_SETTINGS = !this.isEmpty(this.clr.getValue("S_SERVER"));
        this.MVN_DEPLOY_ID = this.getString(this.clr, "DEPLOY_ID", this.MVN_DEPLOY_ID);
        this.MVN_COMMIT_MSG = this.getString(this.clr, "MVN_COMMIT_MSG", this.MVN_COMMIT_MSG);
        this.GPG_PASS = this.getString(this.clr, "GPG_PASS", this.GPG_PASS);
        this.GPG_PASS_ALT = this.getString(this.clr, "GPG_PASS_ALT", this.GPG_PASS_ALT);
        this.pom = this.parsePomFile(this.PROJECT_DIR);
        this.IS_POM = this.isPomArtifact(this.pom);
        this.semanticService = new SemanticService(this.isEmpty(this.SEMANTIC_FORMAT) ? "\\.:none" : this.SEMANTIC_FORMAT);
        this.gitService = new GitService(LOG, this.PROJECT_DIR);
        this.PROJECT_VERSION = this.isEmpty(this.SEMANTIC_FORMAT) ? this.PROJECT_VERSION : this.semanticService.getNextSemanticVersion(this.pom.getVersion(), this.gitService, this.PROJECT_VERSION);
    }

    public String getProjectVersion() {
        return this.isEmpty(this.PROJECT_VERSION) ? this.pom.getVersion() : this.PROJECT_VERSION;
    }

    public String getBranchName() {
        String branchName = this.semanticService.getBranchName();
        return branchName == null ? this.gitService.findOriginalBranchName(1) : branchName;
    }

    public String prepareCommitMessage() {
        if (!this.isEmpty(this.MVN_COMMIT_MSG)) {
            return this.MVN_COMMIT_MSG;
        }
        return String.format("[%s]", this.getProjectVersion()) + String.format("[%s]", this.getBranchName()) + this.ifDo(this.MVN_TAG || this.MVN_TAG_BREAK, "[TAG]") + this.ifDo(this.MVN_UPDATE_MAJOR || this.MVN_UPDATE_MINOR, "[UPDATE]");
    }

    public boolean allowCommitMessage() {
        return !"false".equalsIgnoreCase(this.MVN_COMMIT_MSG);
    }

    public String prepareMaven() {
        StringBuilder mvnCommand = new StringBuilder();
        mvnCommand.append("mvn").append(" ");
        mvnCommand.append(this.ifDo(this.MVN_CLEAN_CACHE, "dependency:purge-local-repository", "CLEAN_CACHE"));
        mvnCommand.append(this.ifDo(this.MVN_CLEAN, "clean", "CLEAN"));
        mvnCommand.append(this.isEmpty(this.MVN_DEPLOY_ID) ? "verify" : "deploy").append(" ");
        mvnCommand.append(this.ifDo(this.MVN_CREATE_SETTINGS, "--settings=" + this.buildSettings(this.clr), "SKIP_TEST"));
        mvnCommand.append(this.ifDo(this.MVN_SKIP_TEST, "-Dmaven.test.skip=true", "SKIP_TEST"));
        mvnCommand.append(this.ifDo(this.MVN_CLEAN, "generate-resources generate-sources dependency:resolve-plugins"));
        mvnCommand.append(this.ifDo(this.MVN_UPDATE_MINOR, "versions:update-parent versions:update-properties versions:update-child-modules versions:use-latest-releases versions:use-latest-versions ersions:use-next-snapshots versions:commit -DallowSnapshots=true -DallowMajorUpdates=false", "UPDATE_MINOR"));
        mvnCommand.append(this.ifDo(this.MVN_UPDATE_MAJOR, "versions:update-parent versions:update-properties versions:update-child-modules versions:use-latest-releases versions:use-latest-versions versions:use-next-snapshots versions:commit -DallowSnapshots=true -DallowMajorUpdates=true", "UPDATE_MAJOR"));
        mvnCommand.append(this.ifDo(!this.isEmpty(this.PROJECT_VERSION) || this.MVN_REMOVE_SNAPSHOT, "versions:set"));
        mvnCommand.append(this.ifDo(this.PROJECT_VERSION, "-DnewVersion=" + this.PROJECT_VERSION, String.format("PROJECT_VERSION [%s]", this.PROJECT_VERSION)));
        mvnCommand.append(this.ifDo(this.MVN_REMOVE_SNAPSHOT, "-DremoveSnapshot=true", "REMOVE_SNAPSHOT"));
        mvnCommand.append(this.ifDo(!this.IS_POM && this.MVN_JAVA_DOC, "javadoc:jar -Dnodeprecatedlist -Dquiet=true", "JAVA_DOC"));
        mvnCommand.append(this.ifDo(!this.IS_POM && this.MVN_SOURCE, "source:jar-no-fork", "SOURCE"));
        mvnCommand.append(this.ifDo(this.hasNewTag(), "scm:tag -Dtag=" + this.PROJECT_VERSION + " " + "-Dmessage=" + this.getBranchName(), "TAG"));
        mvnCommand.append(this.ifDo(this.GPG_PASS, "gpg:sign -Darguments=-D--pinentry-mode -Darguments=-Dloopback -Dgpg.passphrase=" + this.GPG_PASS, "GPG_PASS"));
        mvnCommand.append(this.ifDo(this.GPG_PASS_ALT, "berlin.yuna:maven-gpg-plugin:sign -Darguments=-D--pinentry-mode -Darguments=-Dloopback -Dgpg.passphrase=" + this.GPG_PASS_ALT, "GPG_PASS_ALT"));
        mvnCommand.append(this.ifDo(this.MVN_DEPLOY_ID, this.prepareNexusDeployUrl(), "DEPLOY_ID"));
        mvnCommand.append(this.ifDo(this.MVN_OPTIONS, this.MVN_OPTIONS, "OPTIONS"));
        mvnCommand.append(this.ifDo(this.ENCODING, "-Dproject.build.sourceEncoding=" + this.ENCODING, "ENCODING"));
        mvnCommand.append(this.ifDo(this.ENCODING, "-Dproject.reporting.outputEncoding=" + this.ENCODING));
        mvnCommand.append(this.ifDo(this.ENCODING, "-Dproject.encoding=" + this.ENCODING));
        mvnCommand.append(this.ifDo(this.JAVA_VERSION, "-Dmaven.compiler.source=" + this.JAVA_VERSION, "JAVA_VERSION"));
        mvnCommand.append(this.ifDo(this.JAVA_VERSION, "-Dmaven.compiler.target=" + this.JAVA_VERSION));
        mvnCommand.append(this.ifDo(!this.MVN_SKIP_TEST, this.prepareSurFire(), "SKIP_TEST"));
        mvnCommand.append(this.ifDo(!this.MVN_SKIP_TEST, this.prepareFailSafe()));
        mvnCommand.append(this.ifDo(this.MVN_PROFILES, this.prepareMavenProfileParam(), "PROFILES"));
        mvnCommand.append(this.ifDo(this.MVN_REPORT, "versions:display-dependency-updates versions:display-plugin-updates", "REPORT"));
        mvnCommand.append(this.ifDo(!this.isEmpty(this.PROJECT_VERSION) || this.MVN_REMOVE_SNAPSHOT || this.MVN_REPORT, "-DgenerateBackupPoms=false"));
        if (!this.isEmpty(this.GPG_PASS_ALT)) {
            new GpgUtil(this.LOG).downloadMavenGpgIfNotExists(this.PROJECT_DIR);
        }
        return mvnCommand.toString().trim();
    }

    private String buildSettings(CommandLineReader clr) {
        SettingsXmlBuilder settingsBuilder = new SettingsXmlBuilder();
        List<String> serverList = clr.getValues("S_SERVER");
        for (int i = 0; i < serverList.size(); ++i) {
            settingsBuilder.addServer(serverList.get(i), clr.getValue(i, "S_USERNAME"), clr.getValue(i, "S_PASSWORD"));
        }
        return settingsBuilder.create().getAbsolutePath();
    }

    public CommandLineReader getCommandLineReader() {
        return this.clr;
    }

    private Model parsePomFile(File projectDir) {
        try {
            return new MavenXpp3Reader().read(new FileReader(new File(projectDir, "pom.xml")));
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException("could not read pom.xml \n ", e);
        }
    }

    private String prepareSurFire() {
        File failSafeConf = this.createTmpConf("mvnSurFireExcludes_");
        this.writeFile(failSafeConf, "**/*IntegrationTest.java\n**/*ComponentTest.java\n**/*SmokeTest.java");
        return "-Dsurefire.useSystemClassLoader=false -Dsurefire.excludesFile=" + failSafeConf.getAbsolutePath();
    }

    private String prepareFailSafe() {
        File failSafeConf = this.createTmpConf("mvnFailSafeIncludes_");
        this.writeFile(failSafeConf, "**/*IntegrationTest.java\n**/*ComponentTest.java\n**/*Test.java");
        return "failsafe:integration-test -Dfailsafe.includesFile=" + failSafeConf.getAbsolutePath();
    }

    private String prepareNexusDeployUrl() {
        return MavenCommands.SONATYPE_PLUGIN + " -DaltDeploymentRepository=" + this.MVN_DEPLOY_ID + "::" + MavenCommands.MVN_DEPLOY_LAYOUT + "::" + MavenCommands.SONATYPE_STAGING_URL + " -DnexusUrl=" + MavenCommands.SONATYPE_URL + " -DserverId=" + this.MVN_DEPLOY_ID + " -DautoReleaseAfterClose=false";
    }

    private boolean hasNewTag() {
        if ((this.MVN_TAG || this.MVN_TAG_BREAK) && !this.isEmpty(this.PROJECT_VERSION)) {
            String lastGitTag = this.gitService.getLastGitTag();
            this.printTagMessage(lastGitTag);
            return !this.PROJECT_VERSION.equalsIgnoreCase(lastGitTag);
        }
        return false;
    }

    private void printTagMessage(String lastGitTag) {
        if (this.MVN_TAG_BREAK && this.PROJECT_VERSION.equalsIgnoreCase(lastGitTag)) {
            throw new RuntimeException(String.format("GIT_TAG [%s] already exists", this.PROJECT_VERSION));
        }
        this.LOG.info(String.format("New GIT_TAG [%s]", this.PROJECT_VERSION));
    }

    private boolean isEmpty(String test) {
        return test == null || test.trim().isEmpty();
    }

    private String prepareMavenProfileParam() {
        if (this.MVN_PROFILES) {
            this.LOG.debug("Read maven profiles");
            String command = "mvn help:all-profiles | grep \"Profile Id\" | cut -d' ' -f 5 | xargs | tr ' ' ',' | tail -n 1";
            String mvnProfiles = this.newTerminal().timeoutMs(-1L).execute("mvn help:all-profiles | grep \"Profile Id\" | cut -d' ' -f 5 | xargs | tr ' ' ',' | tail -n 1").consoleInfo();
            this.LOG.info(String.format("Found maven profiles [%s]", mvnProfiles.trim()));
            return this.isEmpty(mvnProfiles) ? "" : "--activate-profiles=" + mvnProfiles.trim();
        }
        return "";
    }

    private Boolean isPomArtifact(Model pom) {
        String packaging = pom.getPackaging();
        return this.isEmpty(packaging) || packaging.trim().equals("pom");
    }

    private String ifDo(String trigger, String arg) {
        return this.ifDo(!this.isEmpty(trigger), arg);
    }

    private String ifDo(boolean trigger, String arg) {
        return trigger ? arg + " " : "";
    }

    private String ifDo(String trigger, String arg, String description) {
        return this.ifDo(!this.isEmpty(trigger), arg, description);
    }

    private String ifDo(boolean trigger, String arg, String description) {
        this.LOG.debug(String.format("[%s] [%s]", trigger, description));
        return trigger && !this.isEmpty(arg) ? arg + " " : "";
    }

    private String getString(CommandLineReader clr, String key, String fallback) {
        return this.getOrElse(clr.getValue(key), fallback);
    }

    private boolean getBoolean(CommandLineReader clr, String key, boolean fallback) {
        boolean present = clr.isPresent(key);
        String value = clr.getValue(key);
        if (present && this.isEmpty(value)) {
            return true;
        }
        return this.getOrElse(value, fallback);
    }

    private boolean getOrElse(String test, boolean fallback) {
        return !this.isEmpty(test) ? Boolean.valueOf(test) : fallback;
    }

    private String getOrElse(String test, String fallback) {
        return !this.isEmpty(test) ? test : fallback;
    }

    private File getOrElse(String test, File fallback) {
        File file;
        File file2 = file = !this.isEmpty(test) ? new File(test) : fallback;
        if (!file.exists()) {
            throw new RuntimeException(String.format("Path [%s] does not exist", file));
        }
        return file;
    }

    private Terminal newTerminal() {
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.LOG::error;
        return new Terminal().breakOnError(true).consumerError(consumerArray).dir(this.PROJECT_DIR).timeoutMs(32000L);
    }

    private File createTmpConf(String prefix) {
        try {
            return File.createTempFile(prefix, ".conf");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeFile(File file, String content) {
        try {
            Files.write(file.toPath(), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

