/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.logic;

import berlin.yuna.mavendeploy.logic.GitService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemanticService {
    private final String[] SEMANTIC_FORMAT;
    private String branchName;

    public String getBranchName() {
        return this.branchName;
    }

    SemanticService(String semanticFormat) {
        this.SEMANTIC_FORMAT = semanticFormat.split("::");
    }

    String getNextSemanticVersion(String currentVersion, GitService gitService, String fallback) {
        for (int commitNumber = 1; commitNumber < 32; ++commitNumber) {
            String branchName = gitService.findOriginalBranchName(commitNumber);
            int semanticPosition = this.getSemanticPosition(branchName);
            if (branchName == null || branchName.trim().isEmpty() || semanticPosition == -1) continue;
            this.branchName = branchName;
            return this.getNextSemanticVersion(currentVersion, semanticPosition);
        }
        return fallback;
    }

    String getNextSemanticVersion(String versionOrg, int semanticPosition) {
        String separator = this.getSemanticSeparator(versionOrg);
        StringBuilder nextVersion = new StringBuilder();
        for (String digit : this.prepareNextSemanticVersion(versionOrg, semanticPosition)) {
            nextVersion.append(digit).append(separator);
        }
        return nextVersion.delete(nextVersion.length() - 1, nextVersion.length()).toString();
    }

    private String getSemanticSeparator(String versionOrg) {
        Matcher matcher = Pattern.compile(this.SEMANTIC_FORMAT[0]).matcher(versionOrg);
        return matcher.find() ? matcher.group(0) : ".";
    }

    private String[] prepareNextSemanticVersion(String versionOrg, int semanticPosition) {
        String[] version = versionOrg.split(this.SEMANTIC_FORMAT[0]);
        version[semanticPosition] = Integer.valueOf(Integer.valueOf(version[semanticPosition]) + 1).toString();
        for (int i = semanticPosition + 1; i < version.length; ++i) {
            version[i] = "0";
        }
        return version;
    }

    private int getSemanticPosition(String branchName) {
        for (int i = 1; i < this.SEMANTIC_FORMAT.length; ++i) {
            if (!Pattern.compile(this.SEMANTIC_FORMAT[i]).matcher(branchName).find()) continue;
            return i - 1;
        }
        return -1;
    }
}

