/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.logic;

import berlin.yuna.clu.logic.Terminal;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

public class GitService {
    private final File workDir;
    private final Terminal terminal;
    private static final Pattern PATTERN_ORIGINAL_BRANCH_NAME = Pattern.compile("(?<prefix>.*refs\\/.*?\\/)(?<branchName>.*?)(?<suffix>@.*?)");

    public GitService(Log log, File workDir) {
        this.workDir = workDir;
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = log::error;
        this.terminal = new Terminal().timeoutMs(30000L).breakOnError(true).dir(workDir).consumerError(consumerArray);
    }

    public File clone(String url, String name) {
        this.terminal.breakOnError(false).execute("git clone " + url + " " + name);
        return new File(this.workDir, name);
    }

    public String getLastGitTag() {
        String tag;
        try {
            this.terminal.execute("git fetch --tags --force");
        }
        catch (Exception exception) {
        }
        finally {
            tag = this.terminal.execute("git describe --tag --always --abbrev=0").consoleInfo().trim();
        }
        return tag;
    }

    public String getLastRefLog(int commitNumber) {
        return this.terminal.execute("git reflog show --all | grep \"refs/\"  | grep \": commit:\" | head -n" + commitNumber + " | tail -n1").consoleInfo();
    }

    public boolean gitHasChanges() {
        return Boolean.valueOf(this.terminal.execute("if [[ `git status --porcelain` ]]; then echo true; else echo false; fi").consoleInfo().trim());
    }

    public String gitStash() {
        return this.terminal.execute("git stash clear; git stash").consoleInfo().trim();
    }

    public String gitLoadStash() {
        return this.terminal.execute("git checkout stash -- .").consoleInfo().trim();
    }

    public String findOriginalBranchName(int commitNumber) {
        String refLog = this.getLastRefLog(commitNumber);
        Matcher matcher = PATTERN_ORIGINAL_BRANCH_NAME.matcher(refLog);
        if (matcher.find()) {
            return matcher.group("branchName");
        }
        return null;
    }
}

