/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.logic;

import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.mavendeploy.logic.GitService;
import java.io.File;
import java.util.function.Consumer;
import org.apache.maven.plugin.logging.Log;

public class GpgUtil {
    private final Log LOG;
    private static final String CMD_MVN_REPO_PATH = "mvn help:evaluate -Dexpression=settings.localRepository | grep -v '\\[INFO\\]' | tail -n 1";
    private static final File WORK_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final String URL_MVN_GPG_PLUGIN = "https://github.com/YunaBraska/maven-gpg-plugin.git";
    private static final String NAME_MAVEN_GPG_PLUGIN = "maven-gpg-plugin";

    public GpgUtil(Log LOG) {
        this.LOG = LOG;
    }

    public synchronized void downloadMavenGpgIfNotExists(File projectDir) {
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.LOG::error;
        Terminal terminal = new Terminal().consumerError(consumerArray).dir(projectDir);
        String MVN_REPO_PATH = terminal.execute(CMD_MVN_REPO_PATH).consoleInfo();
        if (!new File(MVN_REPO_PATH, "berlin/yuna/maven-gpg-plugin").exists()) {
            this.installMavenGpgPlugin(terminal, MVN_REPO_PATH);
        } else {
            this.LOG.info(String.format("SUCCESSFULLY FOUND GPG PLUGIN FORK FROM [berlin.yuna] IN [%s]", MVN_REPO_PATH));
        }
    }

    private void installMavenGpgPlugin(Terminal terminal, String MVN_REPO_PATH) {
        this.LOG.warn(String.format("START INSTALLING GPG PLUGIN FORK FROM [berlin.yuna] TO [%s]", MVN_REPO_PATH));
        terminal.timeoutMs(-1L).clearConsole().dir(WORK_DIR);
        terminal.execute("rm -rf maven-gpg-plugin");
        new GitService(this.LOG, WORK_DIR).clone(URL_MVN_GPG_PLUGIN, NAME_MAVEN_GPG_PLUGIN);
        terminal.execute("mvn clean install -f=maven-gpg-plugin -Drat.ignoreErrors=true --quiet");
        terminal.execute("rm -rf maven-gpg-plugin");
        this.LOG.warn(String.format("FINISHED INSTALLING GPG PLUGIN FORK FROM [berlin.yuna] TO [%s]", MVN_REPO_PATH));
    }
}

