/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.logic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class SettingsXmlBuilder {
    private final Element domServers = new Element("servers");

    public File create() {
        try {
            Document doc = new Document();
            XMLOutputter outPutter = new XMLOutputter();
            File settingsFile = File.createTempFile("settings_", ".xml");
            Element domSettings = new Element("settings");
            domSettings.addContent(this.domServers);
            doc.setRootElement(domSettings);
            outPutter.setFormat(Format.getPrettyFormat());
            outPutter.output(doc, (Writer)new FileWriter(settingsFile));
            return settingsFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SettingsXmlBuilder addServer(String id, String username, String password) {
        Element domServer = new Element("server");
        this.addElement(domServer, "id", id);
        this.addElement(domServer, "username", username);
        this.addElement(domServer, "password", password);
        this.domServers.addContent(domServer);
        return this;
    }

    private void addElement(Element domServer, String elementName, String elementContent) {
        if (elementContent != null && !elementContent.isEmpty()) {
            domServer.addContent(new Element(elementName).addContent(elementContent));
        }
    }
}

