/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.plugin;

import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.mavendeploy.logic.Ci;
import berlin.yuna.mavendeploy.logic.GitService;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="run")
public class MojoRun
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File basedir;
    @Parameter(property="args", defaultValue="")
    private List<String> args;

    @Override
    public void execute() {
        Log log = this.getLog();
        GitService gitService = new GitService(log, this.basedir);
        boolean gitStash = gitService.gitHasChanges();
        if (gitStash) {
            log.warn("Stashing uncommitted git changes");
            gitService.gitStash();
        }
        log.info("Preparing information");
        Ci ci = new Ci(log, this.args.toArray(new String[0]));
        String mavenCommand = ci.prepareMaven();
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = log::info;
        Consumer[] consumerArray2 = new Consumer[1];
        consumerArray2[0] = log::error;
        int status = new Terminal().dir(this.basedir).consumerInfo(consumerArray).consumerError(consumerArray2).execute(mavenCommand).status();
        if (ci.allowCommitMessage()) {
            String commitMessage = ci.prepareCommitMessage();
            new Terminal().dir(this.basedir).execute("mvn scm:checkin -Dmessage='" + commitMessage + "'");
        }
        if (gitStash) {
            log.warn("Load uncommitted git changes");
            gitService.gitLoadStash();
        }
        if (status != 0) {
            throw new RuntimeException(String.format("Status [%s]", status));
        }
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }
}

