/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.config;

import berlin.yuna.mavendeploy.config.MojoBase;
import berlin.yuna.mavendeploy.logic.SettingsXmlReader;
import berlin.yuna.mavendeploy.model.Prop;
import berlin.yuna.mavendeploy.plugin.PluginExecutor;
import berlin.yuna.mavendeploy.plugin.PluginSession;
import berlin.yuna.mavendeploy.util.MojoUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class Deploy
extends MojoBase {
    public Deploy(PluginSession session) {
        super("org.apache.maven.plugins", "maven-deploy-plugin", "2.8.2", session);
    }

    public static Deploy build(PluginSession session) {
        return new Deploy(session);
    }

    public Deploy deploy() throws MojoExecutionException {
        String goal = "deploy";
        this.prepareSettingsServer();
        this.configureDeployment();
        this.logGoal("deploy", true);
        PluginExecutor.executeMojo(this.getPlugin(), PluginExecutor.goal("deploy"), this.session.prepareXpp3Dom(Prop.prop("altDeploymentRepository"), Prop.prop("altReleaseDeploymentRepository"), Prop.prop("altSnapshotDeploymentRepository"), Prop.prop("deployAtEnd"), Prop.prop("retryFailedDeploymentCount"), Prop.prop("maven.deploy.skip")), this.session.getEnvironment());
        this.logGoal("deploy", false);
        return this;
    }

    public void prepareSettingsServer() {
        List<Server> serverList = SettingsXmlReader.read(this.session);
        serverList.forEach(server -> PluginSession.addSecret("pass", server.getPassword()));
        serverList.forEach(server -> this.log.info("%s [%s] added %s", PluginSession.unicode(10010), Settings.class.getSimpleName(), this.session.toString((Server)server)));
        serverList.forEach(server -> {
            if (this.session.getMavenSession().getSettings().getServer(server.getId()) == null) {
                this.session.getMavenSession().getSettings().addServer((Server)server);
            }
        });
    }

    public void configureDeployment() {
        String deployUrl = this.session.getParamPresent("deploy.url").orElse("http://deploy.url-not.found");
        String deployId = this.session.getParamPresent("deploy.id").orElse(this.findServerByDeployUrl(deployUrl).orElse(new Server()).getId());
        this.session.setParameter("deployId", deployId, true);
        this.session.setParameter("deploy.url", deployUrl, true);
        this.session.setParameter("altDeploymentRepository", deployId + "::default::" + deployUrl, true);
        if (this.session.getProject().getDistributionManagement() == null) {
            this.session.getProject().setDistributionManagement(new DistributionManagement());
        }
        if (this.session.getParamPresent("deploy").isPresent()) {
            if (this.session.getProject().getDistributionManagement().getRepository() == null || !this.session.getProject().getDistributionManagement().getRepository().getId().equals(deployId)) {
                this.log.info("%s Created repository id [%s] url [%s]", PluginSession.unicode(128209), deployId, deployUrl);
                this.session.getProject().getDistributionManagement().setRepository(this.prepareRepository(deployId, deployUrl));
            }
        } else if (this.session.getParamPresent("deploy.snapshot").isPresent() && (this.session.getProject().getDistributionManagement().getSnapshotRepository() == null || !this.session.getProject().getDistributionManagement().getSnapshotRepository().getId().equals(deployId))) {
            this.log.info("%s Created snapshot-repository id [%s] url [%s]", PluginSession.unicode(128209), deployId, deployUrl);
            this.session.getProject().getDistributionManagement().setSnapshotRepository(this.prepareRepository(deployId, deployUrl));
        }
    }

    public boolean isNexusDeployment() {
        Optional<String> nexusDeployment = this.session.getParamPresent("deploy.nexus");
        String deployUrl = this.session.getParamPresent("deploy.url").orElse("http://deploy.url-not.found");
        if (nexusDeployment.isEmpty() && Stream.of("nexus", "sonatype", "oss").anyMatch(nexus -> deployUrl.toLowerCase().contains((CharSequence)nexus))) {
            this.session.setParameter("deploy.nexus", "true", true);
            return true;
        }
        return false;
    }

    private DeploymentRepository prepareRepository(String deployId, String deployUrl) {
        DeploymentRepository repository = new DeploymentRepository();
        repository.setUrl(deployUrl);
        repository.setId(deployId);
        repository.setName(repository.getId());
        return repository;
    }

    private Optional<Server> findServerByDeployUrl(String deployUrl) {
        this.log.warn("[deploy.id] not set");
        String[] artifactRepositories = (String[])Arrays.stream(new String[]{"nexus", "artifact", "archiva", "repository", "snapshot"}).sorted(Comparator.comparingInt(o -> deployUrl.toLowerCase().contains(o.toLowerCase()) ? -1 : 1)).toArray(String[]::new);
        Optional<Server> server = this.getServerContains(artifactRepositories);
        if (server.isPresent()) {
            this.log.info("%s Fallback to [deploy.id] [%s]", PluginSession.unicode(128273), server.get().getId());
        } else {
            this.log.warn("Cant find [deploy.id] by [deploy.url] [%s]", deployUrl);
        }
        return server;
    }

    private Optional<Server> getServerContains(String ... names) {
        List<Server> servers = this.session.getMavenSession().getSettings().getServers();
        if (servers != null && !servers.isEmpty()) {
            this.log.debug("serverList [%s]", servers.stream().map(IdentifiableBase::getId).collect(Collectors.joining(", ")));
            for (String name : names) {
                Optional<Server> server = servers.stream().filter(s -> !MojoUtil.isEmpty(s.getId())).filter(s -> s.getId().toLowerCase().contains(name.toLowerCase()) || !MojoUtil.isEmpty(s.getUsername()) && s.getUsername().toLowerCase().contains(name)).findFirst();
                this.log.debug("server [%s] name [%s]", server.orElse(new Server()).getId(), name);
                if (!server.isPresent()) continue;
                return server;
            }
        }
        return servers != null ? servers.stream().findFirst() : Optional.empty();
    }
}

