/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.config;

import berlin.yuna.mavendeploy.model.Logger;
import berlin.yuna.mavendeploy.plugin.PluginExecutor;
import berlin.yuna.mavendeploy.plugin.PluginSession;
import java.util.Objects;
import org.apache.maven.model.Plugin;

public abstract class MojoBase {
    private final String groupId;
    private final String artifactId;
    private final String version;
    final PluginSession session;
    final Logger log;

    MojoBase(String groupId, String artifactId, String version, PluginSession session) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.session = session;
        this.log = session.getLog();
    }

    public String groupId() {
        return this.groupId;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String version() {
        return this.version;
    }

    public Logger log() {
        return this.log;
    }

    public Plugin toPlugin() {
        Plugin plugin = new Plugin();
        plugin.setGroupId(this.groupId);
        plugin.setArtifactId(this.artifactId);
        plugin.setVersion(this.version);
        return plugin;
    }

    Plugin getPlugin() {
        return PluginExecutor.plugin(PluginExecutor.groupId(this.groupId), PluginExecutor.artifactId(this.artifactId), PluginExecutor.version(this.version));
    }

    void logGoal(String goal, boolean start) {
        this.log.info("--------------------------<=[ %s %s:%s:%s:%s ]=>--------------------------", start ? "Start" : "End", this.groupId, this.artifactId, goal, this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MojoBase mojoBase = (MojoBase)o;
        return Objects.equals(this.groupId, mojoBase.groupId) && Objects.equals(this.artifactId, mojoBase.artifactId);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId);
    }

    public String toString() {
        return "MojoBase{groupId='" + this.groupId + "', artifactId='" + this.artifactId + "'}";
    }
}

