/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.config;

import berlin.yuna.mavendeploy.config.MojoBase;
import berlin.yuna.mavendeploy.model.Parameter;
import berlin.yuna.mavendeploy.plugin.PluginSession;
import berlin.yuna.mavendeploy.util.MojoUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class PropertyWriter
extends MojoBase {
    final String[] EXCLUDES = new String[]{"java.command", "args"};

    public PropertyWriter(PluginSession session) {
        super("berlin.yuna", "property-writer", "0.0.1", session);
    }

    public static PropertyWriter build(PluginSession session) {
        return new PropertyWriter(session);
    }

    public PropertyWriter write() {
        String goal = "write";
        this.logGoal("write", true);
        this.writeToFile();
        this.logGoal("write", false);
        return this;
    }

    private void writeToFile() {
        File output = this.getOutputFile();
        try {
            this.session.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> PluginSession.addSecret(String.valueOf(key), String.valueOf(value))));
            StringBuilder stringBuilder = new StringBuilder();
            this.session.getProperties().entrySet().stream().filter(this.excludeProps()).map(this::entryToString).sorted().forEach(r -> stringBuilder.append((String)r).append(System.lineSeparator()));
            this.log.info("%s Writing properties to file [%s]", PluginSession.unicode(128209), output.getAbsolutePath());
            if (!output.getParentFile().exists()) {
                Files.createDirectories(output.getParentFile().toPath(), new FileAttribute[0]);
            }
            Files.write(output.toPath(), PluginSession.hideSecrets(stringBuilder.toString()).getBytes(), new OpenOption[0]);
            if (output.exists()) {
                this.log.info("%s Properties [file://%s]", PluginSession.unicode(128278), output.toURI().getRawPath());
            }
        }
        catch (Exception e) {
            this.log.error("Could not write properties to file [%s] %s[%s]", output, System.lineSeparator(), e);
        }
    }

    private Predicate<Map.Entry<Object, Object>> excludeProps() {
        return e -> Arrays.stream(this.EXCLUDES).noneMatch(k -> String.valueOf(e.getKey()).toLowerCase().contains(k.toLowerCase()));
    }

    protected String entryToString(Map.Entry<Object, Object> entry) {
        return (entry.getKey() + " = " + (MojoUtil.isEmpty(String.valueOf(entry.getValue())) ? "" : String.valueOf(entry.getValue()))).replace("\r", " ").replace("\n", " ").replace("\t", " ");
    }

    private File getOutputFile() {
        return this.session.getBoolean("properties.print").orElse(false) != false ? new File(this.session.getParamFallback(Parameter.BASE_DIR.key(), ""), Parameter.TARGET.maven() + File.separator + "all.properties") : new File(this.session.getParamFallback("properties.print", ""));
    }
}

