/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.config;

import berlin.yuna.mavendeploy.config.MojoBase;
import berlin.yuna.mavendeploy.model.Parameter;
import berlin.yuna.mavendeploy.model.Prop;
import berlin.yuna.mavendeploy.plugin.PluginExecutor;
import berlin.yuna.mavendeploy.plugin.PluginSession;
import berlin.yuna.mavendeploy.util.MojoUtil;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class Versions
extends MojoBase {
    public Versions(PluginSession session) {
        super("org.codehaus.mojo", "versions-maven-plugin", "2.7", session);
    }

    public static Versions build(PluginSession session) {
        return new Versions(session);
    }

    public Versions updateParent() throws MojoExecutionException {
        String goal = "update-parent";
        this.logGoal("update-parent", true);
        PluginExecutor.executeMojo(this.getPlugin(), PluginExecutor.goal("update-parent"), this.session.prepareXpp3Dom(Prop.prop("allowSnapshots"), Prop.prop(Parameter.POM_BACKUP.maven())), this.session.getEnvironment());
        this.logGoal("update-parent", false);
        return this;
    }

    public Versions updateProperties() throws MojoExecutionException {
        String goal = "update-properties";
        this.logGoal("update-properties", true);
        PluginExecutor.executeMojo(this.getPlugin(), PluginExecutor.goal("update-properties"), this.session.prepareXpp3Dom(Prop.prop("allowDowngrade"), Prop.prop("allowIncrementalUpdates"), Prop.prop("allowMajorUpdates"), Prop.prop("allowMinorUpdates"), Prop.prop("allowSnapshots"), Prop.prop("autoLinkItems"), Prop.prop("excludeReactor"), Prop.prop(Parameter.POM_BACKUP.maven()), Prop.prop("processDependencies"), Prop.prop("processDependencyManagement"), Prop.prop("processParent")), this.session.getEnvironment());
        this.logGoal("update-properties", false);
        return this;
    }

    public Versions updateChildModules() throws MojoExecutionException {
        String goal = "update-child-modules";
        this.logGoal("update-child-modules", true);
        PluginExecutor.executeMojo(this.getPlugin(), PluginExecutor.goal("update-child-modules"), this.session.prepareXpp3Dom(Prop.prop("allowSnapshots"), Prop.prop(Parameter.POM_BACKUP.maven())), this.session.getEnvironment());
        this.logGoal("update-child-modules", false);
        return this;
    }

    public Versions useLatestReleases() throws MojoExecutionException {
        String goal = "use-latest-releases";
        this.logGoal("use-latest-releases", true);
        PluginExecutor.executeMojo(this.getPlugin(), PluginExecutor.goal("use-latest-releases"), this.session.prepareXpp3Dom(Prop.prop("allowIncrementalUpdates"), Prop.prop("allowMajorUpdates"), Prop.prop("allowMinorUpdates"), Prop.prop("allowSnapshots"), Prop.prop("excludeReactor"), Prop.prop(Parameter.POM_BACKUP.maven()), Prop.prop("processDependencyManagement"), Prop.prop("processParent")), this.session.getEnvironment());
        this.logGoal("use-latest-releases", false);
        return this;
    }

    public Versions useNextSnapshots() throws MojoExecutionException {
        String goal = "use-next-snapshots";
        this.logGoal("use-next-snapshots", true);
        PluginExecutor.executeMojo(this.getPlugin(), PluginExecutor.goal("use-next-snapshots"), this.session.prepareXpp3Dom(Prop.prop("allowIncrementalUpdates"), Prop.prop("allowMajorUpdates"), Prop.prop("allowMinorUpdates"), Prop.prop("allowSnapshots"), Prop.prop("excludeReactor"), Prop.prop(Parameter.POM_BACKUP.maven()), Prop.prop("processDependencies"), Prop.prop("processDependencyManagement"), Prop.prop("processParent")), this.session.getEnvironment());
        this.logGoal("use-next-snapshots", false);
        return this;
    }

    public Versions useLatestVersions() throws MojoExecutionException {
        String goal = "use-latest-versions";
        this.logGoal("use-latest-versions", true);
        PluginExecutor.executeMojo(this.getPlugin(), PluginExecutor.goal("use-latest-versions"), this.session.prepareXpp3Dom(Prop.prop("allowIncrementalUpdates"), Prop.prop("allowMajorUpdates"), Prop.prop("allowMinorUpdates"), Prop.prop("allowSnapshots"), Prop.prop("excludeReactor"), Prop.prop(Parameter.POM_BACKUP.maven()), Prop.prop("processDependencies"), Prop.prop("processDependencyManagement"), Prop.prop("processParent")), this.session.getEnvironment());
        this.logGoal("use-latest-versions", false);
        return this;
    }

    public Versions set() throws MojoExecutionException {
        String goal = "set";
        this.logGoal("set", true);
        PluginExecutor.executeMojo(this.getPlugin(), PluginExecutor.goal("set"), this.session.prepareXpp3Dom(Prop.prop("allowSnapshots"), Prop.prop("artifactId"), Prop.prop(Parameter.POM_BACKUP.maven()), Prop.prop("groupId"), Prop.prop("nextSnapshot"), Prop.prop("oldVersion"), Prop.prop("processAllModules"), Prop.prop("processDependencies"), Prop.prop("processParent"), Prop.prop("processPlugins"), Prop.prop("removeSnapshot"), Prop.prop("updateMatchingVersions")), this.session.getEnvironment());
        this.session.getParamPresent(Parameter.NEW_VERSION.maven()).ifPresent(this::modifySessionVersion);
        this.logGoal("set", false);
        return this;
    }

    public Versions commit() throws MojoExecutionException {
        String goal = "commit";
        this.logGoal("commit", true);
        PluginExecutor.executeMojo(this.getPlugin(), PluginExecutor.goal("commit"), PluginExecutor.configuration(new PluginExecutor.Element[0]), this.session.getEnvironment());
        this.logGoal("commit", false);
        return this;
    }

    private void modifySessionVersion(String newVersion) {
        MavenProject project = this.session.getProject();
        String oldVersion = project.getVersion();
        String finalName = this.session.getParamPresent("project.build.finalName").orElse(this.session.getParamPresent("finalName").orElse((String)(project.getBuild() != null && MojoUtil.isPresent(project.getBuild().getFinalName()) ? project.getBuild().getFinalName() : project.getArtifactId() + "-" + oldVersion))).replace(oldVersion, newVersion);
        this.session.setParameter("finalName", finalName, true);
        this.session.setParameter("project.build.finalName", finalName, true);
        project.getAttachedArtifacts().forEach(a -> a.setVersion(a.getVersion().replace(oldVersion, newVersion)));
        project.getAttachedArtifacts().forEach(a -> this.log.debug("Attached artifact [%s] [%s]", a.getArtifactId(), a.getVersion()));
        this.session.setParameter("oldVersion", oldVersion, true);
        project.setVersion(newVersion);
        if (project.getBuild() != null) {
            project.getBuild().setFinalName(finalName);
        }
    }
}

