/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.logic;

import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.mavendeploy.model.Logger;
import berlin.yuna.mavendeploy.plugin.PluginSession;
import berlin.yuna.mavendeploy.util.MojoUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogEntry;

public class GitService {
    private final Logger log;
    private final boolean fake;
    private final File workDir;
    private final boolean active;
    private static final Pattern PATTERN_BRANCH_NAME_REF = Pattern.compile("(.*refs\\/(?<prefix>\\w*\\/)(origin\\/)*)(?<branchName>.*)(?<suffix>@.*)");
    private static final String SHA_REF_PATTERN = "([0-9a-f]{5,40}\\s*refs\\/heads\\/)";

    public GitService(Logger log, File workDir, boolean fake) {
        boolean hasGit = this.hasGit(log, workDir);
        this.workDir = workDir;
        this.log = log;
        this.fake = fake && !hasGit;
        this.active = hasGit;
        this.logFakeMessage(log);
    }

    public String getLastGitTag() {
        String tag;
        if (!this.active) {
            return null;
        }
        try {
            this.getString("git fetch --tags --force");
        }
        catch (Exception exception) {
        }
        finally {
            tag = this.getString("git describe --tag --always --abbrev=0").orElse(null);
        }
        return tag;
    }

    public Map<String, String> getConfig() {
        if (!this.active) {
            return new HashMap<String, String>();
        }
        Properties properties = new Properties();
        Optional<String> config = this.getString("git config -l | cat");
        if (config.isPresent()) {
            try {
                properties.load(new StringReader(config.get().replaceAll("[\\n|\\r|\\s|$|]", "\n")));
            }
            catch (IOException e) {
                this.log.error("Could not read git config due [%s] %s", config, e);
            }
        }
        return properties.entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> String.valueOf(entry.getValue())));
    }

    private Collection<ReflogEntry> getRefLog() {
        if (!this.active) {
            return null;
        }
        try {
            return Git.open(this.workDir).reflog().call();
        }
        catch (IOException | GitAPIException e) {
            this.log.error("Could not read git directory due %s", e);
            return null;
        }
    }

    public Optional<String> getOriginUrl() {
        return this.active ? this.getString("git config --get remote.origin.url") : Optional.empty();
    }

    public boolean gitHasChanges() {
        try {
            return this.active && Git.open(this.workDir).status().call().isClean();
        }
        catch (IOException | GitAPIException e) {
            this.log.error("Could not read git directory due %s", e);
            return false;
        }
    }

    public boolean gitStash() {
        if (this.fake) {
            this.log.warn("Fake stash");
        }
        try {
            return this.active && Git.open(this.workDir).stashCreate().call() != null;
        }
        catch (IOException | GitAPIException e) {
            this.log.error("Failed to stash %s", e);
            return false;
        }
    }

    public String gitLoadStash() {
        if (this.fake) {
            this.log.warn("Fake load stash");
        }
        try {
            return this.active ? Git.open(this.workDir).stashApply().call().toObjectId().getName() : null;
        }
        catch (IOException | GitAPIException e) {
            this.log.debug("Failed to load stash " + e);
            this.getTerminal().breakOnError(false).execute("git stash pop");
            return "failed";
        }
    }

    public Optional<String> getBranchNameRefLog() {
        String[] refLog;
        if (!this.active) {
            return Optional.empty();
        }
        for (String refLogEntry : refLog = this.getString("git reflog show --all | grep \"refs/heads/\" | head -n90").orElse("").split(SHA_REF_PATTERN)) {
            Matcher matcher = PATTERN_BRANCH_NAME_REF.matcher(refLogEntry);
            if (!matcher.find()) continue;
            return Optional.ofNullable(matcher.group("branchName").trim().split("\\s")[0]);
        }
        return this.getBranchName();
    }

    public Optional<String> getBranchName() {
        if (!this.active) {
            return Optional.empty();
        }
        try {
            ReflogEntry reflogEntry = Objects.requireNonNull(this.getRefLog()).iterator().next();
            Object branches = Git.open(this.workDir).branchList().call();
            Iterator iterator = branches.iterator();
            while (iterator.hasNext()) {
                Ref branch = (Ref)iterator.next();
                if (!branch.getObjectId().equals(reflogEntry.getNewId())) continue;
                return Optional.ofNullable(branch.getName());
            }
            return Optional.ofNullable(((Ref)branches.get(0)).getName());
        }
        catch (IOException | GitAPIException e) {
            this.log.error("Could not read git directory due %e", e);
            return Optional.empty();
        }
    }

    private void logFakeMessage(Logger log) {
        if (this.fake) {
            log.warn("Faked [%s]", this.getClass().getSimpleName());
        }
    }

    private Terminal getTerminal() {
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.log::error;
        return new Terminal().timeoutMs(30000L).breakOnError(true).dir(this.workDir).consumerError(consumerArray);
    }

    private Optional<String> getString(String command) {
        String result = this.getTerminal().execute("tmp=$(" + command + "); if [ -z \"${tmp}\" ]; then echo null; else echo ${tmp}; fi").consoleInfo();
        return Optional.ofNullable(result.equalsIgnoreCase("null") || MojoUtil.isEmpty(result) ? null : result.trim());
    }

    private boolean hasGit(Logger log, File workDir) {
        boolean hasGit;
        try {
            hasGit = Optional.ofNullable(Git.open(workDir).status().call()).isPresent();
        }
        catch (Exception e) {
            log.info("%s Project is not a git repository [%s]", PluginSession.unicode(128205), workDir);
            hasGit = false;
        }
        return hasGit;
    }
}

