/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.logic;

import berlin.yuna.mavendeploy.plugin.PluginSession;
import berlin.yuna.mavendeploy.util.MojoUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Server;

public class SettingsXmlReader {
    private final PluginSession session;

    private SettingsXmlReader(PluginSession session) {
        this.session = session;
    }

    private List<Server> read() {
        HashMap result = new HashMap();
        this.parseFormatOne().forEach(server -> result.put(server.getId(), server));
        this.parseFormatTwo().forEach(server -> result.put(server.getId(), server));
        this.parseFormatThree().forEach(server -> result.put(server.getId(), server));
        return result.values().stream().filter(s -> MojoUtil.isPresent(s.getId())).sorted(Comparator.comparing(IdentifiableBase::getId)).collect(Collectors.toList());
    }

    public static List<Server> read(PluginSession session) {
        return new SettingsXmlReader(session).read();
    }

    private List<Server> parseFormatOne() {
        ArrayList<Server> result = new ArrayList<Server>();
        this.session.getParamPresent("settings.xml").ifPresent(settings -> {
            List servers = Arrays.stream(settings.split("(?i)--serverId=")).filter(MojoUtil::isPresent).map(s -> "--serverId=" + s).collect(Collectors.toList());
            for (String server : servers) {
                result.add(this.newServer(this.parseFormatOne(server, "serverId"), this.parseFormatOne(server, "username"), this.parseFormatOne(server, "password"), this.parseFormatOne(server, "privateKey"), this.parseFormatOne(server, "passphrase"), this.parseFormatOne(server, "filePermissions"), this.parseFormatOne(server, "directoryPermissions")));
            }
        });
        return result;
    }

    private List<Server> parseFormatTwo() {
        ArrayList<Server> result = new ArrayList<Server>();
        int tries = 0;
        int server = -1;
        while (tries < 16) {
            Optional<String> serverId = this.session.getParamPresent("server" + (Serializable)(server == -1 ? "" : Integer.valueOf(server)));
            if (serverId.isPresent()) {
                String[] values = serverId.get().split("::");
                result.add(this.newServer(this.parseFormatTwo(values, 0), this.parseFormatTwo(values, 1), this.parseFormatTwo(values, 2), this.parseFormatTwo(values, 3), this.parseFormatTwo(values, 4), this.parseFormatTwo(values, 5), this.parseFormatTwo(values, 6)));
            } else {
                ++tries;
            }
            ++server;
        }
        return result;
    }

    private List<Server> parseFormatThree() {
        ArrayList<Server> result = new ArrayList<Server>();
        int tries = 0;
        int server = -1;
        while (tries < 16) {
            String prefix = "server" + (Serializable)(server == -1 ? "" : Integer.valueOf(server)) + ".";
            Optional<String> serverId = this.session.getParamPresent(prefix + "id");
            if (serverId.isPresent()) {
                result.add(this.newServer(serverId.get(), this.parseFormatThree(prefix, "username"), this.parseFormatThree(prefix, "password"), this.parseFormatThree(prefix, "privateKey"), this.parseFormatThree(prefix, "passphrase"), this.parseFormatThree(prefix, "filepermissions"), this.parseFormatThree(prefix, "directoryPermissions")));
            } else {
                ++tries;
            }
            ++server;
        }
        return result;
    }

    private Server newServer(String serverId, String username, String password, String privateKey, String passphrase, String filePermissions, String directoryPermissions) {
        Server server = new Server();
        server.setId(serverId);
        server.setUsername(username);
        server.setPassword(password);
        server.setPrivateKey(privateKey);
        server.setPassphrase(passphrase);
        server.setFilePermissions(filePermissions);
        server.setDirectoryPermissions(directoryPermissions);
        return server;
    }

    private String parseFormatOne(String server, String search) {
        return Arrays.stream(server.split("--")).filter(MojoUtil::isPresent).filter(s -> s.toLowerCase().trim().startsWith((search + "=").toLowerCase().trim())).map(s -> s.substring((search + "=").length()).trim()).findFirst().orElse(null);
    }

    private String parseFormatTwo(String[] values, int i) {
        return values.length > i ? this.toNull(values[i]) : null;
    }

    private String parseFormatThree(String prefix, String username) {
        return this.toNull(this.session.getParamPresent(prefix + username).orElse(null));
    }

    private String toNull(String value) {
        return MojoUtil.isEmpty(value) || value.equalsIgnoreCase("null") ? null : value;
    }
}

