/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.plugin;

import berlin.yuna.mavendeploy.model.Logger;
import berlin.yuna.mavendeploy.plugin.MavenCompatibilityHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;

public class PluginExecutor {
    private static Logger logger;

    public static void executeMojo(Plugin plugin, String goal, Xpp3Dom configuration, ExecutionEnvironment env) throws MojoExecutionException {
        logger.debug("Running executeMojo for [%s]", plugin);
        if (configuration == null) {
            throw new NullPointerException("configuration may not be null");
        }
        try {
            PluginDescriptor pluginDescriptor;
            MojoDescriptor mojoDescriptor;
            PluginManagement pm;
            String executionId = null;
            if (goal != null && goal.length() > 0 && goal.indexOf(35) > -1) {
                int pos = goal.indexOf(35);
                executionId = goal.substring(pos + 1);
                goal = goal.substring(0, pos);
            }
            MavenSession session = env.getMavenSession();
            MavenProject currentProject = env.getMavenSession().getCurrentProject();
            if ((plugin.getVersion() == null || plugin.getVersion().length() == 0) && currentProject != null && (pm = currentProject.getPluginManagement()) != null) {
                for (Plugin p : pm.getPlugins()) {
                    if (!plugin.getGroupId().equals(p.getGroupId()) || !plugin.getArtifactId().equals(p.getArtifactId())) continue;
                    plugin.setVersion(p.getVersion());
                    break;
                }
            }
            if ((mojoDescriptor = (pluginDescriptor = MavenCompatibilityHelper.loadPluginDescriptor(plugin, env, session)).getMojo(goal)) == null) {
                throw new MojoExecutionException("Could not find goal '" + goal + "' in plugin " + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion());
            }
            MojoExecution exec = PluginExecutor.mojoExecution(mojoDescriptor, executionId, configuration);
            env.getPluginManager().executeMojo(session, exec);
        }
        catch (InvalidPluginDescriptorException | MojoFailureException | PluginConfigurationException | PluginDescriptorParsingException | PluginManagerException | PluginNotFoundException | PluginResolutionException e) {
            throw new MojoExecutionException("Unable to execute mojo", e);
        }
    }

    private static MojoExecution mojoExecution(MojoDescriptor mojoDescriptor, String executionId, Xpp3Dom configuration) {
        if (executionId != null) {
            return new MojoExecution(mojoDescriptor, executionId);
        }
        configuration = Xpp3DomUtils.mergeXpp3Dom(configuration, PluginExecutor.toXpp3Dom(mojoDescriptor.getMojoConfiguration()));
        return new MojoExecution(mojoDescriptor, configuration);
    }

    public static ExecutionEnvironment executionEnvironment(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager) {
        return new ExecutionEnvironment(mavenProject, mavenSession, pluginManager);
    }

    public static ExecutionEnvironment executionEnvironment(MavenSession mavenSession, BuildPluginManager pluginManager) {
        return new ExecutionEnvironment(mavenSession, pluginManager);
    }

    public static Xpp3Dom configuration(Element ... elements) {
        Xpp3Dom dom = new Xpp3Dom("configuration");
        for (Element e : elements) {
            dom.addChild(e.toDom());
        }
        return dom;
    }

    public static Plugin plugin(String groupId, String artifactId) {
        return PluginExecutor.plugin(groupId, artifactId, null);
    }

    public static Plugin plugin(String groupId, String artifactId, String version) {
        return PluginExecutor.plugin(groupId, artifactId, version, Collections.emptyList());
    }

    private static Plugin plugin(String groupId, String artifactId, String version, List<Dependency> dependencies) {
        Plugin plugin = new Plugin();
        plugin.setArtifactId(artifactId);
        plugin.setGroupId(groupId);
        plugin.setVersion(version);
        plugin.setDependencies(dependencies);
        return plugin;
    }

    public static String groupId(String groupId) {
        return groupId;
    }

    public static String artifactId(String artifactId) {
        return artifactId;
    }

    public static String version(String version) {
        return version;
    }

    public static List<Dependency> dependencies(Dependency ... dependencies) {
        return Arrays.asList(dependencies);
    }

    public static Dependency dependency(String groupId, String artifactId, String version) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        return dependency;
    }

    public static String goal(String goal) {
        return goal;
    }

    public static String name(String name) {
        return name;
    }

    public static Element element(String name, String value) {
        return new Element(name, value, new Element[0]);
    }

    public static Element element(String name, String value, Attributes attributes) {
        return new Element(name, value, attributes, new Element[0]);
    }

    public static Element element(String name, String value, Attribute attribute) {
        return new Element(name, value, new Attributes(attribute), new Element[0]);
    }

    public static Element element(String name, Element ... elements) {
        return new Element(name, elements);
    }

    public static Element element(String name, Attributes attributes, Element ... elements) {
        return new Element(name, attributes, elements);
    }

    public static Element element(String name, Attribute attribute, Element ... elements) {
        return new Element(name, new Attributes(attribute), elements);
    }

    public static Attributes attributes(Attribute ... attributes) {
        return new Attributes(attributes);
    }

    public static Attribute attribute(String name, String value) {
        return new Attribute(name, value);
    }

    public static void setLogger(Logger logger) {
        PluginExecutor.logger = logger;
        MavenCompatibilityHelper.setLogger(logger);
    }

    private static Xpp3Dom toXpp3Dom(PlexusConfiguration config) {
        Xpp3Dom result = new Xpp3Dom(config.getName());
        result.setValue(config.getValue(null));
        for (String name : config.getAttributeNames()) {
            result.setAttribute(name, config.getAttribute(name));
        }
        for (PlexusConfiguration child : config.getChildren()) {
            result.addChild(PluginExecutor.toXpp3Dom(child));
        }
        return result;
    }

    public static class ExecutionEnvironment {
        private final MavenProject mavenProject;
        private final MavenSession mavenSession;
        private final BuildPluginManager pluginManager;

        public ExecutionEnvironment(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager) {
            if (mavenSession == null) {
                throw new NullPointerException("mavenSession may not be null");
            }
            if (pluginManager == null) {
                throw new NullPointerException("pluginManager may not be null");
            }
            this.mavenProject = mavenProject;
            this.mavenSession = mavenSession;
            this.pluginManager = pluginManager;
        }

        ExecutionEnvironment(MavenSession mavenSession, BuildPluginManager pluginManager) {
            this(null, mavenSession, pluginManager);
        }

        public MavenProject getMavenProject() {
            return this.mavenProject;
        }

        public MavenSession getMavenSession() {
            return this.mavenSession;
        }

        public BuildPluginManager getPluginManager() {
            return this.pluginManager;
        }
    }

    public static class Attribute {
        private final String name;
        private final String value;

        Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class Attributes {
        private final List<Attribute> attributes;

        Attributes(Attribute ... attributes) {
            this.attributes = Arrays.asList(attributes);
        }
    }

    public static class Element {
        private final Element[] children;
        private final String name;
        private final String text;
        private final Attributes attributes;

        Element(String name, Element ... children) {
            this(name, null, new Attributes(new Attribute[0]), children);
        }

        Element(String name, Attributes attributes, Element ... children) {
            this(name, null, attributes, children);
        }

        Element(String name, String text, Element ... children) {
            this.name = name;
            this.text = text;
            this.children = children;
            this.attributes = new Attributes(new Attribute[0]);
        }

        Element(String name, String text, Attributes attributes, Element ... children) {
            this.name = name;
            this.text = text;
            this.children = children;
            this.attributes = attributes;
        }

        public Xpp3Dom toDom() {
            Xpp3Dom dom = new Xpp3Dom(this.name);
            if (this.text != null) {
                dom.setValue(this.text);
            }
            for (Element e : this.children) {
                dom.addChild(e.toDom());
            }
            for (Attribute attribute : this.attributes.attributes) {
                dom.setAttribute(attribute.name, attribute.value);
            }
            return dom;
        }
    }
}

