/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.plugin;

import berlin.yuna.mavendeploy.model.Logger;
import berlin.yuna.mavendeploy.model.Parameter;
import berlin.yuna.mavendeploy.model.Prop;
import berlin.yuna.mavendeploy.plugin.PluginExecutor;
import berlin.yuna.mavendeploy.util.MojoUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PluginSession {
    private final PluginExecutor.ExecutionEnvironment environment;
    private final Logger log = new Logger("HH:mm:ss");
    private static final Set<String> credentialInfos = ConcurrentHashMap.newKeySet();
    private static ReentrantLock secretsLock = new ReentrantLock();

    public PluginSession(PluginExecutor.ExecutionEnvironment environment) {
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hideSecrets(String text) {
        secretsLock.lock();
        try {
            if (MojoUtil.isPresent(text)) {
                String result = text.replaceAll(MojoUtil.SECRET_URL_PATTERN, "${prefix}${suffix}");
                for (String credentialInfo : credentialInfos) {
                    String secret = String.join((CharSequence)"", Collections.nCopies(credentialInfo.length(), "*"));
                    result = result.replace(credentialInfo, secret);
                }
                String string = result;
                return string;
            }
        }
        finally {
            secretsLock.unlock();
        }
        return text;
    }

    public static void addSecret(String key, String value) {
        secretsLock.tryLock();
        try {
            if (PluginSession.isSecret(key, value)) {
                credentialInfos.add(value);
            }
        }
        finally {
            secretsLock.unlock();
        }
    }

    public static boolean isSecret(String key, String value) {
        return !MojoUtil.isEmpty(key) && !MojoUtil.isEmpty(value) && (key.toLowerCase().contains("pass") || key.toLowerCase().contains("secret"));
    }

    public boolean isTrue(String ... keys) {
        return this.getBoolean(keys).orElse(false);
    }

    public boolean hasText(String ... keys) {
        return MojoUtil.isPresent(this.getParam(keys).orElse(null));
    }

    public Optional<Boolean> getBoolean(String ... keys) {
        return Arrays.stream(keys).map(this::getBoolean).filter(Optional::isPresent).findFirst().orElseGet(Optional::empty);
    }

    public Optional<Boolean> getBoolean(String key) {
        Optional<String> value = this.getParam(key);
        if (value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Boolean.parseBoolean(value.get()));
    }

    public String getParamFallback(String key, String fallback) {
        return this.getParamPresent(key).orElse(fallback);
    }

    private Optional<String> getParam(String ... keys) {
        return Arrays.stream(keys).map(this::getString).filter(Optional::isPresent).findFirst().orElseGet(Optional::empty);
    }

    public Optional<String> getParamPresent(Parameter ... keys) {
        return this.getParamPresent((String[])Arrays.stream(keys).map(Parameter::key).toArray(String[]::new));
    }

    public Optional<String> getParamPresent(String ... keys) {
        return Arrays.stream(keys).map(this::getString).filter(Optional::isPresent).filter(s -> MojoUtil.isPresent((String)s.get())).findFirst().orElseGet(Optional::empty);
    }

    private Optional<String> getString(String key) {
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            if (!(entry.getKey() instanceof String) || !this.matchKey(key, (String)entry.getKey())) continue;
            return Optional.of(String.valueOf(entry.getValue()));
        }
        return Optional.empty();
    }

    public void setParameter(String key, String value, boolean ... when) {
        this.setParameter(false, key, value, when);
    }

    public void setParameter(boolean silent, String key, String value, boolean ... when) {
        for (boolean trigger : when) {
            if (!trigger) continue;
            if (value == null && this.getParam(key).isPresent()) {
                if (!silent) {
                    this.log.debug("%s Config removed key [%s]", PluginSession.unicode(9888), key);
                }
                this.getProject().getProperties().remove(key);
                this.getMavenSession().getSystemProperties().remove(key);
                this.getMavenSession().getUserProperties().remove(key);
                break;
            }
            if (value == null || value.equals(this.getString(key).orElse(null))) break;
            PluginSession.addSecret(key, value);
            if (!silent) {
                this.log.info("%s Config added key [%s] value [%s]", PluginSession.unicode(10010), key, value);
            }
            this.getMavenSession().getUserProperties().setProperty(key, value);
            break;
        }
    }

    public void setNewParam(String key, String value) {
        this.setNewParam(false, key, value);
    }

    public void setNewParam(boolean silent, String key, String value) {
        Objects.requireNonNull(key, "setNewParam key is null");
        String cmdValue = this.getProperties().getProperty(key);
        if (MojoUtil.isEmpty(cmdValue)) {
            this.setParameter(silent, key, value, true);
        }
    }

    public Xpp3Dom prepareXpp3Dom(Prop ... prop) {
        PluginExecutor.Element[] elements = (PluginExecutor.Element[])Arrays.stream(prop).map(this::prepareElement).filter(element -> !MojoUtil.isEmpty(element.toDom().getValue()) || element.toDom().getChildCount() > 0).toArray(PluginExecutor.Element[]::new);
        return PluginExecutor.configuration(elements);
    }

    private PluginExecutor.Element prepareElement(Prop prop) {
        String resultValue;
        ArrayList<PluginExecutor.Element> childElements = new ArrayList<PluginExecutor.Element>();
        for (Prop childProp : prop.childProps) {
            childElements.add(this.prepareElement(childProp));
        }
        String key = prop.key;
        String value = prop.value;
        boolean overwrite = MojoUtil.isPresent(value) && value.startsWith("!");
        String string = resultValue = overwrite ? value.substring(1) : this.getProperties().getProperty(key, value);
        if (childElements.isEmpty()) {
            this.log.debug("Config property [%s] + [%s] = [%s]", key, value, resultValue);
            return PluginExecutor.element(PluginExecutor.name(key), resultValue);
        }
        return PluginExecutor.element(PluginExecutor.name(key), childElements.toArray(new PluginExecutor.Element[0]));
    }

    public PluginExecutor.ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    public MavenProject getProject() {
        return this.environment.getMavenProject();
    }

    public Logger getLog() {
        return this.log;
    }

    public MavenSession getMavenSession() {
        return this.environment.getMavenSession();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getProject().getProperties());
        properties.putAll((Map<?, ?>)this.getMavenSession().getSystemProperties());
        properties.putAll((Map<?, ?>)this.getMavenSession().getUserProperties());
        return properties;
    }

    public String toString(Server server) {
        return String.format("[%s] id [%s] user [%s] pass [%s]", Server.class.getSimpleName(), server.getId(), server.getUsername(), PluginSession.hideSecrets(server.getPassword()));
    }

    public static String unicode(int unicode) {
        return String.valueOf(Character.toChars(unicode));
    }

    private boolean matchKey(String key1, String key2) {
        return this.removeSeparator(key1).equals(this.removeSeparator(key2));
    }

    private String removeSeparator(String propertyKey) {
        String result = propertyKey.startsWith("env.") ? propertyKey.substring("env.".length()) : propertyKey;
        return result.replace(".", "_").replace("-", "_").toLowerCase().trim();
    }
}

