/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Exclusion;

public class ExclusionArtifactFilter
implements ArtifactFilter {
    private static final String WILDCARD = "*";
    private final List<Exclusion> exclusions;

    public ExclusionArtifactFilter(List<Exclusion> exclusions) {
        this.exclusions = exclusions;
    }

    @Override
    public boolean include(Artifact artifact) {
        for (Exclusion exclusion : this.exclusions) {
            if (WILDCARD.equals(exclusion.getGroupId()) && WILDCARD.equals(exclusion.getArtifactId())) {
                return false;
            }
            if (WILDCARD.equals(exclusion.getGroupId())) {
                return !exclusion.getArtifactId().equals(artifact.getArtifactId());
            }
            if (WILDCARD.equals(exclusion.getArtifactId())) {
                return !exclusion.getGroupId().equals(artifact.getGroupId());
            }
            if (!exclusion.getGroupId().equals(artifact.getGroupId()) || !exclusion.getArtifactId().equals(artifact.getArtifactId())) continue;
            return false;
        }
        return true;
    }
}

