/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.config;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.mavendeploy.config.MojoBase;
import berlin.yuna.mavendeploy.model.Logger;
import berlin.yuna.mavendeploy.model.Prop;
import berlin.yuna.mavendeploy.plugin.PluginExecutor;
import berlin.yuna.mavendeploy.plugin.PluginSession;
import berlin.yuna.mavendeploy.util.MojoUtil;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Profile;

public class Gpg
extends MojoBase {
    public Gpg(PluginSession session) {
        super("org.apache.maven.plugins", "maven-gpg-plugin", "1.6", session);
    }

    public static Gpg build(PluginSession session) {
        return new Gpg(session);
    }

    public Gpg sign() throws MojoExecutionException {
        String goal = "sign";
        this.addGpgToSettings();
        this.logGoal("sign", true);
        PluginExecutor.executeMojo(this.getPlugin(), PluginExecutor.goal("sign"), this.session.prepareXpp3Dom(Prop.prop("ascDirectory"), Prop.prop("gpg.defaultKeyring"), Prop.prop("excludes"), Prop.prop("passphrase", this.session.getParamFallback("gpg.passphrase", null)), Prop.prop("executable", this.session.getParamFallback("gpg.executable", "gpg")), Prop.prop("gpg.homedir"), Prop.prop("gpg.keyname"), Prop.prop("gpg.lockMode"), Prop.prop("gpgArguments", Prop.prop("arg", "--pinentry-mode"), Prop.prop("arg", "loopback")), Prop.prop("gpg.passphraseServerId"), Prop.prop("gpg.publicKeyring"), Prop.prop("gpg.secretKeyring"), Prop.prop("gpg.skip"), Prop.prop("gpg.useagent")), this.session.getEnvironment());
        this.logGoal("sign", false);
        return this;
    }

    public void addGpgToSettings() {
        Profile profile = new Profile();
        Activation activation = new Activation();
        Properties properties = new Properties();
        String gpgPath = this.session.getParamPresent("gpg.executable").orElse(Gpg.getGpgPath(this.log));
        String passPhrase = this.session.getParamPresent("gpg.pass", "gpg.passphrase").orElse("");
        this.session.setNewParam("gpg.executable", gpgPath);
        activation.setActiveByDefault(true);
        profile.setId("gpg");
        profile.setActivation(activation);
        properties.setProperty("gpg.executable", gpgPath);
        properties.setProperty("gpg.passphrase", passPhrase);
        profile.setProperties(properties);
        if (this.session.getMavenSession().getSettings().getProfiles().stream().noneMatch(p -> p.getId().equals(profile.getId()))) {
            this.log.info("%s Created profile id [%s] passphrase [%s] path [%s]", PluginSession.unicode(128209), profile.getId(), passPhrase, gpgPath);
            this.session.getMavenSession().getSettings().getProfiles().add(profile);
        } else {
            this.log.debug("%s Profile id [%s] already exists", PluginSession.unicode(9888), profile.getId());
        }
    }

    public static String getGpgPath(Logger log) {
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = log::info;
        Terminal t = new Terminal().consumerError(consumerArray).timeoutMs(5000L).breakOnError(false);
        if (!SystemUtil.isWindows()) {
            String result = t.execute("if which gpg2 >/dev/null 2>&1; then which gpg2; elif which gpg >/dev/null 2>&1; then which gpg; else echo \"gpg\"; fi").consoleInfo();
            return result;
        }
        String result = t.execute("where gpg").consoleInfo();
        return MojoUtil.isPresent(result) ? result : "gpg";
    }
}

