/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.config;

import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.mavendeploy.config.MojoBase;
import berlin.yuna.mavendeploy.config.Versions;
import berlin.yuna.mavendeploy.model.Logger;
import berlin.yuna.mavendeploy.model.Parameter;
import berlin.yuna.mavendeploy.plugin.PluginSession;
import berlin.yuna.mavendeploy.util.MojoUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class PluginUpdater
extends MojoBase {
    public PluginUpdater(PluginSession session) {
        super("berlin.yuna", "plugin-updater", "0.0.1", session);
    }

    public static PluginUpdater build(PluginSession session) {
        return new PluginUpdater(session);
    }

    public PluginUpdater update() throws IOException, XmlPullParserException {
        String goal = "update";
        this.logGoal("update", true);
        MavenProject project = this.session.getEnvironment().getMavenProject();
        List<Plugin> plugins = project.getBuildPlugins();
        Path tmpProjectPath = Files.createTempDirectory("plugin-updater_", new FileAttribute[0]);
        Path tmpPomFile = Paths.get(tmpProjectPath.toString(), "pom.xml");
        PluginUpdater.createPomFile(tmpPomFile, plugins, this.session);
        for (String versionsGoal : new String[]{"use-latest-releases", "use-latest-versions", "use-next-snapshots"}) {
            this.getTerminal(tmpPomFile).execute(this.mvnUpdate(versionsGoal));
        }
        this.updatePomFile(PluginUpdater.reportPluginUpdates(this.log, plugins, tmpPomFile.toFile()));
        this.logGoal("update", false);
        MojoUtil.deletePath(tmpProjectPath);
        return this;
    }

    private void updatePomFile(HashMap<Plugin, String> pluginUpdates) throws IOException {
        File pomFile = Optional.ofNullable(this.session.getProject().getFile()).orElse(new File(this.session.getParamPresent(Parameter.BASE_DIR).orElse(""), "pom.xml"));
        if (pomFile.exists()) {
            String pomXml = Files.readString(pomFile.toPath());
            for (Map.Entry<Plugin, String> entry : pluginUpdates.entrySet()) {
                Plugin plugin = entry.getKey();
                String pluginRegex = "(?<prefix>.*" + plugin.getArtifactId() + "(.|\\R)*?<version>)(?<version>" + plugin.getVersion() + ")(?<suffix><.*)";
                pomXml = pomXml.replaceAll(pluginRegex, "${prefix}" + entry.getValue() + "${suffix}");
            }
            Files.write(pomFile.toPath(), pomXml.getBytes(), new OpenOption[0]);
            this.log.info("%s Updated pom file [file://%s]", PluginSession.unicode(128278), pomFile.toURI().getRawPath());
        } else {
            this.log.error("Can't find pom file to update please provide at least [%s] property", Parameter.BASE_DIR.key());
        }
    }

    private Terminal getTerminal(Path pomFile) {
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.log::error;
        return new Terminal().dir(pomFile.getParent()).consumerError(consumerArray);
    }

    private String mvnUpdate(String goal) {
        Versions versions = Versions.build(this.session);
        return String.format("mvn %s:%s:%s:%s -DallowMajorUpdates=%s -DallowSnapshots=%s", versions.groupId(), versions.artifactId(), versions.version(), goal, this.session.getBoolean("update.major").orElse(false).toString(), this.session.getBoolean("allowSnapshots").orElse(true).toString());
    }

    static HashMap<Plugin, String> reportPluginUpdates(Logger log, List<Plugin> mojoList, File pomFile) throws IOException, XmlPullParserException {
        HashMap<Plugin, String> newVersionAvailable = new HashMap<Plugin, String>();
        Model pomXml = new MavenXpp3Reader().read(new FileReader(pomFile));
        pomXml.getDependencies().forEach(dependency -> {
            for (Plugin plugin : mojoList) {
                if (!dependency.getGroupId().equalsIgnoreCase(plugin.getGroupId()) || !dependency.getArtifactId().equalsIgnoreCase(plugin.getArtifactId()) || dependency.getVersion().equalsIgnoreCase(plugin.getVersion())) continue;
                newVersionAvailable.put(plugin, dependency.getVersion());
                log.info("%s Update plugin [%s] [%s] -> [%s]", PluginSession.unicode(128200), plugin.getArtifactId(), plugin.getVersion(), dependency.getVersion());
            }
        });
        return newVersionAvailable;
    }

    static void createPomFile(Path pomFile, List<Plugin> mojoList, PluginSession session) {
        PluginUpdater updater = PluginUpdater.build(session);
        Element project = new Element("project");
        project.addContent(new Element("modelVersion").addContent("4.0.0"));
        project.addContent(new Element("groupId").addContent(updater.groupId()));
        project.addContent(new Element("artifactId").addContent(updater.artifactId()));
        project.addContent(new Element("version").addContent(updater.version()));
        project.addContent(new Element("packaging").addContent("pom"));
        project.addContent(PluginUpdater.preparePlugins(mojoList, session.getLog()));
        PluginUpdater.overwriteTestPom(project, pomFile);
    }

    private static Element preparePlugins(List<Plugin> mojoList, Logger log) {
        Element plugins = new Element("dependencies");
        mojoList.forEach(mojoBase -> {
            Element plugin = new Element("dependency");
            plugin.addContent(new Element("groupId").addContent(mojoBase.getGroupId()));
            plugin.addContent(new Element("artifactId").addContent(mojoBase.getArtifactId()));
            plugin.addContent(new Element("version").addContent(mojoBase.getVersion()));
            plugins.addContent(plugin);
            log.debug("Prepare plugin [%s]", mojoBase.getArtifactId());
        });
        return plugins;
    }

    private static void overwriteTestPom(Element project, Path pomFile) {
        try {
            Files.write(pomFile, PluginUpdater.xmlToBytes(project), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] xmlToBytes(Element project) {
        return ("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n" + new XMLOutputter().outputString(project).replace("<project>", "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">")).getBytes();
    }
}

