/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.config;

import berlin.yuna.mavendeploy.config.MojoBase;
import berlin.yuna.mavendeploy.plugin.PluginSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ReadmeBuilder
extends MojoBase {
    private static final String NAME_PLACEHOLDER = "PLACEHOLDER";
    private static final String NAME_VARIABLE = "VARIABLE";
    private static final String NAME_INCLUDE = "INCLUDE";
    private static final String NAME_TEXT = "TEXT";
    private static final String NAME_ESCAPE = "ESCAPED";
    private static final String BUILDER_FILE_PATTERN = "(?<name>.*)(?<value>\\.builder\\.)(?<type>\\w*)(?<end>\\#+)";
    private static final Pattern BUILDER_VAR_PATTERN = Pattern.compile("\\[(?<type>var)\\s+(?<name>.*)\\]\\:\\s+\\#\\s+\\((?<value>.*)\\)");
    private static final Pattern BUILDER_INCLUDE_PATTERN = Pattern.compile("(?<name>.*)\\[(?<type>include)\\]\\:\\s+\\#\\s+\\((?<value>.*)\\)");
    private static final Pattern BUILDER_PLACEHOLDER_PATTERN = Pattern.compile("\\!\\{(?<name>.*)\\}");

    public ReadmeBuilder(PluginSession session) {
        super("berlin.yuna", "readme-buider", "0.0.1", session);
    }

    public static ReadmeBuilder build(PluginSession session) {
        return new ReadmeBuilder(session);
    }

    public ReadmeBuilder render() throws IOException {
        String goal = "render";
        this.logGoal("render", true);
        Path start = this.session.getEnvironment().getMavenProject().getBasedir().toPath();
        Files.walk(start, 99, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(file -> (file.getFileName().toString() + "#end").split(BUILDER_FILE_PATTERN).length > 1).forEach(this::render);
        this.logGoal("render", false);
        return this;
    }

    private void render(Path builderPath) {
        this.render(builderPath, true);
    }

    private String render(Path builderPath, boolean writeFile) {
        try {
            this.log.debug("Rendering [%s]", builderPath.getFileName());
            List<Content> content = new ArrayList<Content>();
            content.add(new Content(NAME_TEXT, Files.readString(builderPath)));
            content = this.splitContentAt(content, Pattern.compile("\\\\" + BUILDER_VAR_PATTERN), NAME_ESCAPE);
            content = this.splitContentAt(content, Pattern.compile("\\\\" + BUILDER_PLACEHOLDER_PATTERN), NAME_ESCAPE);
            content = this.splitContentAt(content, Pattern.compile("\\\\" + BUILDER_INCLUDE_PATTERN), NAME_ESCAPE);
            content = this.splitContentAt(content, BUILDER_VAR_PATTERN, NAME_VARIABLE);
            content = this.splitContentAt(content, BUILDER_INCLUDE_PATTERN, NAME_INCLUDE);
            content = this.splitContentAt(content, BUILDER_PLACEHOLDER_PATTERN, NAME_PLACEHOLDER);
            HashMap<String, String> variables = this.readVariables(content);
            content = this.resolvePlaceholders(content, variables);
            content = this.resolveIncludes(content, variables, builderPath);
            content = this.removeVariablesAndEscapes(content);
            String result = content.stream().map(c -> c.value).collect(Collectors.joining("")).trim();
            if (writeFile) {
                this.writeFile(builderPath, result, variables.get("target"));
            }
            return result;
        }
        catch (IOException e) {
            this.log.error("%s %s", PluginSession.unicode(129344), e);
            return "";
        }
    }

    private HashMap<String, String> readVariables(List<Content> content) {
        HashMap<String, String> variables = new HashMap<String, String>();
        this.session.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> variables.put(String.valueOf(k), String.valueOf(v))));
        variables.putAll(this.readVariables(content, variables));
        return variables;
    }

    private Map<String, String> readVariables(List<Content> content, HashMap<String, String> variables) {
        HashMap<String, String> result = new HashMap<String, String>(variables);
        content.stream().filter(c -> NAME_VARIABLE.equals(c.key)).forEach(c -> {
            Content variable = this.readVariable((Content)c, BUILDER_VAR_PATTERN);
            result.put(variable.key, this.resolvePlaceholders(Collections.singletonList(variable), (HashMap<String, String>)result).get((int)0).value);
        });
        return result;
    }

    private Content readVariable(Content content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content.value);
        if (matcher.find()) {
            return new Content(matcher.group("name"), matcher.group("value"));
        }
        throw new RuntimeException(String.format("No variable found in [%s]", content.value));
    }

    private List<Content> resolvePlaceholders(List<Content> content, HashMap<String, String> variables) {
        ArrayList<Content> result = new ArrayList<Content>(content);
        result.stream().filter(o -> !NAME_ESCAPE.equals(o.key)).forEach(placeholder -> {
            for (Map.Entry var : variables.entrySet()) {
                placeholder.value = placeholder.value.replace("!{" + (String)var.getKey() + "}", (CharSequence)var.getValue());
            }
        });
        return result;
    }

    private List<Content> resolveIncludes(List<Content> content, HashMap<String, String> variables, Path builderPath) {
        ArrayList<Content> result = new ArrayList<Content>(content);
        result.stream().filter(o -> NAME_INCLUDE.equals(o.key)).forEach(variable -> {
            Content include = this.readVariable((Content)variable, BUILDER_INCLUDE_PATTERN);
            File file = include.value.startsWith("/") ? new File(this.session.getEnvironment().getMavenProject().getBasedir(), include.value.substring(1)) : new File(builderPath.getParent().toFile(), include.value);
            variable.value = include.key + this.render(file.toPath(), false);
            variable.key = NAME_TEXT;
        });
        return result;
    }

    private List<Content> removeVariablesAndEscapes(List<Content> content) {
        ArrayList<Content> result = new ArrayList<Content>(content);
        content.stream().filter(c -> NAME_VARIABLE.equals(c.key)).forEach(result::remove);
        content.stream().filter(c -> NAME_INCLUDE.equals(c.key)).forEach(result::remove);
        content.stream().filter(c -> NAME_ESCAPE.equals(c.key)).forEach(c -> {
            c.value = c.value.substring(1);
        });
        return result;
    }

    private List<Content> splitContentAt(List<Content> content, Pattern pattern, String name) {
        ArrayList<Content> result = new ArrayList<Content>();
        for (Content part : content) {
            if (part.key.equals(NAME_TEXT) && !part.value.isEmpty()) {
                String value = part.value;
                Matcher matcher = pattern.matcher(value);
                int endMatch = 0;
                while (matcher.find()) {
                    result.add(new Content(part.key, value.substring(endMatch, matcher.start())));
                    endMatch = matcher.end();
                    result.add(new Content(name, value.substring(matcher.start(), endMatch)));
                }
                result.add(new Content(part.key, value.substring(endMatch)));
                continue;
            }
            if (part.value.isEmpty()) continue;
            result.add(part);
        }
        return result;
    }

    private void writeFile(Path builderPath, String content, String optionalPath) throws IOException {
        Path outputPath = this.getOutputPath(builderPath, optionalPath);
        Files.write(outputPath, content.getBytes(), new OpenOption[0]);
        this.log.info("%s Generated [%s]", PluginSession.unicode(128209), outputPath);
    }

    private Path getOutputPath(Path builderPath, String optionalPath) throws IOException {
        File outputBase;
        Path basePath = builderPath.getParent();
        File file = optionalPath == null ? basePath.toFile() : (outputBase = new File(optionalPath.startsWith("/") ? this.session.getEnvironment().getMavenProject().getBasedir() : basePath.toFile(), optionalPath));
        if (!outputBase.exists()) {
            Files.createDirectories(outputBase.toPath(), new FileAttribute[0]);
        }
        String fileName = (builderPath.getFileName().toString() + "#").replaceAll(BUILDER_FILE_PATTERN, "${name}.${type}");
        return new File(outputBase, fileName).toPath();
    }

    static class Content {
        String key;
        String value;

        Content(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Content content = (Content)o;
            if (!Objects.equals(this.key, content.key)) {
                return false;
            }
            return Objects.equals(this.value, content.value);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return String.format("[%S] [%s]", this.key, this.value);
        }
    }
}

