/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.logic;

import berlin.yuna.mavendeploy.logic.GitService;
import berlin.yuna.mavendeploy.model.Logger;
import berlin.yuna.mavendeploy.plugin.PluginSession;
import berlin.yuna.mavendeploy.util.MojoUtil;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemanticService {
    private final String[] semanticFormat;
    private final GitService gitService;
    private String branchNameRefLog;
    private final Logger log;

    public Optional<String> getBranchNameRefLog() {
        if (MojoUtil.isEmpty(this.branchNameRefLog) && this.gitService != null) {
            this.branchNameRefLog = this.gitService.getBranchNameRefLog().orElse(null);
            this.log.debug("Original branch name [%s]", this.branchNameRefLog);
        }
        return Optional.ofNullable(this.branchNameRefLog);
    }

    public SemanticService(PluginSession session, GitService gitService, String semanticFormat) {
        this.semanticFormat = (MojoUtil.isEmpty(semanticFormat) ? "\\.:none" : semanticFormat).split("::");
        this.gitService = gitService;
        this.log = session.getLog();
    }

    public String getNextSemanticVersion(String currentVersion, String fallback) {
        Optional<String> branchName = this.getBranchNameRefLog();
        int semanticPosition = this.getSemanticPosition(branchName.orElse(null));
        if (branchName.isPresent() && semanticPosition != -1) {
            return this.getNextSemanticVersion(currentVersion, semanticPosition);
        }
        return fallback;
    }

    private String getNextSemanticVersion(String versionOrg, int semanticPosition) {
        String separator = this.getSemanticSeparator(versionOrg);
        StringBuilder nextVersion = new StringBuilder();
        for (String digit : this.prepareNextSemanticVersion(versionOrg, semanticPosition)) {
            nextVersion.append(digit).append(separator);
        }
        return nextVersion.delete(nextVersion.length() - 1, nextVersion.length()).toString();
    }

    private String getSemanticSeparator(String versionOrg) {
        Matcher matcher = Pattern.compile(this.semanticFormat[0]).matcher(versionOrg);
        return matcher.find() ? matcher.group(0) : ".";
    }

    private String[] prepareNextSemanticVersion(String versionOrg, int semanticPos) {
        String[] version = versionOrg.split(this.semanticFormat[0]);
        version[semanticPos] = this.increaseNumbersInString(version[semanticPos], true);
        for (int i = semanticPos + 1; i < version.length; ++i) {
            version[i] = this.increaseNumbersInString(version[i], false);
        }
        return version;
    }

    String increaseNumbersInString(String versionPart, boolean increase) {
        List<String> parts = MojoUtil.splitAtDigits(versionPart);
        for (int i = 0; i < parts.size(); ++i) {
            if (!MojoUtil.isNumeric(parts.get(i))) continue;
            parts.set(i, increase ? String.valueOf(Integer.parseInt(parts.get(i)) + 1) : "0");
        }
        return String.join((CharSequence)"", parts);
    }

    private int getSemanticPosition(String branchName) {
        for (int i = 1; i < this.semanticFormat.length; ++i) {
            if (Pattern.compile(this.semanticFormat[i]).matcher(branchName).find()) {
                this.log.debug("Its a match! branch name [%s] semantic format [%s]", branchName, this.semanticFormat[i]);
                return i - 1;
            }
            this.log.debug("branch name [%s] did not match semantic format [%s]", branchName, this.semanticFormat[i]);
        }
        return -1;
    }
}

