/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.model;

import berlin.yuna.mavendeploy.plugin.PluginSession;
import berlin.yuna.mavendeploy.util.MojoUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.maven.plugin.logging.Log;

public class Logger
implements Log {
    private Consumer<String> consumer;
    private final DateTimeFormatter formatter;
    private final HashMap<LogLevel, String> logTypes = new HashMap();
    private LogLevel logLevel;
    private LocalDateTime lastLog = LocalDateTime.now();
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_BLACK = "\u001b[30m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private static final String ANSI_PURPLE = "\u001b[35m";
    private static final String ANSI_CYAN = "\u001b[36m";
    private static final String ANSI_WHITE = "\u001b[37m";

    public Logger() {
        this(null);
    }

    public Logger(String timeFormat) {
        this.logTypes.put(LogLevel.DEBUG, "[\u001b[36mDEBUG\u001b[0m]    ");
        this.logTypes.put(LogLevel.INFO, "[\u001b[34mINFO\u001b[0m]     ");
        this.logTypes.put(LogLevel.WARN, "[\u001b[33mWARNING\u001b[0m]  ");
        this.logTypes.put(LogLevel.ERROR, "[\u001b[31mERROR\u001b[0m]    ");
        this.logTypes.put(LogLevel.FATAL, "[\u001b[35mFATAL\u001b[0m]    ");
        this.logTypes.put(LogLevel.DISABLED, "[\u001b[32mDISABLED\u001b[0m] ");
        this.formatter = DateTimeFormatter.ofPattern(timeFormat == null ? "yyyy-MM-dd HH:mm:ss" : timeFormat);
        this.setLogLevel(MojoUtil.isPresent(System.getenv("DEBUG")) && Boolean.parseBoolean(System.getenv("DEBUG")) ? LogLevel.DEBUG : LogLevel.INFO);
    }

    public void debug(Object ... format) {
        this.print(LogLevel.DEBUG, -1, null, format);
    }

    public void info(Object ... format) {
        this.print(LogLevel.INFO, -1, null, format);
    }

    public void warn(Object ... format) {
        this.print(LogLevel.WARN, 9888, null, format);
    }

    public void error(Object ... format) {
        this.print(LogLevel.ERROR, 129344, null, format);
    }

    public void fatal(Object ... format) {
        this.print(LogLevel.FATAL, 129344, null, format);
    }

    private void print(LogLevel logLevel, int icon, Throwable throwable, Object ... format) {
        if (this.logLevel.ordinal() <= logLevel.ordinal() && logLevel.ordinal() < LogLevel.DISABLED.ordinal()) {
            String result = this.logTypes.get((Object)logLevel) + " [\u001b[33m" + LocalDateTime.now().format(this.formatter) + "\u001b[0m]" + (String)(this.logLevel.ordinal() <= LogLevel.DEBUG.ordinal() ? " [\u001b[35m" + this.lastLog.until(LocalDateTime.now(), ChronoUnit.SECONDS) + "s\u001b[0m]" : "") + (String)(icon != -1 ? " " + PluginSession.unicode(icon) : "") + " " + this.formatMsg(format) + " " + this.toString(throwable);
            this.print(logLevel, result);
        }
        this.lastLog = LocalDateTime.now();
    }

    private synchronized void print(LogLevel logLevel, String result) {
        if (this.consumer != null) {
            this.consumer.accept(result);
        } else if (logLevel == LogLevel.ERROR || logLevel == LogLevel.FATAL) {
            System.err.println(result);
        } else {
            System.out.println(result);
        }
    }

    private String formatMsg(Object[] format) {
        String msg = format.length > 1 ? String.format(String.valueOf(format[0]), Arrays.copyOfRange(format, 1, format.length)) : String.valueOf(format[0]);
        return PluginSession.hideSecrets(msg);
    }

    @Override
    public void debug(CharSequence content) {
        this.print(LogLevel.DEBUG, -1, null, content);
    }

    @Override
    public void debug(CharSequence content, Throwable error) {
        this.print(LogLevel.DEBUG, -1, error, content);
    }

    @Override
    public void debug(Throwable error) {
        this.print(LogLevel.DEBUG, -1, error, "");
    }

    @Override
    public void info(CharSequence content) {
        this.print(LogLevel.INFO, -1, null, content);
    }

    @Override
    public void info(CharSequence content, Throwable error) {
        this.print(LogLevel.INFO, -1, error, content);
    }

    @Override
    public void info(Throwable error) {
        this.print(LogLevel.INFO, -1, error, "");
    }

    @Override
    public void warn(CharSequence content) {
        this.print(LogLevel.WARN, 9888, null, content);
    }

    @Override
    public void warn(CharSequence content, Throwable error) {
        this.print(LogLevel.WARN, 9888, error, content);
    }

    @Override
    public void warn(Throwable error) {
        this.print(LogLevel.WARN, 9888, error, "");
    }

    @Override
    public void error(CharSequence content) {
        this.print(LogLevel.ERROR, 129344, null, content);
    }

    @Override
    public void error(CharSequence content, Throwable error) {
        this.print(LogLevel.ERROR, 129344, error, content);
    }

    @Override
    public void error(Throwable error) {
        this.print(LogLevel.ERROR, 129344, error, "");
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logLevel.ordinal() <= LogLevel.DEBUG.ordinal();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logLevel.ordinal() <= LogLevel.INFO.ordinal();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logLevel.ordinal() <= LogLevel.WARN.ordinal();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logLevel.ordinal() <= LogLevel.ERROR.ordinal();
    }

    public Logger setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public void setConsumer(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    private String toString(Throwable error) {
        if (error != null) {
            StringWriter sWriter = new StringWriter();
            error.printStackTrace(new PrintWriter(sWriter));
            return System.lineSeparator() + sWriter.toString();
        }
        return "";
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL,
        DISABLED;

    }
}

