/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.plugin;

import berlin.yuna.mavendeploy.config.Clean;
import berlin.yuna.mavendeploy.config.Compiler;
import berlin.yuna.mavendeploy.config.Dependency;
import berlin.yuna.mavendeploy.config.Deploy;
import berlin.yuna.mavendeploy.config.Gpg;
import berlin.yuna.mavendeploy.config.Jar;
import berlin.yuna.mavendeploy.config.JavaSource;
import berlin.yuna.mavendeploy.config.Javadoc;
import berlin.yuna.mavendeploy.config.PluginUpdater;
import berlin.yuna.mavendeploy.config.PropertyWriter;
import berlin.yuna.mavendeploy.config.ReadmeBuilder;
import berlin.yuna.mavendeploy.config.Scm;
import berlin.yuna.mavendeploy.config.Surefire;
import berlin.yuna.mavendeploy.config.Versions;
import berlin.yuna.mavendeploy.logic.AdditionalPropertyReader;
import berlin.yuna.mavendeploy.logic.GitService;
import berlin.yuna.mavendeploy.logic.SemanticService;
import berlin.yuna.mavendeploy.model.Logger;
import berlin.yuna.mavendeploy.model.Parameter;
import berlin.yuna.mavendeploy.model.ThrowingFunction;
import berlin.yuna.mavendeploy.plugin.PluginExecutor;
import berlin.yuna.mavendeploy.plugin.PluginSession;
import berlin.yuna.mavendeploy.util.MojoUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;

@Mojo(name="run", threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class Application
extends AbstractMojo {
    private static final String JAVA_VERSION = "12";
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.basedir}")
    private File basedir;
    @Component
    private BuildPluginManager pluginManager;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${session}")
    private MavenSession maven;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}")
    private MavenProject project;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${mojoExecution}")
    private MojoExecution plugin;
    private Logger LOG = new Logger("HH:mm:ss");
    private GitService GIT_SERVICE;
    private SemanticService SEMANTIC_SERVICE;
    private PluginExecutor.ExecutionEnvironment ENVIRONMENT;
    private PluginSession SESSION;

    @Override
    public void execute() {
        this.before();
        this.LOG.info("%s Preparing information [%s:%s]", PluginSession.unicode(128083), this.plugin.getArtifactId(), this.plugin.getVersion());
        this.SESSION.setNewParam(Parameter.TEST_SKIP.maven(), this.SESSION.getBoolean(Parameter.TEST_SKIP.key()).orElse(false).toString());
        String newProjectVersion = this.prepareProjectVersion();
        try {
            boolean isLibrary = this.isLibrary();
            String newTag = this.prepareNewTagVersion(newProjectVersion);
            boolean hasNewTag = this.hasNewTag(newTag, this.GIT_SERVICE.getLastGitTag());
            this.LOG.info("%s STEP [1/6] SETUP MOJO PROPERTIES", PluginSession.unicode(128221));
            this.setWhen(Parameter.PROJECT_LIBRARY, String.valueOf(isLibrary), new boolean[0]);
            this.setWhen(Parameter.NEW_VERSION.maven(), newProjectVersion, !MojoUtil.isEmpty(newProjectVersion) && !newProjectVersion.equalsIgnoreCase(this.project.getVersion()));
            this.setWhen(Parameter.REMOVE_SNAPSHOT.maven(), "true", this.isTrue(Parameter.REMOVE_SNAPSHOT.key()));
            this.setWhen(Parameter.POM_BACKUP.maven(), "false", new boolean[0]);
            this.setWhen(Parameter.TEST_INTEGRATION, (String)this.SESSION.getParamPresent(Parameter.TEST_INT.key()).orElse(null), new boolean[0]);
            this.setWhen(JAVA_VERSION, JAVA_VERSION, !this.hasText(JAVA_VERSION));
            Optional<String> javaVersion = this.SESSION.getParamPresent(JAVA_VERSION);
            this.setWhen(Parameter.SOURCE.maven(), this.prepareSourceVersion(javaVersion.orElse(null)), new boolean[0]);
            this.setWhen(Parameter.TARGET.maven(), this.prepareSourceVersion(javaVersion.orElse(null)), new boolean[0]);
            this.setWhen("compilerVersion", (String)javaVersion.orElse(null), new boolean[0]);
            this.setWhen("javadocVersion", (String)javaVersion.orElse(null), new boolean[0]);
            this.setWhen("project.encoding", StandardCharsets.UTF_8.toString(), this.SESSION.getParamPresent("project.encoding").isEmpty());
            this.setWhen("encoding", (String)this.SESSION.getParamPresent("project.encoding").orElse(null), new boolean[0]);
            this.setWhen("project.build.sourceEncoding", (String)this.SESSION.getParamPresent("project.encoding").orElse(null), new boolean[0]);
            this.setWhen("project.reporting.outputEncoding", (String)this.SESSION.getParamPresent("project.encoding").orElse(null), new boolean[0]);
            this.setWhen("allowSnapshots", "true", this.isTrue("update.minor", "update.major"));
            this.setWhen("allowMajorUpdates", this.SESSION.getBoolean("update.major").orElse(false).toString(), new boolean[0]);
            this.setWhen("scm.provider", "scm:git", !this.hasText("scm.provider"));
            this.setWhen("connectionUrl", this.getConnectionUrl(), !this.hasText("connectionUrl"));
            this.setWhen("project.scm.connection", this.getConnectionUrl(), !this.hasText("project.scm.connection"));
            this.SESSION.setParameter("tag", newTag, !MojoUtil.isEmpty(newTag));
            this.setWhen("gpg.passphrase", (String)this.SESSION.getParamPresent("gpg.pass", "gpg.passphrase").orElse(null), new boolean[0]);
            this.setWhen("passphraseServerId", (String)this.SESSION.getParamPresent("gpg.passphrase").orElse(null), new boolean[0]);
            this.LOG.info("%s STEP [2/6] RUN PLUGINS WITH SETUP", PluginSession.unicode(9881));
            this.runWhen(() -> Clean.build(this.SESSION).clean(), this.isTrue("clean", "clean.cache"));
            this.runWhen(() -> Dependency.build(this.SESSION).resolvePlugins(), this.isTrue("clean", "clean.cache"));
            this.runWhen(() -> Dependency.build(this.SESSION).purgeLocalRepository(), this.isTrue("clean.cache"));
            this.LOG.info("%s STEP [3/6] RUN PLUGINS WITH MODIFIERS", PluginSession.unicode(127959));
            this.runWhen(() -> ReadmeBuilder.build(this.SESSION).render(), this.isTrue("builder"));
            this.runWhen(() -> Versions.build(this.SESSION).updateParent(), this.isTrue("update.major", "update.minor"));
            this.runWhen(() -> Versions.build(this.SESSION).updateProperties(), this.isTrue("update.major", "update.minor"));
            this.runWhen(() -> Versions.build(this.SESSION).updateProperties(), this.isTrue("update.major", "update.minor"));
            this.runWhen(() -> Versions.build(this.SESSION).updateChildModules(), this.isTrue("update.major", "update.minor"));
            this.runWhen(() -> Versions.build(this.SESSION).useLatestReleases(), this.isTrue("update.major", "update.minor"));
            this.runWhen(() -> Versions.build(this.SESSION).useLatestVersions(), this.isTrue("update.major", "update.minor"));
            this.runWhen(() -> Versions.build(this.SESSION).useNextSnapshots(), this.isTrue("update.major", "update.minor"));
            this.runWhen(() -> PluginUpdater.build(this.SESSION).update(), this.SESSION.getBoolean("update.plugins").orElse(false));
            this.runWhen(() -> Versions.build(this.SESSION).commit(), this.isTrue("update.major", "update.minor"));
            this.runWhen(() -> Versions.build(this.SESSION).set(), this.hasText(Parameter.NEW_VERSION.maven()), this.isTrue("removeSnapshot"));
            this.LOG.info("%s STEP [4/6] RUN PLUGINS WITH VERIFIERS", PluginSession.unicode(128270));
            this.runWhen(() -> Compiler.build(this.SESSION).compiler(), this.isTrue("test.run", "test.unit", Parameter.TEST_INTEGRATION.key()));
            this.runWhen(() -> Compiler.build(this.SESSION).testCompiler(), this.isTrue("test.run", "test.unit", Parameter.TEST_INTEGRATION.key()));
            this.runWhen(() -> Surefire.build(this.SESSION).test(), this.isTrue("test.run", "test.unit"));
            this.LOG.info("%s STEP [5/6] RUN PLUGINS WITH ACTIONS", PluginSession.unicode(127916));
            this.runWhen(() -> Javadoc.build(this.SESSION).jar(), !this.isLibrary() && this.isTrue("java.doc", "java.doc.break"));
            this.runWhen(() -> JavaSource.build(this.SESSION).jarNoFork(), !this.isLibrary() && this.isTrue("java.source"));
            this.runWhen(() -> Jar.build(this.SESSION).jar(), this.hasText("package", "gpg.passphrase") || this.isTrue("deploy", "deploy.snapshot"));
            this.runWhen(() -> Gpg.build(this.SESSION).sign(), this.hasText("gpg.passphrase"));
            this.runWhen(() -> Deploy.build(this.SESSION).deploy(), this.isTrue("deploy", "deploy.snapshot"));
            this.runWhen(() -> Scm.build(this.SESSION).tag(), hasNewTag);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.cleanUps(newProjectVersion);
        }
    }

    private void cleanUps(String newProjectVersion) {
        this.LOG.info("%s STEP [6/6] RUN PLUGINS WITH CLEANUPS", PluginSession.unicode(129511));
        boolean removeSnapshot = this.SESSION.getBoolean("snapshot.deployment").orElse(false);
        if (removeSnapshot) {
            this.SESSION.setParameter("oldVersion", newProjectVersion, true);
            this.SESSION.setParameter(Parameter.NEW_VERSION.maven(), newProjectVersion.split("-SNAPSHOT")[0], true);
        }
        try {
            this.runWhen(() -> Versions.build(this.SESSION).set(), removeSnapshot);
            this.runWhen(() -> PropertyWriter.build(this.SESSION).write(), this.isTrue("properties.print") || this.hasText("properties.print"));
        }
        catch (Exception e) {
            this.LOG.error(e);
        }
        this.printJavaDoc();
    }

    private String prepareSourceVersion(String javaVersion) {
        if (MojoUtil.isPresent(javaVersion)) {
            int index = javaVersion.indexOf(46);
            switch (index) {
                case -1: {
                    return javaVersion;
                }
                case 1: {
                    return javaVersion.substring(index + 1);
                }
            }
            return javaVersion.substring(0, index);
        }
        return null;
    }

    private String getTagVersion(String property, String newProjectVersion) {
        if (this.isTrue(property)) {
            return newProjectVersion;
        }
        Optional<String> param = this.SESSION.getParamPresent(property);
        if (param.isPresent() && !param.get().equalsIgnoreCase("false")) {
            return param.get();
        }
        return null;
    }

    private String prepareNewTagVersion(String newProjectVersion) {
        String tag = this.getTagVersion("tag", newProjectVersion);
        String tagBreak = this.getTagVersion("tag.break", newProjectVersion);
        return MojoUtil.isEmpty(tag) ? tagBreak : tag;
    }

    private String getConnectionUrl() {
        String scmProvider = this.SESSION.getParamPresent("scm.provider").orElse("scm:git");
        String connectionUrl = this.GIT_SERVICE.getOriginUrl().orElseGet(() -> this.basedir.toURI().toString());
        return connectionUrl.startsWith(scmProvider) ? connectionUrl : scmProvider + ":" + connectionUrl;
    }

    private String prepareCommitMessage(String projectVersion, boolean hasNewTag, boolean update) {
        return String.format("[%s]", projectVersion) + String.format(" [%s]", this.getBranchName()) + (hasNewTag ? " [TAG]" : "") + (update ? " [UPDATE]" : "");
    }

    private Optional<String> getBranchName() {
        return this.SEMANTIC_SERVICE.getBranchNameRefLog();
    }

    private boolean hasNewTag(String newTag, String lastGitTag) {
        if (!MojoUtil.isEmpty(newTag)) {
            this.LOG.debug("Tagging requested [%s], last tag was [%s]", newTag, lastGitTag);
            this.printTagMessage(this.isTrue("tag.break"), newTag, lastGitTag);
            return !MojoUtil.isEmpty(newTag) && !newTag.equalsIgnoreCase(lastGitTag);
        }
        return false;
    }

    private void printTagMessage(boolean tagBreak, String newProjectVersion, String lastGitTag) {
        if (tagBreak && newProjectVersion.equalsIgnoreCase(lastGitTag)) {
            throw new RuntimeException(String.format("Git tag [%s] already exists", newProjectVersion));
        }
        if (newProjectVersion.equalsIgnoreCase(lastGitTag)) {
            this.LOG.info("%s Git tag [%s] already exists", PluginSession.unicode(127991), newProjectVersion);
        } else {
            this.LOG.info("%s New git tag [%s]", PluginSession.unicode(127991), newProjectVersion);
        }
    }

    private void printJavaDoc() {
        File javaDocFile = new File(this.basedir, "target/apidocs/index.html");
        if (javaDocFile.exists()) {
            this.LOG.info("%s JavaDoc [file://%s]", PluginSession.unicode(128278), javaDocFile.toURI().getRawPath());
        }
    }

    private String prepareProjectVersion() {
        String snapshotVersion;
        String projectVersion = this.SESSION.getParamPresent("project.version").orElse(null);
        Optional<String> semanticFormat = this.SESSION.getParamPresent("semantic.format");
        this.LOG.debug("Versioning [project.version] " + (String)(MojoUtil.isEmpty(projectVersion) ? "not given" : "[" + projectVersion + "]"));
        this.LOG.debug("Versioning [semantic.format] " + (String)(semanticFormat.isEmpty() ? "not given" : "[" + semanticFormat.get() + "]"));
        String result = semanticFormat.isEmpty() ? projectVersion : this.SEMANTIC_SERVICE.getNextSemanticVersion(this.project.getVersion(), projectVersion);
        this.LOG.debug("Versioning [result.version] " + (String)(MojoUtil.isEmpty(result) ? "not found" : "[" + result + "]"));
        this.LOG.debug("Prepared project version [%s]", projectVersion);
        this.setWhen("branch.name.ref", (String)this.SEMANTIC_SERVICE.getBranchNameRefLog().orElse(null), new boolean[0]);
        this.setWhen("branch.name", (String)this.GIT_SERVICE.getBranchName().orElse(null), new boolean[0]);
        String string = snapshotVersion = MojoUtil.isEmpty(result) ? this.project.getVersion() : result;
        if ((this.isTrue("project.snapshot") || this.isTrue("deploy.snapshot")) && !snapshotVersion.endsWith("-SNAPSHOT")) {
            this.setWhen("snapshot.deployment", "true", new boolean[0]);
            return snapshotVersion + "-SNAPSHOT";
        }
        return result;
    }

    private void before() {
        boolean debugEnabled = this.getLog().isDebugEnabled();
        Objects.requireNonNull(this.pluginManager);
        this.ENVIRONMENT = PluginExecutor.executionEnvironment(this.project, this.maven, this.pluginManager);
        this.SESSION = new PluginSession(this.ENVIRONMENT);
        this.LOG = this.SESSION.getLog();
        this.LOG.setLogLevel(debugEnabled ? Logger.LogLevel.DEBUG : Logger.LogLevel.INFO);
        this.setLog(this.LOG);
        PluginExecutor.setLogger(this.LOG);
        this.GIT_SERVICE = new GitService(this.LOG, this.basedir, this.SESSION.getBoolean("fake").orElse(false));
        this.SEMANTIC_SERVICE = new SemanticService(this.SESSION, this.GIT_SERVICE, this.SESSION.getParamPresent("semantic.format").orElse(null));
        if (this.maven.getSettings().getServers() == null) {
            this.maven.getSettings().setServers(new ArrayList<Server>());
        }
        MavenSession mavenSession = this.SESSION.getMavenSession();
        mavenSession.getUserProperties().putAll((Map<?, ?>)this.SESSION.getProperties());
        mavenSession.getUserProperties().putAll(AdditionalPropertyReader.readModuleProperties(this.project.getModules()));
        mavenSession.getUserProperties().putAll(AdditionalPropertyReader.readLicenseProperties(this.project.getLicenses()));
        mavenSession.getUserProperties().putAll(AdditionalPropertyReader.readDeveloperProperties(this.project.getDevelopers()));
        this.GIT_SERVICE.getConfig().forEach((key, value) -> this.setWhen(true, "git." + key, (String)value, new boolean[0]));
        this.setWhen(true, "project.name", this.project.getName(), new boolean[0]);
        this.setWhen(true, "project.groupId", this.project.getGroupId(), new boolean[0]);
        this.setWhen(true, "project.artifactId", this.project.getArtifactId(), new boolean[0]);
        this.setWhen(true, "project.packaging", this.project.getPackaging(), new boolean[0]);
        this.setWhen(true, "project.description", this.project.getDescription(), new boolean[0]);
        this.setWhen(true, "project.url", this.project.getUrl(), new boolean[0]);
        this.setWhen(true, "project.id", this.project.getId(), new boolean[0]);
        this.setWhen(true, "project.version", this.project.getVersion(), new boolean[0]);
        this.setWhen(true, "project.defaultGoal", this.project.getDefaultGoal(), new boolean[0]);
        this.setWhen(true, "project.inceptionYear", this.project.getInceptionYear(), new boolean[0]);
        this.setWhen(true, "project.modelVersion", this.project.getModelVersion(), new boolean[0]);
        this.setWhen(Parameter.BASE_DIR, this.basedir.toString(), !this.hasText(Parameter.BASE_DIR));
    }

    private void runWhen(ThrowingFunction consumer, boolean ... when) throws Exception {
        for (boolean trigger : when) {
            if (!trigger) continue;
            consumer.run();
            break;
        }
    }

    private void setWhen(Parameter key, String value, boolean ... when) {
        this.setWhen(key.key(), value, when);
    }

    private void setWhen(String key, String value, boolean ... when) {
        this.setWhen(false, key, value, when);
    }

    private void setWhen(boolean silent, String key, String value, boolean ... when) {
        if (when.length == 0) {
            this.SESSION.setNewParam(silent, key, value);
        } else {
            for (boolean trigger : when) {
                if (!trigger) continue;
                this.SESSION.setNewParam(silent, key, value);
                break;
            }
        }
    }

    private boolean isLibrary() {
        return MojoUtil.isEmpty(this.project.getPackaging()) || this.project.getPackaging().equals("pom");
    }

    private boolean isTrue(String ... keys) {
        return this.SESSION.isTrue(keys);
    }

    private boolean hasText(Parameter ... keys) {
        return this.hasText((String[])Arrays.stream(keys).map(Parameter::key).toArray(String[]::new));
    }

    private boolean hasText(String ... keys) {
        return this.SESSION.hasText(keys);
    }
}

