/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.mavendeploy.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MojoUtil {
    public static String SECRET_URL_PATTERN = "(?<prefix>.*\\/\\/)(?<credentials>.*@)(?<suffix>.*)";

    public static boolean isPresent(String test) {
        return !MojoUtil.isEmpty(test);
    }

    public static boolean isEmpty(String test) {
        return test == null || test.trim().isEmpty();
    }

    private static String nullToEmpty(String test) {
        return MojoUtil.isEmpty(test) ? "" : test;
    }

    public static List<HashMap<String, String>> regex(Pattern pattern, CharSequence input, String ... groups) {
        return MojoUtil.regex(pattern.matcher(input), groups);
    }

    public static HashMap<String, String> regexFirst(Matcher matcher, String ... groupNames) {
        List<HashMap<String, String>> result = MojoUtil.regex(matcher, groupNames);
        return result.isEmpty() ? new HashMap() : result.get(0);
    }

    public static Optional<String> regexSimple(Matcher matcher, String groupName) {
        return MojoUtil.regexSimpleList(matcher, groupName).stream().findFirst();
    }

    public static List<String> splitAtDigits(String versionPart) {
        ArrayList<String> parts = new ArrayList<String>();
        char[] chars = versionPart.toCharArray();
        StringBuilder digit = new StringBuilder();
        StringBuilder text = new StringBuilder();
        for (char aChar : chars) {
            if (Character.isDigit(aChar)) {
                if (MojoUtil.isPresent(text.toString())) {
                    parts.add(text.toString());
                    text.delete(0, text.length());
                }
                digit.append(aChar);
                continue;
            }
            if (MojoUtil.isPresent(digit.toString())) {
                parts.add(digit.toString());
                digit.delete(0, digit.length());
            }
            text.append(aChar);
        }
        parts.add(digit.toString() + text.toString());
        return parts;
    }

    public static boolean isNumeric(String number) {
        return MojoUtil.isPresent(number) && number.chars().mapToObj(i -> Character.valueOf((char)i)).allMatch(Character::isDigit);
    }

    private static List<String> regexSimpleList(Matcher matcher, String groupName) {
        return MojoUtil.regex(matcher, groupName).stream().filter(map -> !map.isEmpty()).map(map -> (String)map.values().iterator().next()).filter(MojoUtil::isPresent).collect(Collectors.toList());
    }

    private static List<HashMap<String, String>> regex(Matcher matcher, String ... groupNames) {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        while (matcher.find()) {
            HashMap<String, String> groups = new HashMap<String, String>();
            for (String groupName : groupNames) {
                groups.put(groupName, matcher.group(groupName));
            }
            result.add(groups);
        }
        return result;
    }

    public static boolean deletePath(Path dir) {
        if (Files.isRegularFile(dir, new LinkOption[0])) {
            MojoUtil.deleteFile(dir);
            return true;
        }
        try {
            Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(MojoUtil::deleteFile);
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }

    private static void deleteFile(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            System.err.println("Can't remove file [" + path + "] " + e);
        }
    }
}

