/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.logic;

import berlin.yuna.natsserver.util.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.StringUtils;

public class NatsServer
implements DisposableBean {
    public static final String BEAN_NAME = NatsServer.class.getSimpleName();
    private static final Logger LOG = LoggerFactory.getLogger(NatsServer.class);
    private static final String NATS_SERVER_VERSION = "v0.9.2";
    private static final SystemUtil.OperatingSystem OPERATING_SYSTEM = SystemUtil.getOsType();
    private Map<String, String> natsServerConfig = new HashMap<String, String>();
    private Process process;

    public NatsServer() {
    }

    public NatsServer(int port) {
        this.natsServerConfig.put("port", String.valueOf(port));
    }

    public NatsServer(String ... natsServerConfig) {
        this.setNatsServerConfig(natsServerConfig);
    }

    public Map<String, String> getNatsServerConfig() {
        return this.natsServerConfig;
    }

    public void setNatsServerConfig(Map<String, String> natsServerConfig) {
        this.natsServerConfig = natsServerConfig;
    }

    public void setNatsServerConfig(String ... natsServerConfigArray) {
        HashMap<String, String> natsServerConfig = new HashMap<String, String>();
        for (String property : natsServerConfigArray) {
            String[] pair = property.split(":");
            if (!StringUtils.hasText((String)property) || pair.length != 2) {
                LOG.error("Could not parse property [{}] pair length [{}]", (Object)property, (Object)pair.length);
                continue;
            }
            natsServerConfig.put(pair[0], pair[1]);
        }
        this.natsServerConfig = natsServerConfig;
    }

    public void start() throws IOException {
        if (this.process != null) {
            LOG.error("[{}] is already running", (Object)BEAN_NAME);
            return;
        }
        if (!this.waitForPort(true)) {
            throw new BindException("Address already in use [" + this.getPort() + "]");
        }
        Path natsServerPath = this.getNatsServerPath();
        LOG.info("Starting [{}] port [{}] version [{}-{}]", new Object[]{BEAN_NAME, this.getPort(), NATS_SERVER_VERSION, OPERATING_SYSTEM});
        this.fixFilePermissions(natsServerPath);
        String command = this.prepareCommand(natsServerPath);
        this.executeCommand(command);
        if (!this.waitForPort(false)) {
            throw new RuntimeException(new ConnectException(BEAN_NAME + "failed to start."));
        }
        LOG.info("Started [{}] port [{}] version [{}-{}]", new Object[]{BEAN_NAME, this.getPort(), NATS_SERVER_VERSION, OPERATING_SYSTEM});
    }

    public void stop() {
        try {
            LOG.info("Stopping [{}]", (Object)BEAN_NAME);
            this.process.destroy();
            this.process.waitFor();
        }
        catch (InterruptedException | NullPointerException e) {
            LOG.warn("Could not stop [{}] cause cant find process", (Object)BEAN_NAME);
        }
        finally {
            LOG.info("Stopped [{}]", (Object)BEAN_NAME);
        }
    }

    public int getPort() {
        for (String key : new String[]{"port", "--port", "-p"}) {
            String port = this.natsServerConfig.get(key);
            if (port == null) continue;
            return Integer.valueOf(port);
        }
        throw new RuntimeException(new ServiceConfigurationError("Could not initialise port" + BEAN_NAME));
    }

    public void destroy() {
        this.stop();
    }

    private Path getNatsServerPath() {
        StringBuilder path = new StringBuilder();
        path.append(BEAN_NAME.toLowerCase()).append(File.separator);
        path.append(NATS_SERVER_VERSION).append(File.separator);
        path.append(OPERATING_SYSTEM.toString().toLowerCase()).append(File.separator);
        path.append(BEAN_NAME.toLowerCase()).append(OPERATING_SYSTEM == SystemUtil.OperatingSystem.WINDOWS ? ".exe" : "");
        return Paths.get(Objects.requireNonNull(this.getClass().getClassLoader().getResource(path.toString())).getFile(), new String[0]);
    }

    private boolean waitForPort(boolean isFree) {
        long start = System.currentTimeMillis();
        long timeout = TimeUnit.SECONDS.toMillis(10L);
        while (System.currentTimeMillis() - start < timeout) {
            if (NatsServer.isPortAvailable(this.getPort()) == isFree) {
                return true;
            }
            Thread.yield();
        }
        return false;
    }

    private static boolean isPortAvailable(int port) {
        try {
            new Socket("localhost", port).close();
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    private void fixFilePermissions(Path natsServerPath) throws IOException {
        Files.setPosixFilePermissions(natsServerPath, EnumSet.of(PosixFilePermission.OTHERS_EXECUTE, new PosixFilePermission[]{PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.GROUP_READ, PosixFilePermission.OWNER_READ}));
    }

    private void executeCommand(String command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (OPERATING_SYSTEM == SystemUtil.OperatingSystem.WINDOWS) {
            builder.command("cmd.exe", "/c", command);
        } else {
            builder.command("sh", "-c", command);
        }
        this.process = builder.start();
    }

    private String prepareCommand(Path natsServerPath) {
        StringBuilder command = new StringBuilder();
        command.append(natsServerPath.toString());
        for (Map.Entry<String, String> entry : this.getNatsServerConfig().entrySet()) {
            String key = entry.getKey().trim().toLowerCase();
            command.append(" ");
            if (!entry.getKey().startsWith("--") && !entry.getKey().startsWith("-")) {
                command.append("--");
            }
            command.append(key);
            command.append(" ");
            command.append(entry.getValue().trim().toLowerCase());
        }
        return command.toString();
    }

    public String toString() {
        int port;
        try {
            port = this.getPort();
        }
        catch (Exception e) {
            port = -1;
        }
        return BEAN_NAME + "{NATS_SERVER_VERSION=" + NATS_SERVER_VERSION + ", OPERATING_SYSTEM=" + (Object)((Object)OPERATING_SYSTEM) + ", port=" + port + '}';
    }
}

