/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.util;

public class SystemUtil {
    public static OperatingSystem getOsType() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osArch.contains("arm")) {
            return OperatingSystem.ARM;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.indexOf("aix") > 0) {
            return OperatingSystem.LINUX;
        }
        if (osName.contains("mac")) {
            return OperatingSystem.MAC;
        }
        if (osName.contains("win")) {
            return OperatingSystem.WINDOWS;
        }
        if (osName.contains("sunos")) {
            return OperatingSystem.SOLARIS;
        }
        return OperatingSystem.UNKNOWN;
    }

    public static enum OperatingSystem {
        ARM,
        LINUX,
        MAC,
        WINDOWS,
        SOLARIS,
        UNKNOWN;

    }
}

