/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.embedded.annotation;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.natsserver.config.NatsConfig;
import berlin.yuna.natsserver.embedded.annotation.EnableNatsServer;
import berlin.yuna.natsserver.embedded.logic.NatsServer;
import berlin.yuna.natsserver.embedded.model.exception.NatsStartException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class EnableNatsServerContextCustomizer
implements ContextCustomizer {
    private final EnableNatsServer enableNatsServer;
    private static final Logger LOG = LoggerFactory.getLogger(EnableNatsServerContextCustomizer.class);

    EnableNatsServerContextCustomizer(EnableNatsServer enableNatsServer) {
        this.enableNatsServer = enableNatsServer;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        Assert.isInstanceOf(DefaultSingletonBeanRegistry.class, (Object)beanFactory);
        ConfigurableEnvironment environment = context.getEnvironment();
        if (this.enableNatsServer == null) {
            LOG.debug("Skipping [{}] cause its not defined", (Object)EnableNatsServer.class.getSimpleName());
            return;
        }
        NatsServer natsServerBean = new NatsServer(this.enableNatsServer.timeoutMs());
        natsServerBean.setConfig(this.enableNatsServer.config());
        natsServerBean.port(this.overwritePort(natsServerBean));
        String sourceUrl = this.overwriteSourceUrl(environment, natsServerBean.source());
        natsServerBean.source(!StringUtils.hasText((String)sourceUrl) ? natsServerBean.source() : sourceUrl);
        natsServerBean.setConfig(this.mergeConfig(environment, natsServerBean.getConfig()));
        try {
            natsServerBean.start(this.enableNatsServer.timeoutMs());
        }
        catch (Exception e) {
            natsServerBean.stop(this.enableNatsServer.timeoutMs());
            throw new NatsStartException("Failed to initialise " + EnableNatsServer.class.getSimpleName(), e);
        }
        beanFactory.initializeBean((Object)natsServerBean, NatsServer.BEAN_NAME);
        beanFactory.registerSingleton(NatsServer.BEAN_NAME, (Object)natsServerBean);
        ((DefaultSingletonBeanRegistry)beanFactory).registerDisposableBean(NatsServer.BEAN_NAME, (DisposableBean)natsServerBean);
    }

    private String overwriteSourceUrl(ConfigurableEnvironment environment, String fallback) {
        return environment.getProperty("nats.source.default", environment.getProperty("nats.source." + SystemUtil.getOsType().toString().toLowerCase(), fallback));
    }

    private int overwritePort(NatsServer natsServerBean) {
        if (this.enableNatsServer.randomPort()) {
            return -1;
        }
        return this.enableNatsServer.port() > 0 && this.enableNatsServer.port() != ((Integer)NatsConfig.PORT.getDefaultValue()).intValue() ? this.enableNatsServer.port() : natsServerBean.port();
    }

    private Map<NatsConfig, String> mergeConfig(ConfigurableEnvironment environment, Map<NatsConfig, String> originalConfig) {
        HashMap<NatsConfig, String> mergedConfig = new HashMap<NatsConfig, String>(originalConfig);
        for (NatsConfig NatsConfig2 : NatsConfig.values()) {
            String key = "nats.server." + NatsConfig2.name().toLowerCase();
            String value = environment.getProperty(key);
            if (!StringUtils.hasText((String)value) || mergedConfig.containsKey(NatsConfig2)) continue;
            mergedConfig.put(NatsConfig2, value);
        }
        return mergedConfig;
    }
}

