/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.embedded.annotation;

import berlin.yuna.natsserver.config.NatsConfig;
import berlin.yuna.natsserver.config.NatsOptions;
import berlin.yuna.natsserver.config.NatsOptionsBuilder;
import berlin.yuna.natsserver.embedded.annotation.EnableNatsServer;
import berlin.yuna.natsserver.embedded.logic.NatsServer;
import berlin.yuna.natsserver.embedded.model.exception.NatsStartException;
import berlin.yuna.natsserver.logic.Nats;
import berlin.yuna.natsserver.logic.NatsUtils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class EnableNatsServerContextCustomizer
implements ContextCustomizer {
    private final EnableNatsServer enableNatsServer;
    private static final Logger LOG = LoggerFactory.getLogger(EnableNatsServerContextCustomizer.class);

    EnableNatsServerContextCustomizer(EnableNatsServer enableNatsServer) {
        this.enableNatsServer = enableNatsServer;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        Assert.isInstanceOf(DefaultSingletonBeanRegistry.class, (Object)beanFactory);
        ConfigurableEnvironment environment = context.getEnvironment();
        if (this.enableNatsServer == null) {
            LOG.debug("Skipping [{}] cause its not defined", (Object)EnableNatsServer.class.getSimpleName());
            return;
        }
        NatsServer natsServer = null;
        NatsOptionsBuilder options = NatsOptions.natsBuilder().timeoutMs((Number)this.enableNatsServer.timeoutMs());
        this.setEnvConfig(options, environment);
        if (this.enableNatsServer.port() != ((Integer)NatsConfig.PORT.defaultValue()).intValue()) {
            options.port(Integer.valueOf(this.enableNatsServer.port()));
        }
        options.config(this.enableNatsServer.config()).version(NatsUtils.isNotEmpty((String)this.enableNatsServer.version()) ? this.enableNatsServer.version() : options.version());
        this.configure(options, NatsConfig.NATS_PROPERTY_FILE, this.enableNatsServer.configFile());
        this.configure(options, NatsConfig.NATS_BINARY_PATH, this.enableNatsServer.binaryFile());
        this.configure(options, NatsConfig.NATS_DOWNLOAD_URL, this.enableNatsServer.downloadUrl());
        try {
            natsServer = new NatsServer(options.build());
        }
        catch (Exception e) {
            Optional.ofNullable(natsServer).ifPresent(Nats::close);
            throw new NatsStartException("Failed to initialise name [" + EnableNatsServer.class.getSimpleName() + "] port [" + options.port() + "] timeoutMs [" + options.timeoutMs() + "] logLevel [" + options.logLevel() + "] jetStream [" + options.jetStream() + "] autostart [" + options.autostart() + "] configFile [" + options.configFile() + "] downloadUrl [" + (String)options.configMap().get(NatsConfig.NATS_DOWNLOAD_URL) + "]", e);
        }
        beanFactory.initializeBean((Object)natsServer, NatsServer.BEAN_NAME);
        beanFactory.registerSingleton(NatsServer.BEAN_NAME, (Object)natsServer);
        ((DefaultSingletonBeanRegistry)beanFactory).registerDisposableBean(NatsServer.BEAN_NAME, (DisposableBean)natsServer);
    }

    private void configure(NatsOptionsBuilder options, NatsConfig key, String value) {
        if (StringUtils.hasText((String)value)) {
            options.config(key, value);
        }
    }

    private void setEnvConfig(NatsOptionsBuilder options, ConfigurableEnvironment environment) {
        for (NatsConfig natsConfig : NatsConfig.values()) {
            String key = "nats.server." + natsConfig.name().toLowerCase();
            String value = environment.getProperty(key);
            if (!StringUtils.hasText((String)value)) continue;
            options.config(natsConfig, value);
        }
    }
}

