/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.config;

import berlin.yuna.natsserver.config.NatsConfig;
import berlin.yuna.natsserver.config.NatsOptionsBuilder;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NatsOptions
implements io.nats.commons.NatsOptions {
    protected final Logger logger;
    protected final Map<NatsConfig, String> config;

    public NatsOptions(Logger logger, Map<NatsConfig, String> config) {
        this.logger = logger;
        this.config = config == null ? new EnumMap<NatsConfig, String>(NatsConfig.class) : new EnumMap<NatsConfig, String>(config);
    }

    public String version() {
        return this.config.get((Object)NatsConfig.NATS_VERSION);
    }

    @Override
    public Integer port() {
        return NatsOptionsBuilder.getValueI(this.config, NatsConfig.PORT);
    }

    @Override
    public Boolean jetStream() {
        return NatsOptionsBuilder.getValueB(this.config, NatsConfig.JETSTREAM);
    }

    @Override
    public Boolean debug() {
        return NatsOptionsBuilder.getValueB(this.config, NatsConfig.DV);
    }

    @Override
    public Path configFile() {
        return NatsOptionsBuilder.getValue(this.config, x$0 -> Path.of(x$0, new String[0]), NatsConfig.CONFIG);
    }

    @Override
    public String[] customArgs() {
        return NatsOptionsBuilder.getValue(this.config, args -> args.split("&&"), NatsConfig.NATS_ARGS);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public Level logLevel() {
        return NatsOptionsBuilder.getValue(this.config, NatsConfig::logLevelOf, NatsConfig.NATS_LOG_LEVEL);
    }

    public Map<NatsConfig, String> config() {
        return this.config;
    }

    public static NatsOptionsBuilder natsBuilder() {
        return new NatsOptionsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NatsOptions that = (NatsOptions)o;
        return Objects.equals(this.logger, that.logger) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.logger, this.config);
    }
}

