/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.config;

import berlin.yuna.natsserver.config.NatsConfig;
import berlin.yuna.natsserver.config.NatsOptions;
import berlin.yuna.natsserver.config.NatsVersion;
import berlin.yuna.natsserver.logic.Nats;
import berlin.yuna.natsserver.logic.NatsUtils;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NatsOptionsBuilder {
    protected Logger logger;
    protected Map<NatsConfig, String> configMap = new EnumMap<NatsConfig, String>(NatsConfig.class);

    protected NatsOptionsBuilder() {
    }

    public NatsOptions build() {
        return new NatsOptions(this.logger, this.configMap);
    }

    public Nats nats() {
        return new Nats(this);
    }

    public String version() {
        return this.configMap.get((Object)NatsConfig.NATS_VERSION);
    }

    public NatsOptionsBuilder version(String version) {
        this.configMap.put(NatsConfig.NATS_VERSION, Optional.ofNullable(version).filter(NatsUtils::isNotEmpty).map(v -> v.toLowerCase().startsWith("v") ? v : "v" + v).orElse(null));
        return this;
    }

    public NatsOptionsBuilder version(NatsVersion version) {
        this.configMap.put(NatsConfig.NATS_VERSION, version != null ? version.value() : null);
        return this;
    }

    public Integer port() {
        return NatsOptionsBuilder.getValueI(this.configMap, NatsConfig.PORT);
    }

    public NatsOptionsBuilder port(Integer port) {
        NatsOptionsBuilder.setValueI(this.configMap, NatsConfig.PORT, port);
        return this;
    }

    public Boolean jetStream() {
        return NatsOptionsBuilder.getValueB(this.configMap, NatsConfig.JETSTREAM);
    }

    public NatsOptionsBuilder jetStream(Boolean jetStream) {
        NatsOptionsBuilder.setValueB(this.configMap, NatsConfig.JETSTREAM, jetStream);
        return this;
    }

    public Boolean debug() {
        return NatsOptionsBuilder.getValueB(this.configMap, NatsConfig.DV);
    }

    public NatsOptionsBuilder debug(Boolean debug) {
        NatsOptionsBuilder.setValueB(this.configMap, NatsConfig.DV, debug);
        return this;
    }

    public Path configFile() {
        return NatsOptionsBuilder.getValue(this.configMap, x$0 -> Path.of(x$0, new String[0]), NatsConfig.CONFIG);
    }

    public NatsOptionsBuilder configFile(Path configFile) {
        NatsOptionsBuilder.setValue(this.configMap, Path::toString, NatsConfig.CONFIG, configFile);
        return this;
    }

    public Path configPropertyFile() {
        return NatsOptionsBuilder.getValue(this.configMap, x$0 -> Path.of(x$0, new String[0]), NatsConfig.NATS_PROPERTY_FILE);
    }

    public NatsOptionsBuilder configPropertyFile(Path configFile) {
        NatsOptionsBuilder.setValue(this.configMap, Path::toString, NatsConfig.NATS_PROPERTY_FILE, configFile);
        return this;
    }

    public String[] customArgs() {
        return NatsOptionsBuilder.getValue(this.configMap, args -> args.split("&&"), NatsConfig.NATS_ARGS);
    }

    public NatsOptionsBuilder customArgs(String ... customArgs) {
        Optional.ofNullable(customArgs).ifPresent(value -> this.configMap.put(NatsConfig.NATS_ARGS, String.join((CharSequence)"&&", value)));
        return this;
    }

    public NatsOptionsBuilder addArgs(String ... customArgs) {
        String args = this.configMap.get((Object)NatsConfig.NATS_ARGS);
        Optional.ofNullable(customArgs).ifPresent(value -> {
            if (args != null) {
                this.configMap.put(NatsConfig.NATS_ARGS, String.join((CharSequence)"&&", args, String.join((CharSequence)"&&", value)));
            } else {
                this.configMap.put(NatsConfig.NATS_ARGS, String.join((CharSequence)"&&", value));
            }
        });
        return this;
    }

    public Logger logger() {
        return this.logger;
    }

    public NatsOptionsBuilder logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Level logLevel() {
        return NatsOptionsBuilder.getValue(this.configMap, NatsConfig::logLevelOf, NatsConfig.NATS_LOG_LEVEL);
    }

    public NatsOptionsBuilder logLevel(Level level) {
        NatsOptionsBuilder.setValue(this.configMap, Level::getName, NatsConfig.NATS_LOG_LEVEL, level);
        return this;
    }

    public Boolean autostart() {
        return NatsOptionsBuilder.getValueB(this.configMap, NatsConfig.NATS_AUTOSTART);
    }

    public NatsOptionsBuilder autostart(Boolean autostart) {
        NatsOptionsBuilder.setValueB(this.configMap, NatsConfig.NATS_AUTOSTART, autostart);
        return this;
    }

    public Boolean shutdownHook() {
        return NatsOptionsBuilder.getValueB(this.configMap, NatsConfig.NATS_SHUTDOWN_HOOK);
    }

    public NatsOptionsBuilder shutdownHook(Boolean enabled) {
        NatsOptionsBuilder.setValueB(this.configMap, NatsConfig.NATS_SHUTDOWN_HOOK, enabled);
        return this;
    }

    public Long timeoutMs() {
        return NatsOptionsBuilder.getValue(this.configMap, Long::parseLong, NatsConfig.NATS_TIMEOUT_MS);
    }

    public NatsOptionsBuilder timeoutMs(Number timeoutMs) {
        NatsOptionsBuilder.setValue(this.configMap, number -> String.valueOf(number.longValue()), NatsConfig.NATS_TIMEOUT_MS, timeoutMs);
        return this;
    }

    public Map<NatsConfig, String> configMap() {
        return this.configMap;
    }

    public NatsOptionsBuilder configMap(Map<NatsConfig, String> configMap) {
        this.configMap = new EnumMap<NatsConfig, String>(configMap);
        return this;
    }

    public NatsOptionsBuilder config(NatsConfig key, String value) {
        this.configMap.put(key, value);
        return this;
    }

    public NatsOptionsBuilder config(String ... kv) {
        for (int i = 0; i < kv.length - 1; i += 2) {
            this.config(NatsConfig.valueOf(kv[i].toUpperCase().replace("-", "")), kv[i + 1]);
        }
        return this;
    }

    protected static Integer getValueI(Map<NatsConfig, String> config, NatsConfig key) {
        return NatsOptionsBuilder.getValue(config, Integer::parseInt, key);
    }

    protected static Boolean getValueB(Map<NatsConfig, String> config, NatsConfig key) {
        return NatsOptionsBuilder.getValue(config, Boolean::parseBoolean, key);
    }

    protected static <T> T getValue(Map<NatsConfig, String> config, Function<String, T> map, NatsConfig key) {
        return Optional.ofNullable(config.get((Object)key)).map(map).orElse(null);
    }

    protected static void setValueI(Map<NatsConfig, String> config, NatsConfig key, Integer value) {
        NatsOptionsBuilder.setValue(config, Object::toString, key, value);
    }

    protected static void setValueB(Map<NatsConfig, String> config, NatsConfig key, Boolean value) {
        NatsOptionsBuilder.setValue(config, Object::toString, key, value);
    }

    protected static <T> void setValue(Map<NatsConfig, String> config, Function<T, String> map, NatsConfig key, T value) {
        Optional.ofNullable(value).map(map).ifPresent(val -> config.put(key, (String)val));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NatsOptionsBuilder that = (NatsOptionsBuilder)o;
        return Objects.equals(this.logger, that.logger) && Objects.equals(this.configMap, that.configMap);
    }

    public int hashCode() {
        return Objects.hash(this.logger, this.configMap);
    }
}

