/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.logic;

import berlin.yuna.natsserver.logic.NatsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class Decompressor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path extractAndReturnBiggest(Path archivePath, Path target) throws IOException {
        Path path;
        Path tempDir;
        block16: {
            String name = archivePath.getFileName().toString().toLowerCase();
            tempDir = Files.createTempDirectory("unzipped_", new FileAttribute[0]);
            Path tarFile = null;
            try {
                Path biggest;
                if (name.endsWith(".zip")) {
                    Decompressor.unzip(archivePath, tempDir);
                } else if (name.endsWith(".tar.gz") || name.endsWith(".tgz")) {
                    tarFile = Decompressor.ungzip(archivePath);
                    Decompressor.untar(tarFile, tempDir);
                } else if (name.endsWith(".gz")) {
                    Decompressor.gunzipSingle(archivePath, tempDir);
                } else {
                    throw new IllegalArgumentException("Unsupported file type: " + name);
                }
                try (Stream<Path> files = Files.walk(tempDir, new FileVisitOption[0]);){
                    biggest = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).max(Comparator.comparingLong(f -> f.toFile().length())).orElseThrow(() -> new IOException("No files found after extraction"));
                }
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.copy(biggest, target, StandardCopyOption.REPLACE_EXISTING);
                path = target;
                if (tarFile == null) break block16;
            }
            catch (Throwable throwable) {
                if (tarFile != null) {
                    Files.deleteIfExists(tarFile);
                }
                NatsUtils.deleteDirectory(tempDir);
                throw throwable;
            }
            Files.deleteIfExists(tarFile);
        }
        NatsUtils.deleteDirectory(tempDir);
        return path;
    }

    private static void unzip(Path zipFile, Path destDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFile, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path newPath = destDir.resolve(entry.getName()).normalize();
                if (!newPath.startsWith(destDir)) {
                    throw new IOException("Bad zip entry");
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    try (OutputStream os = Files.newOutputStream(newPath, new OpenOption[0]);){
                        Decompressor.copy(zis, os);
                    }
                }
                zis.closeEntry();
            }
        }
    }

    private static Path ungzip(Path gzFile) throws IOException {
        Path out = Files.createTempFile("untar_", ".tar", new FileAttribute[0]);
        try (GZIPInputStream gis = new GZIPInputStream(Files.newInputStream(gzFile, new OpenOption[0]));
             OutputStream os = Files.newOutputStream(out, new OpenOption[0]);){
            Decompressor.copy(gis, os);
        }
        return out;
    }

    private static void gunzipSingle(Path gzFile, Path destDir) throws IOException {
        String fileName = gzFile.getFileName().toString();
        if (fileName.toLowerCase().endsWith(".gz")) {
            fileName = fileName.substring(0, fileName.length() - 3);
        }
        Path out = destDir.resolve(fileName);
        Files.createDirectories(destDir, new FileAttribute[0]);
        try (GZIPInputStream gis = new GZIPInputStream(Files.newInputStream(gzFile, new OpenOption[0]));
             OutputStream os = Files.newOutputStream(out, new OpenOption[0]);){
            Decompressor.copy(gis, os);
        }
    }

    private static void untar(Path tarFile, Path destDir) throws IOException {
        try (InputStream is = Files.newInputStream(tarFile, new OpenOption[0]);){
            byte[] header = new byte[512];
            while (is.read(header) == 512) {
                long skip;
                String name = Decompressor.extractName(header);
                if (name.isEmpty()) {
                    break;
                }
                long size = Decompressor.extractSize(header);
                Path filePath = destDir.resolve(name).normalize();
                if (!filePath.startsWith(destDir)) {
                    throw new IOException("Bad tar entry");
                }
                if (name.endsWith("/")) {
                    Files.createDirectories(filePath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                    try (OutputStream os = Files.newOutputStream(filePath, new OpenOption[0]);){
                        Decompressor.copy(is, os, size);
                    }
                }
                if ((skip = (512L - size % 512L) % 512L) <= 0L) continue;
                is.skip(skip);
            }
        }
    }

    private static String extractName(byte[] header) {
        int len;
        for (len = 0; len < 100 && header[len] != 0; ++len) {
        }
        return new String(header, 0, len);
    }

    private static long extractSize(byte[] header) {
        long size = 0L;
        for (int i = 124; i < 136 && header[i] != 0; ++i) {
            size = (size << 3) + (long)(header[i] - 48);
        }
        return size;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }

    private static void copy(InputStream in, OutputStream out, long size) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        for (long remaining = size; remaining > 0L && (len = in.read(buf, 0, (int)Math.min((long)buf.length, remaining))) != -1; remaining -= (long)len) {
            out.write(buf, 0, len);
        }
    }

    private Decompressor() {
    }
}

