/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.logic;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.natsserver.config.NatsConfig;
import berlin.yuna.natsserver.config.NatsSourceConfig;
import berlin.yuna.natsserver.model.exception.NatsDownloadException;
import berlin.yuna.natsserver.model.exception.NatsFileReaderException;
import berlin.yuna.natsserver.model.exception.NatsStartException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.PortUnreachableException;
import java.net.Socket;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nats {
    protected int pid = -1;
    protected final String name;
    protected static final Logger LOG = LoggerFactory.getLogger(Nats.class);
    protected static final SystemUtil.OperatingSystem OPERATING_SYSTEM = SystemUtil.getOsType();
    protected static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private Process process;
    private String source = NatsSourceConfig.valueOf(SystemUtil.getOsType().toString().replace("UNKNOWN", "DEFAULT")).getDefaultValue();
    private Map<NatsConfig, String> config = this.getDefaultConfig();

    public Nats() {
        this.name = Nats.class.getSimpleName() + "server";
    }

    public Nats(int port) {
        this();
        this.port(port);
    }

    public Nats(String ... config) {
        this();
        this.config(config);
    }

    public Map<NatsConfig, String> config() {
        return this.config;
    }

    public Nats config(NatsConfig key, String value) {
        this.config.remove((Object)key, value);
        this.config.put(key, value);
        return this;
    }

    public Nats config(Map<NatsConfig, String> config) {
        this.config = config;
        return this;
    }

    public Nats config(String ... config) {
        for (String property : config) {
            String[] pair = property.split(":");
            if (this.isEmpty(property) || pair.length != 2) {
                LOG.error("Could not parse property [{}] pair length [{}]", (Object)property, (Object)pair.length);
                continue;
            }
            this.config(NatsConfig.valueOf(pair[0].toUpperCase().replace("-", "")), pair[1]);
        }
        return this;
    }

    public Nats tryStart() {
        return this.tryStart(TimeUnit.SECONDS.toMillis(10L));
    }

    public Nats tryStart(long timeoutMs) {
        try {
            this.start(timeoutMs);
            return this;
        }
        catch (IOException e) {
            throw new NatsStartException(e);
        }
    }

    public Nats start() throws IOException {
        return this.start(TimeUnit.SECONDS.toMillis(10L));
    }

    public Nats start(long timeoutMs) throws IOException {
        if (this.process != null) {
            LOG.error("[{}] is already running", (Object)this.name);
            return this;
        }
        if (!Nats.waitForPort(this.port(), timeoutMs, true)) {
            throw new BindException("Address already in use [" + this.port() + "]");
        }
        Path natsServerPath = this.getNatsServerPath(OPERATING_SYSTEM);
        SystemUtil.setFilePermissions((Path)natsServerPath, (PosixFilePermission[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OTHERS_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OTHERS_WRITE});
        LOG.debug("Starting [{}] port [{}] version [{}]", new Object[]{this.name, this.port(), OPERATING_SYSTEM});
        String command = this.prepareCommand(natsServerPath);
        LOG.debug(command);
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = arg_0 -> ((Logger)LOG).info(arg_0);
        Consumer[] consumerArray2 = new Consumer[1];
        consumerArray2[0] = arg_0 -> ((Logger)LOG).error(arg_0);
        Terminal terminal = new Terminal().consumerInfo(consumerArray).consumerError(consumerArray2).timeoutMs(timeoutMs > 0L ? timeoutMs : 10000L).breakOnError(false).execute(command);
        this.process = terminal.process();
        if (!Nats.waitForPort(this.port(), timeoutMs, false)) {
            throw new PortUnreachableException(this.name + " failed to start with port [" + this.port() + "]\n" + terminal.consoleInfo() + "\n" + terminal.consoleError());
        }
        LOG.info("Started [{}] port [{}] version [{}] pid [{}]", new Object[]{this.name, this.port(), OPERATING_SYSTEM, this.readPid()});
        return this;
    }

    public Nats stop() {
        return this.stop(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Nats stop(long timeoutMs) {
        try {
            LOG.info("Stopping [{}]", (Object)this.name);
            if (this.pid > 0) {
                Consumer[] consumerArray = new Consumer[1];
                consumerArray[0] = arg_0 -> ((Logger)LOG).info(arg_0);
                Consumer[] consumerArray2 = new Consumer[1];
                consumerArray2[0] = arg_0 -> ((Logger)LOG).error(arg_0);
                new Terminal().consumerInfo(consumerArray).consumerError(consumerArray2).breakOnError(false).execute(this.getNatsServerPath(OPERATING_SYSTEM).toString() + " " + NatsConfig.SIGNAL.getKey() + " stop=" + this.pid);
            }
            this.process.destroy();
            this.process.waitFor();
        }
        catch (InterruptedException | NullPointerException ignored) {
            LOG.warn("Could not find process to stop [{}]", (Object)this.name);
        }
        finally {
            Nats.waitForPort(this.port(), timeoutMs, true);
            LOG.info("Stopped [{}]", (Object)this.name);
        }
        return this.tryDeleteFile(this.pidFile());
    }

    public int port() {
        String port = this.config.get((Object)NatsConfig.PORT);
        if (port != null) {
            return Integer.parseInt(port);
        }
        throw new MissingFormatArgumentException("Could not initialise port " + this.name);
    }

    public Nats port(int port) {
        this.config(NatsConfig.PORT, String.valueOf(port < 1 ? this.getNextFreePort() : port));
        return this;
    }

    public Nats source(String natsServerUrl) {
        this.source = natsServerUrl;
        return this;
    }

    public String source() {
        return this.source;
    }

    public int pid() {
        return this.pid;
    }

    public Path pidFile() {
        return Paths.get(this.config.computeIfAbsent(NatsConfig.PID, value -> Paths.get(TMP_DIR, this.name.toLowerCase(), this.port() + ".pid").toString()), new String[0]);
    }

    public Path natsPath() {
        return this.getNatsServerPath(OPERATING_SYSTEM);
    }

    protected Path getNatsServerPath(SystemUtil.OperatingSystem operatingSystem) {
        String targetPath = this.name.toLowerCase() + File.separator + operatingSystem + File.separator + this.name.toLowerCase() + (operatingSystem == SystemUtil.OperatingSystem.WINDOWS ? ".exe" : "");
        return this.downloadNats(targetPath);
    }

    private boolean isEmpty(String property) {
        return property == null || property.trim().length() <= 0;
    }

    private Nats tryDeleteFile(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    private int readPid() {
        try {
            this.pid = Integer.parseInt(String.join((CharSequence)" ", Files.readAllLines(this.pidFile(), StandardCharsets.UTF_8)).trim());
        }
        catch (IOException e) {
            throw new NatsFileReaderException("Unable to read PID file [" + this.pidFile() + "]", e);
        }
        return this.pid;
    }

    private Path downloadNats(String targetPath) {
        Path tmpPath = Paths.get(TMP_DIR, targetPath);
        if (Files.notExists(tmpPath, new LinkOption[0])) {
            Path path;
            File zipFile = new File(tmpPath.getParent().toFile(), tmpPath.getFileName().toString() + ".zip");
            LOG.info("Start download natsServer from [{}] to [{}]", (Object)this.source, (Object)zipFile);
            this.createParents(tmpPath);
            FileOutputStream fos = new FileOutputStream(zipFile);
            try {
                fos.getChannel().transferFrom(Channels.newChannel(new URL(this.source).openStream()), 0L, Long.MAX_VALUE);
                path = this.setExecutable(this.unzip(zipFile, tmpPath.toFile()));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new NatsDownloadException(e);
                }
            }
            fos.close();
            return path;
        }
        LOG.info("Finished download natsServer unpacked to [{}]", (Object)tmpPath.toUri());
        return tmpPath;
    }

    private Nats createParents(Path tmpPath) {
        try {
            Files.createDirectories(tmpPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    private Path setExecutable(Path path) {
        path.toFile().setExecutable(true);
        return path;
    }

    private Path unzip(File source, File target) throws IOException {
        try (ZipFile zipFile = new ZipFile(source);){
            ZipEntry max = zipFile.stream().max(Comparator.comparingLong(ZipEntry::getSize)).orElseThrow(() -> new IllegalStateException("File not found " + zipFile));
            Files.copy(zipFile.getInputStream(max), target.toPath(), new CopyOption[0]);
            this.tryDeleteFile(source.toPath());
            Path path = target.toPath();
            return path;
        }
    }

    public static boolean waitForPort(int port, long timeoutMs, boolean isFree) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeoutMs) {
            if (Nats.isPortAvailable(port) == isFree) {
                return true;
            }
            Thread.yield();
        }
        return timeoutMs <= 0L;
    }

    private static boolean isPortAvailable(int port) {
        try {
            new Socket("localhost", port).close();
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    private String prepareCommand(Path natsServerPath) {
        StringBuilder command = new StringBuilder();
        command.append(natsServerPath.toString());
        this.pidFile();
        for (Map.Entry<NatsConfig, String> entry : this.config().entrySet()) {
            String key = entry.getKey().getKey();
            if (this.isEmpty(entry.getValue())) {
                LOG.warn("Skipping property [{}] with value [{}]", (Object)key, (Object)entry.getValue());
                continue;
            }
            command.append(" ");
            command.append(key);
            if (entry.getKey().getDescription().startsWith("[/]")) continue;
            command.append(entry.getValue().trim().toLowerCase());
        }
        return command.toString();
    }

    private Map<NatsConfig, String> getDefaultConfig() {
        EnumMap<NatsConfig, String> defaultConfig = new EnumMap<NatsConfig, String>(NatsConfig.class);
        for (NatsConfig natsConfig : NatsConfig.values()) {
            if (natsConfig.getDefaultValue() == null) continue;
            defaultConfig.put(natsConfig, natsConfig.getDefaultValue().toString());
        }
        return defaultConfig;
    }

    private int getNextFreePort() {
        for (int i = 1; i < 277; ++i) {
            int port = i + (Integer)NatsConfig.PORT.getDefaultValue();
            if (this.isPortInUse(port)) continue;
            return port;
        }
        throw new IllegalStateException("Could not find any free port");
    }

    private boolean isPortInUse(int portNumber) {
        try {
            new Socket("localhost", portNumber).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.name + "{NATS_SERVER_VERSION=" + this.source + ", OPERATING_SYSTEM=" + OPERATING_SYSTEM + ", port=" + this.port() + '}';
    }
}

