/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.config;

import berlin.yuna.clu.model.OsArch;
import berlin.yuna.clu.model.OsArchType;
import berlin.yuna.clu.model.OsType;

public enum NatsSourceConfig {
    URL("https://github.com/nats-io/nats-server/releases/download/v2.6.4/nats-server-v2.6.4#SYSTEM#.zip", "[STRING] DEFAULT SOURCE URL");

    private final String defaultValue;
    private final String description;

    private NatsSourceConfig(String defaultValue, String description) {
        this.defaultValue = defaultValue;
        this.description = description;
    }

    public String getDefaultValue(OsType os, OsArch arch, OsArchType archType) {
        return this.defaultValue.replace("#SYSTEM#", NatsSourceConfig.osString(os, "-") + NatsSourceConfig.osString(arch, "-") + NatsSourceConfig.osString(archType, null)).replace("mips64", "linux-mips64le");
    }

    public String getDescription() {
        return this.description;
    }

    private static String osString(Enum<?> input, String prefix) {
        if (input != null && !input.toString().contains("UNKNOWN")) {
            String result = input.toString();
            result = result.startsWith("OS_") ? result.substring(3) : result;
            result = result.startsWith("ARCH_") ? result.substring(5) : result;
            result = result.startsWith("AT_") ? result.substring(3) : result;
            result = result.replace("86", "386");
            result = result.replace("INTEL", "");
            result = result.replace("MAC", "darwin");
            result = result.replace("_", "");
            return (prefix == null ? "" : "-") + result.toLowerCase();
        }
        return "";
    }
}

