/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.logic;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.clu.model.OsType;
import berlin.yuna.natsserver.config.NatsConfig;
import berlin.yuna.natsserver.logic.NatsUtils;
import berlin.yuna.natsserver.model.MapValue;
import berlin.yuna.natsserver.model.ValueSource;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class NatsBase
implements AutoCloseable {
    public static final String NATS_PREFIX = "NATS_";
    final String name;
    final Logger logger;
    final Map<NatsConfig, MapValue> config = new ConcurrentHashMap<NatsConfig, MapValue>();
    final List<String> customArgs = new ArrayList<String>();
    Process process;
    private static final String TMP_DIR = "java.io.tmpdir";

    NatsBase(List<String> customArgs) {
        this.setDefaultConfig().setEnvConfig().readConfigFile();
        this.name = this.getValue(NatsConfig.NATS_LOG_NAME);
        this.logger = Logger.getLogger(this.name);
        this.customArgs.addAll(customArgs);
    }

    public int pid() {
        try {
            return Integer.parseInt(String.join((CharSequence)" ", Files.readAllLines(this.pidFile(), StandardCharsets.UTF_8)).trim());
        }
        catch (IOException e) {
            return -1;
        }
    }

    public Path pidFile() {
        return Paths.get(this.getValue(NatsConfig.PID, () -> Paths.get(NatsUtils.getEnv(TMP_DIR), this.getValue(NatsConfig.NATS_LOG_NAME).toLowerCase(), this.port() + ".pid").toString()), new String[0]);
    }

    public Path binaryFile() {
        return Paths.get(this.getValue(NatsConfig.NATS_BINARY_PATH, () -> Paths.get(NatsUtils.getEnv(TMP_DIR), this.getValue(NatsConfig.NATS_LOG_NAME).toLowerCase(), this.getValue(NatsConfig.NATS_LOG_NAME).toLowerCase() + "_" + this.getValue(NatsConfig.NATS_SYSTEM) + (SystemUtil.OS == OsType.OS_WINDOWS ? ".exe" : "")).toString()), new String[0]);
    }

    public String downloadUrl() {
        return this.getValue(NatsConfig.NATS_DOWNLOAD_URL);
    }

    public String url() {
        return "nats://" + this.getValue(NatsConfig.ADDR) + ":" + this.port();
    }

    public int port() {
        return Integer.parseInt(this.getValue(NatsConfig.PORT));
    }

    public NatsBase args(String ... args) {
        this.customArgs.addAll(Arrays.asList(args));
        return this;
    }

    public List<String> args() {
        return this.customArgs;
    }

    public String getValue(NatsConfig key) {
        return this.getValue(key, () -> key.valueRaw() == null ? null : String.valueOf(key.valueRaw()));
    }

    public String getValue(NatsConfig key, Supplier<String> or) {
        return NatsUtils.resolveEnvs(Optional.ofNullable(this.config.get((Object)key)).map(MapValue::value).orElseGet(or), this.config);
    }

    public Optional<Path> getConfigFile() {
        for (Supplier<Path> supplier : NatsUtils.createPathSuppliers(Optional.ofNullable(this.getValue(NatsConfig.NATS_CONFIG_FILE)).filter(file -> !NatsUtils.isEmpty(file)).orElse("nats.properties"))) {
            Path path = supplier.get();
            if (path == null || !Files.exists(path, new LinkOption[0])) continue;
            return Optional.of(path);
        }
        return Optional.empty();
    }

    NatsBase deletePidFile() {
        try {
            Files.deleteIfExists(this.pidFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    Path downloadNats() throws IOException {
        Path binaryPath = this.binaryFile();
        Files.createDirectories(binaryPath.getParent(), new FileAttribute[0]);
        if (Files.notExists(binaryPath, new LinkOption[0])) {
            URL source = new URL(this.downloadUrl());
            NatsUtils.unzip(NatsUtils.download(source, Paths.get(this.binaryFile().toString() + ".zip", new String[0])), binaryPath);
        }
        binaryPath.toFile().setExecutable(true);
        SystemUtil.setFilePermissions((Path)binaryPath, (PosixFilePermission[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OTHERS_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OTHERS_WRITE});
        return binaryPath;
    }

    String prepareCommand() {
        StringBuilder command = new StringBuilder();
        this.setDefaultConfig().setEnvConfig().readConfigFile();
        this.addConfig(ValueSource.DSL, NatsConfig.PID, this.pidFile().toString());
        command.append(this.binaryFile().toString());
        this.config.forEach((key, mapValue) -> {
            if (!key.name().startsWith(NATS_PREFIX) && mapValue != null && !NatsUtils.isEmpty(mapValue.value())) {
                command.append(" ");
                command.append(key.key());
                if (!key.desc().startsWith("[/]")) {
                    command.append(mapValue.value().trim().toLowerCase());
                }
            }
        });
        command.append(this.customArgs.stream().collect(Collectors.joining(" ", " ", "")));
        command.append(Arrays.stream(this.getValue(NatsConfig.NATS_ARGS, () -> "").split("\\,")).map(String::trim).collect(Collectors.joining(" ", " ", "")));
        return command.toString();
    }

    NatsBase setNextFreePort() {
        if (this.getValue(NatsConfig.PORT, () -> "-1").equals("-1")) {
            this.addConfig(this.config.get((Object)NatsConfig.PORT).source(), NatsConfig.PORT, String.valueOf(NatsUtils.getNextFreePort((Integer)NatsConfig.PORT.valueRaw())));
        }
        return this;
    }

    NatsBase addConfig(ValueSource source, NatsConfig key, String value) {
        if (value != null) {
            this.config.put(key, this.config.computeIfAbsent(key, val -> MapValue.mapValueOf(source, value)).update(source, value));
        }
        return this;
    }

    private NatsBase readConfigFile() {
        this.getConfigFile().ifPresent(path -> {
            Properties prop = new Properties();
            try (FileInputStream inputStream = new FileInputStream(path.toFile());){
                prop.load(inputStream);
            }
            catch (IOException e) {
                Logger.getLogger(this.getValue(NatsConfig.NATS_LOG_NAME)).severe("Unable to read property file [" + path.toUri() + "] cause of [" + e.getMessage() + "]");
            }
            prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.addConfig(ValueSource.FILE, NatsConfig.valueOf(String.valueOf(key).toUpperCase()), NatsUtils.removeQuotes((String)value))));
        });
        return this;
    }

    private NatsBase setDefaultConfig() {
        for (NatsConfig cfg : NatsConfig.values()) {
            String value = cfg.value();
            this.addConfig(ValueSource.DEFAULT, cfg, value);
        }
        this.addConfig(ValueSource.DEFAULT, NatsConfig.NATS_SYSTEM, NatsUtils.getSystem());
        return this;
    }

    private NatsBase setEnvConfig() {
        for (NatsConfig cfg : NatsConfig.values()) {
            this.addConfig(ValueSource.ENV, cfg, NatsUtils.getEnv(cfg.name().startsWith(NATS_PREFIX) ? cfg.name() : NATS_PREFIX + cfg.name()));
        }
        return this;
    }

    public String toString() {
        return "NatsBase{name=" + this.name + ", pid='" + this.pid() + '\'' + ", port=" + this.port() + ", configs=" + this.config.size() + ", customArgs=" + this.customArgs.size() + '}';
    }
}

