/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.logic;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.natsserver.config.NatsConfig;
import berlin.yuna.natsserver.model.MapValue;
import berlin.yuna.natsserver.model.exception.NatsDownloadException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class NatsUtils {
    private NatsUtils() {
    }

    public static String getEnv(String key) {
        return NatsUtils.getEnv(key, () -> null);
    }

    public static String getEnv(String key, Supplier<String> fallback) {
        return Optional.ofNullable(System.getProperty(key.toLowerCase())).orElseGet(() -> Optional.ofNullable(System.getProperty(key.toUpperCase())).orElseGet(fallback));
    }

    public static String resolveEnvs(String input, Map<NatsConfig, MapValue> config) {
        int end;
        int start;
        String result = input;
        while (result != null && (start = result.indexOf("%")) != -1 && (end = result.indexOf("%", start + 1)) != -1) {
            String key = result.substring(start + 1, end);
            result = result.substring(0, start) + NatsUtils.envValue(key, config) + result.substring(end + 1);
        }
        return result;
    }

    public static String getSystem() {
        return (NatsUtils.osString(SystemUtil.OS, null) + NatsUtils.osString(SystemUtil.OS_ARCH, "-") + NatsUtils.osString(SystemUtil.OS_ARCH_TYPE, null)).replace("mips64", "linux-mips64le").replace("darwin-386", "darwin-amd64");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path download(URL source, Path target) {
        try (FileOutputStream fos = new FileOutputStream(target.toFile());){
            fos.getChannel().transferFrom(Channels.newChannel(source.openStream()), 0L, Long.MAX_VALUE);
            Path path = target;
            return path;
        }
        catch (Exception e) {
            throw new NatsDownloadException(e);
        }
    }

    public static Path unzip(Path source, Path target) throws IOException {
        try (ZipFile zipFile = new ZipFile(source.toFile());){
            ZipEntry max = zipFile.stream().max(Comparator.comparingLong(ZipEntry::getSize)).orElseThrow(() -> new IllegalStateException("File not found " + zipFile));
            Files.copy(zipFile.getInputStream(max), target, new CopyOption[0]);
        }
        catch (ZipException ze) {
            Files.copy(new FileInputStream(source.toFile()), target, new CopyOption[0]);
        }
        Files.deleteIfExists(source);
        return target;
    }

    public static void validatePort(int port, long timeoutMs, boolean untilFree, Supplier<Exception> onFail) throws Exception {
        if (!NatsUtils.waitForPort(port, timeoutMs, untilFree)) {
            throw onFail.get();
        }
    }

    public static boolean waitForPort(int port, long timeoutMs, boolean isFree) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeoutMs) {
            if (NatsUtils.isPortAvailable(port) == isFree) {
                return true;
            }
            Thread.yield();
        }
        return timeoutMs <= 0L;
    }

    public static boolean isPortAvailable(int port) {
        try {
            new Socket("localhost", port).close();
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public static int getNextFreePort(int startPort) {
        for (int i = 1; i < 1024; ++i) {
            int port = i + startPort;
            if (NatsUtils.isPortInUse(port)) continue;
            return port;
        }
        throw new IllegalStateException("Could not find any free port");
    }

    public static boolean isPortInUse(int portNumber) {
        try {
            new Socket("localhost", portNumber).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() <= 0;
    }

    private static String envValue(String key, Map<NatsConfig, MapValue> config) {
        return Optional.ofNullable(config.get((Object)NatsConfig.valueOf(key))).map(MapValue::value).orElseGet(() -> NatsUtils.getEnv(key, () -> ""));
    }

    public static String removeQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static List<Supplier<Path>> createPathSuppliers(String pathString) {
        ArrayList<Supplier<Path>> suppliers = new ArrayList<Supplier<Path>>();
        suppliers.add(() -> Paths.get(pathString, new String[0]));
        suppliers.add(() -> {
            try (Stream<Path> walk = Files.walk(Paths.get(System.getProperty("user.dir"), new String[0]), new FileVisitOption[0]);){
                Path path2 = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().equals(pathString)).findFirst().orElse(null);
                return path2;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        });
        return suppliers;
    }

    private static String osString(Enum<?> input, String prefix) {
        if (input != null && !input.name().contains("UNKNOWN")) {
            return (prefix == null ? "" : "-") + input.toString().toLowerCase().replace("86", "386").replace("intel", "").replace("_", "");
        }
        return "";
    }
}

