/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.logic;

import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.natsserver.config.NatsConfig;
import berlin.yuna.natsserver.logic.NatsBase;
import berlin.yuna.natsserver.logic.NatsUtils;
import berlin.yuna.natsserver.model.MapValue;
import berlin.yuna.natsserver.model.ValueSource;
import berlin.yuna.natsserver.model.exception.NatsStartException;
import java.net.BindException;
import java.net.PortUnreachableException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Nats
extends NatsBase {
    public Nats() {
        super(new ArrayList<String>());
    }

    public Nats(List<String> customArgs) {
        super(customArgs);
    }

    public Nats(int port) {
        this();
        this.config(NatsConfig.PORT, String.valueOf(port));
    }

    public Nats(String ... kv) {
        this();
        this.config(kv);
    }

    public Map<NatsConfig, MapValue> config() {
        return this.config;
    }

    public Nats config(NatsConfig key, String value) {
        this.config.remove((Object)key);
        if (key.desc().startsWith("[/]")) {
            if (value.equals("true")) {
                this.addConfig(ValueSource.DSL, key, value);
            }
        } else {
            this.addConfig(ValueSource.DSL, key, value);
        }
        return this;
    }

    public Nats config(Map<NatsConfig, String> config) {
        config.forEach((key, value) -> this.addConfig(ValueSource.DSL, (NatsConfig)((Object)key), (String)value));
        return this;
    }

    public Nats config(String ... kv) {
        boolean isKey = true;
        String key = null;
        for (String property : kv) {
            if (isKey) {
                key = property;
            } else {
                this.config(NatsConfig.valueOf(key.toUpperCase().replace("-", "")), property);
            }
            isKey = !isKey;
        }
        return this;
    }

    public Nats tryStart() {
        return this.tryStart(TimeUnit.SECONDS.toMillis(10L));
    }

    public Nats tryStart(long timeoutMs) {
        try {
            this.start(timeoutMs);
            return this;
        }
        catch (Exception e) {
            throw new NatsStartException(e);
        }
    }

    public Nats start() throws Exception {
        return this.start(TimeUnit.SECONDS.toMillis(10L));
    }

    public synchronized Nats start(long timeoutMs) throws Exception {
        if (this.terminal != null && this.terminal.running()) {
            this.logger.severe(() -> String.format("[%s] is already running", this.name));
            return this;
        }
        int port = this.setNextFreePort().port();
        NatsUtils.validatePort(port, timeoutMs, true, () -> new BindException("Address already in use [" + port + "]"));
        Path binaryPath = this.downloadNats();
        this.logger.fine(() -> String.format("Starting [%s] port [%s] version [%s]", this.name, port, this.getValue(NatsConfig.NATS_SYSTEM)));
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.logger::info;
        Consumer[] consumerArray2 = new Consumer[1];
        consumerArray2[0] = this.logger::severe;
        this.terminal = new Terminal().consumerInfoStream(consumerArray).consumerErrorStream(consumerArray2).timeoutMs(timeoutMs > 0L ? timeoutMs : 10000L).breakOnError(false).execute(this.prepareCommand(), null);
        NatsUtils.validatePort(port, timeoutMs, false, () -> new PortUnreachableException(this.name + " failed to start with port [" + port + "]"));
        this.logger.info(() -> String.format("Started [%s] port [%s] version [%s] pid [%s]", this.name, port, this.getValue(NatsConfig.NATS_SYSTEM), this.pid()));
        return this;
    }

    @Override
    public void close() {
        this.stop();
    }

    public Nats stop() {
        return this.stop(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Nats stop(long timeoutMs) {
        try {
            this.sendStopSignal();
            this.waitForShutDown(timeoutMs);
            this.terminal.process().destroy();
            this.terminal.process().waitFor();
        }
        catch (InterruptedException | NullPointerException ignored) {
            this.logger.warning(() -> String.format("Could not find process to stop [%s]", this.name));
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.port() > -1) {
                NatsUtils.waitForPort(this.port(), timeoutMs, true);
                this.logger.info(() -> String.format("Stopped [%s]", this.name));
            }
        }
        this.deletePidFile();
        return this;
    }

    private void waitForShutDown(long timeoutMs) {
        Optional.of(this.port()).filter(port -> port > 0).ifPresent(port -> {
            this.logger.info(() -> String.format("Stopped [%s]", this.name));
            NatsUtils.waitForPort(port, timeoutMs, true);
        });
    }

    private void sendStopSignal() {
        this.logger.info(() -> String.format("Stopping [%s]", this.name));
        if (this.pid() != -1) {
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = this.logger::info;
            Consumer[] consumerArray2 = new Consumer[1];
            consumerArray2[0] = this.logger::severe;
            new Terminal().consumerInfoStream(consumerArray).consumerErrorStream(consumerArray2).breakOnError(false).execute(this.binaryFile() + " " + NatsConfig.SIGNAL.key() + " stop=" + this.pid());
        }
    }
}

